/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class MinedWithFireAspectFilter
extends LootPredicate {
    @Override
    public String getKey() {
        return "mined_with_fire_aspect";
    }

    @Override
    public Material getIcon() {
        return Material.FIRE_CHARGE;
    }

    @Override
    public String getDisplayName() {
        return "&fMined with Fire Aspect";
    }

    @Override
    public String getDescription() {
        return "&fRequires the block to be mined with Fire Aspect";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the block to " + (this.isInverted() ? "&cNOT&f " : "") + "be mined with Fire Aspect";
    }

    @Override
    public LootPredicate createNew() {
        return new MinedWithFireAspectFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(new HashSet());
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        }
    }

    @Override
    public boolean test(LootContext context) {
        Player p;
        Entity entity = context.getLootedEntity();
        if (!(entity instanceof Player) || ItemUtils.isEmpty((p = (Player)entity).getInventory().getItemInMainHand())) {
            return this.inverted;
        }
        return p.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.FIRE_ASPECT) > 0 != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.BREAK;
    }
}

