/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import me.athlaeos.valhallammo.utility.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;

public class MinedWithToolFilter
extends LootPredicate {
    private final List<Pair<String, Integer>> tools = new ArrayList<Pair<String, Integer>>();

    @Override
    public String getKey() {
        return "mined_with_tool";
    }

    @Override
    public Material getIcon() {
        return Material.DIAMOND_PICKAXE;
    }

    @Override
    public String getDisplayName() {
        return "&fMined with Tool";
    }

    @Override
    public String getDescription() {
        return "&fRequires the block to be mined with specific tool types";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the block to " + (this.isInverted() ? "&cNOT&f " : "") + "be mined with &e" + this.tools.stream().map(b -> (String)b.getOne() + (String)(b.getTwo() == null ? "" : "(" + String.valueOf(b.getTwo()) + ")")).collect(Collectors.joining(", "));
    }

    @Override
    public LootPredicate createNew() {
        return new MinedWithToolFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(12, new ItemBuilder(Material.TNT).name("&eSelect Tool").lore("&6Click with item in cursor to", "&6add required tool type", "&fIf tool also has custom model", "&fdata, it is required also", "&cShift-Click to clear list", "&fCurrently: ").appendLore(this.tools.isEmpty() ? List.of("&cNone, condition always passes") : this.tools.stream().map(b -> "&f>" + (String)b.getOne() + (String)(b.getTwo() == null ? "" : "(" + String.valueOf(b.getTwo()) + ")")).toList()).get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        ItemStack cursor = e.getCursor();
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 12) {
            if (!ItemUtils.isEmpty(cursor) && !e.isShiftClick()) {
                ItemMeta meta = ItemUtils.getItemMeta(cursor);
                if (meta == null) {
                    return;
                }
                Integer data = meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null;
                this.tools.add(new Pair<String, Integer>(ItemUtils.getItemType(e.getCursor()), data));
            } else if (e.isShiftClick()) {
                this.tools.clear();
            }
        }
    }

    @Override
    public boolean test(LootContext context) {
        Entity entity;
        if (this.tools.isEmpty() || !((entity = context.getLootedEntity()) instanceof Player)) {
            return this.inverted;
        }
        Player p = (Player)entity;
        ItemStack tool = p.getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(tool)) {
            return this.inverted;
        }
        ItemMeta meta = ItemUtils.getItemMeta(tool);
        if (meta == null) {
            return this.inverted;
        }
        return this.tools.stream().anyMatch(pair -> ((String)pair.getOne()).equals(ItemUtils.getItemType(tool)) && (pair.getTwo() == null && !meta.hasCustomModelData() || meta.hasCustomModelData() && pair.getTwo() != null && meta.getCustomModelData() == ((Integer)pair.getTwo()).intValue())) != this.inverted;
    }

    @Override
    public boolean isCompatibleWithLootType(LootTable.LootType type) {
        return type == LootTable.LootType.BREAK;
    }
}

