/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.loot.predicates.implementations;

import java.util.Map;
import java.util.Set;
import me.athlaeos.valhallammo.dom.DayTime;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.loot.predicates.LootPredicate;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;

public class TimePeriodFilter
extends LootPredicate {
    private int after = 8000;
    private int before = 16000;

    @Override
    public String getKey() {
        return "time_range";
    }

    @Override
    public Material getIcon() {
        return Material.CLOCK;
    }

    @Override
    public String getDisplayName() {
        return "&fTime Range";
    }

    @Override
    public String getDescription() {
        return "&fRequires world to be between specific times";
    }

    @Override
    public String getActiveDescription() {
        return "&fRequires the world time to " + (this.isInverted() ? "&cNOT&f " : "") + "be after &e" + this.after + " &fand before &e" + this.before;
    }

    @Override
    public LootPredicate createNew() {
        return new TimePeriodFilter();
    }

    @Override
    public Map<Integer, ItemStack> getButtons() {
        return new Pair<Integer, ItemStack>(2, new ItemBuilder(Material.TNT).name("&eInvert Condition").lore(this.inverted ? "&cCondition is inverted" : "&aCondition not inverted", "&fInverted conditions must &cnot &fpass", "&fthis condition. ", "&6Click to toggle").get()).map(Set.of(new Pair<Integer, ItemStack>(11, new ItemBuilder(Material.CLOCK).name("&eSelect After").lore("&eIs currently " + this.after, "&fTime must " + (this.isInverted() ? "&cNOT&f " : "") + "be between", String.format("&f%d(%s) and %d(%s)", new Object[]{this.before, DayTime.getTime(this.before), this.after, DayTime.getTime(this.after)}), "&6Click to add/subtract 100", "&6Shift-Click to add/subtract 1000").get()), new Pair<Integer, ItemStack>(13, new ItemBuilder(Material.CLOCK).name("&eSelect Before").lore("&eIs currently " + this.before, "&fTime must " + (this.isInverted() ? "&cNOT&f " : "") + "be between", String.format("&f%d(%s) and %d(%s)", new Object[]{this.before, DayTime.getTime(this.before), this.after, DayTime.getTime(this.after)}), "&6Click to add/subtract 100", "&6Shift-Click to add/subtract 1000").get())));
    }

    @Override
    public void onButtonPress(InventoryClickEvent e, int button) {
        if (button == 2) {
            this.inverted = !this.inverted;
        } else if (button == 11) {
            this.after = Math.max(0, Math.max(Math.min(24000, this.before), this.after + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
        } else if (button == 13) {
            this.before = Math.max(0, Math.min(Math.min(24000, this.after), this.before + (e.isLeftClick() ? 1 : -1) * (e.isShiftClick() ? 1000 : 100)));
        }
    }

    @Override
    public boolean test(LootContext context) {
        World w = context.getLocation().getWorld();
        if (w == null) {
            return true;
        }
        if (this.after > this.before) {
            int temp = this.after;
            this.after = this.before;
            this.before = temp;
        }
        return (w.getTime() >= (long)this.before && w.getTime() <= (long)this.after) != this.inverted;
    }
}

