/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.block.DigPacketInfo;
import me.athlaeos.valhallammo.dom.EquippableWrapper;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.dom.Structures;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.nms.NMS;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.AttributeMappings;
import me.athlaeos.valhallammo.version.EnchantmentMappings;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.generator.strucutre.CraftStructure;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public final class NMS_v1_19_R1
implements NMS {
    @Override
    public void forceAttack(Player player, LivingEntity victim) {
        ((CraftPlayer)player).getHandle().d(((CraftEntity)victim).getHandle());
    }

    @Override
    public Channel channel(Player p) {
        return ((CraftPlayer)p).getHandle().b.b.m;
    }

    @Override
    public Pair<Location, Structures> getNearestStructure(World world, Location location, Map<Structures, Integer> structuresToFind) {
        HashSet<Pair<Integer, Integer>> chunksToScan = new HashSet<Pair<Integer, Integer>>();
        int cX = location.getChunk().getX();
        int cZ = location.getChunk().getZ();
        int maxRadius = Collections.max(structuresToFind.values());
        for (int x = cX - maxRadius; x <= cX + maxRadius; ++x) {
            for (int z = cZ - maxRadius; z <= cZ + maxRadius; ++z) {
                chunksToScan.add(new Pair<Integer, Integer>(x, z));
            }
        }
        Pair<Location, Structures> found = null;
        int closest = Integer.MAX_VALUE;
        CraftServer server = (CraftServer)Bukkit.getServer();
        IRegistryCustom.Dimension access = server.getServer().aX();
        for (Pair pair : chunksToScan) {
            Map structures = ((CraftWorld)world).getHandle().a(((Integer)pair.getOne()).intValue(), ((Integer)pair.getTwo()).intValue(), ChunkStatus.e).g();
            for (Structure s : structures.keySet()) {
                int maxDistance;
                Structures structure = Structures.fromStructure(CraftStructure.minecraftToBukkit((Structure)s, (IRegistryCustom)access));
                if (structure == null) continue;
                StructureStart start = (StructureStart)structures.get(s);
                int distance = Utils.getManhattanDistance(location.getChunk().getX(), location.getChunk().getZ(), (Integer)pair.getOne(), (Integer)pair.getTwo());
                if (!structuresToFind.containsKey((Object)structure) || distance > (maxDistance = structuresToFind.get((Object)structure).intValue()) || distance > closest) continue;
                closest = distance;
                BlockPosition pos = start.a().f();
                Location loc = new Location(location.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w());
                found = new Pair<Location, Structures>(loc, structure);
            }
        }
        return found;
    }

    @Override
    public DigPacketInfo readDiggingPacket(Player p, Object packet) {
        if (!(packet instanceof PacketPlayInBlockDig)) {
            return null;
        }
        PacketPlayInBlockDig digPacket = (PacketPlayInBlockDig)packet;
        BlockPosition pos = digPacket.b();
        return new DigPacketInfo(p, pos.u(), pos.v(), pos.w(), DigPacketInfo.fromName(digPacket.d().name()));
    }

    @Override
    public void blockBreakAnimation(Player p, org.bukkit.block.Block b, int id, int stage) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        PlayerConnection playerConnection = entityPlayer.b;
        BlockPosition blockPosition = new BlockPosition(b.getX(), b.getY(), b.getZ());
        playerConnection.a((Packet)new PacketPlayOutBlockBreakAnimation(id, blockPosition, stage));
    }

    @Override
    public void blockParticleAnimation(org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK_CRACK, b.getLocation().add(0.5, 0.0, 0.5), 10, (Object)b.getBlockData());
    }

    @Override
    public float toolPower(ItemStack tool, org.bukkit.block.Block b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            WorldServer nmsWorld = ((CraftWorld)b.getWorld()).getHandle();
            Block nmsBlock = nmsWorld.a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            return craftItemStack.a(nmsBlock.m());
        }
        return 1.0f;
    }

    @Override
    public float toolPower(ItemStack tool, Material b) {
        if (!ItemUtils.isEmpty(tool)) {
            net.minecraft.world.item.ItemStack craftItemStack = CraftItemStack.asNMSCopy((ItemStack)tool);
            CraftBlockData data = (CraftBlockData)b.createBlockData();
            return craftItemStack.a(data.getState());
        }
        return 1.0f;
    }

    @Override
    public void breakBlock(Player p, org.bukkit.block.Block b) {
        b.getWorld().spawnParticle(Particle.BLOCK_CRACK, b.getLocation().add(0.5, 0.5, 0.5), 100, 0.1, 0.1, 0.1, 4.0, (Object)b.getBlockData());
        b.getWorld().playSound(b.getLocation(), b.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
        ((CraftPlayer)p).getHandle().d.a(new BlockPosition(b.getX(), b.getY(), b.getZ()));
    }

    @Override
    public Sound blockSound(org.bukkit.block.Block b) {
        try {
            WorldServer nmsWorld = ((CraftWorld)b.getWorld()).getHandle();
            Block nmsBlock = nmsWorld.a_(new BlockPosition(b.getX(), b.getY(), b.getZ())).b();
            SoundEffectType soundEffectType = nmsBlock.m(nmsBlock.m());
            Field soundEffectField = soundEffectType.getClass().getDeclaredField("fallSound");
            soundEffectField.setAccessible(true);
            SoundEffect soundEffect = (SoundEffect)soundEffectField.get(soundEffectType);
            Field keyField = SoundEffect.class.getDeclaredField("CODEC");
            keyField.setAccessible(true);
            MinecraftKey minecraftKey = (MinecraftKey)keyField.get(soundEffect);
            return Sound.valueOf((String)minecraftKey.a().toUpperCase(Locale.US).replace(".", "_").replace("_FALL", "_HIT"));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return Sound.BLOCK_STONE_HIT;
        }
    }

    @Override
    public void resetAttackCooldown(Player p) {
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        entityPlayer.fV();
    }

    @Override
    public void setEdible(ItemBuilder meta, boolean edible, boolean canAlwaysEat, float eatTimeSeconds) {
    }

    @Override
    public void setGlint(ItemMeta meta, boolean glint) {
    }

    @Override
    public void setMaxStackSize(ItemMeta meta, int stackSize) {
    }

    @Override
    public int getMaxStackSize(ItemMeta meta, Material baseMaterial) {
        return baseMaterial.getMaxStackSize();
    }

    @Override
    public void setFireResistant(ItemMeta meta, boolean fireResistant) {
    }

    @Override
    public void setHideTooltip(ItemMeta meta, boolean hideToolTip) {
    }

    @Override
    public void setBookContents(ItemStack book, List<BaseComponent[]> pages) {
    }

    @Override
    public Enchantment getEnchantment(EnchantmentMappings mappedTo) {
        return NMS_v1_19_R1.oldMappings(mappedTo);
    }

    @Override
    public PotionType getPotionType(PotionMeta meta) {
        return meta.getBasePotionData().getType();
    }

    @Override
    public PotionEffectType getPotionEffectType(PotionEffectMappings mappedTo) {
        return NMS_v1_19_R1.oldMappings(mappedTo);
    }

    @Override
    public Attribute getAttribute(AttributeMappings mappedTo) {
        return NMS_v1_19_R1.getMappedAttribute(mappedTo);
    }

    public static Attribute getMappedAttribute(AttributeMappings mappedTo) {
        return switch (mappedTo) {
            case AttributeMappings.LUCK -> Attribute.GENERIC_LUCK;
            case AttributeMappings.ARMOR -> Attribute.GENERIC_ARMOR;
            case AttributeMappings.MAX_HEALTH -> Attribute.GENERIC_MAX_HEALTH;
            case AttributeMappings.ATTACK_SPEED -> Attribute.GENERIC_ATTACK_SPEED;
            case AttributeMappings.FLYING_SPEED -> Attribute.GENERIC_FLYING_SPEED;
            case AttributeMappings.ATTACK_DAMAGE -> Attribute.GENERIC_ATTACK_DAMAGE;
            case AttributeMappings.MOVEMENT_SPEED -> Attribute.GENERIC_MOVEMENT_SPEED;
            case AttributeMappings.ARMOR_TOUGHNESS -> Attribute.GENERIC_ARMOR_TOUGHNESS;
            case AttributeMappings.ATTACK_KNOCKBACK -> Attribute.GENERIC_ATTACK_KNOCKBACK;
            case AttributeMappings.HORSE_JUMP_STRENGTH -> Attribute.HORSE_JUMP_STRENGTH;
            case AttributeMappings.KNOCKBACK_RESISTANCE -> Attribute.GENERIC_KNOCKBACK_RESISTANCE;
            case AttributeMappings.SPAWN_REINFORCEMENTS -> Attribute.ZOMBIE_SPAWN_REINFORCEMENTS;
            default -> null;
        };
    }

    @Override
    public boolean isUpgraded(PotionMeta meta) {
        return meta.getBasePotionData().isUpgraded();
    }

    @Override
    public boolean isExtended(PotionMeta meta) {
        return meta.getBasePotionData().isExtended();
    }

    @Override
    public void setPotionType(PotionMeta meta, PotionType type) {
        meta.setBasePotionData(new PotionData(type, false, false));
    }

    @Override
    public void addUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type, double amount, AttributeModifier.Operation operation) {
        NMS_v1_19_R1.addAttribute(e, uuid, identifier, type, amount, operation);
    }

    @Override
    public boolean hasUniqueAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_19_R1.hasAttribute(e, uuid, identifier, type);
    }

    @Override
    public double getUniqueAttributeValue(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        return NMS_v1_19_R1.getAttributeValue(e, uuid, identifier, type);
    }

    @Override
    public void removeUniqueAttribute(LivingEntity e, String identifier, Attribute type) {
        NMS_v1_19_R1.removeAttribute(e, identifier, type);
    }

    public static Enchantment oldMappings(EnchantmentMappings mapping) {
        return switch (mapping) {
            case EnchantmentMappings.FLAME -> Enchantment.ARROW_FIRE;
            case EnchantmentMappings.POWER -> Enchantment.ARROW_DAMAGE;
            case EnchantmentMappings.INFINITY -> Enchantment.ARROW_INFINITE;
            case EnchantmentMappings.PUNCH -> Enchantment.ARROW_KNOCKBACK;
            case EnchantmentMappings.CURSE_OF_BINDING -> Enchantment.BINDING_CURSE;
            case EnchantmentMappings.CHANNELING -> Enchantment.CHANNELING;
            case EnchantmentMappings.SHARPNESS -> Enchantment.DAMAGE_ALL;
            case EnchantmentMappings.BANE_OF_ARTHROPODS -> Enchantment.DAMAGE_ARTHROPODS;
            case EnchantmentMappings.SMITE -> Enchantment.DAMAGE_UNDEAD;
            case EnchantmentMappings.DEPTH_STRIDER -> Enchantment.DEPTH_STRIDER;
            case EnchantmentMappings.EFFICIENCY -> Enchantment.DIG_SPEED;
            case EnchantmentMappings.UNBREAKING -> Enchantment.DURABILITY;
            case EnchantmentMappings.FIRE_ASPECT -> Enchantment.FIRE_ASPECT;
            case EnchantmentMappings.FROST_WALKER -> Enchantment.FROST_WALKER;
            case EnchantmentMappings.IMPALING -> Enchantment.IMPALING;
            case EnchantmentMappings.KNOCKBACK -> Enchantment.KNOCKBACK;
            case EnchantmentMappings.FORTUNE -> Enchantment.LOOT_BONUS_BLOCKS;
            case EnchantmentMappings.LOOTING -> Enchantment.LOOT_BONUS_MOBS;
            case EnchantmentMappings.LOYALTY -> Enchantment.LOYALTY;
            case EnchantmentMappings.LUCK_OF_THE_SEA -> Enchantment.LUCK;
            case EnchantmentMappings.LURE -> Enchantment.LURE;
            case EnchantmentMappings.MENDING -> Enchantment.MENDING;
            case EnchantmentMappings.MULTISHOT -> Enchantment.MULTISHOT;
            case EnchantmentMappings.RESPIRATION -> Enchantment.OXYGEN;
            case EnchantmentMappings.PIERCING -> Enchantment.PIERCING;
            case EnchantmentMappings.PROTECTION -> Enchantment.PROTECTION_ENVIRONMENTAL;
            case EnchantmentMappings.BLAST_PROTECTION -> Enchantment.PROTECTION_EXPLOSIONS;
            case EnchantmentMappings.FEATHER_FALLING -> Enchantment.PROTECTION_FALL;
            case EnchantmentMappings.FIRE_PROTECTION -> Enchantment.PROTECTION_FIRE;
            case EnchantmentMappings.PROJECTILE_PROTECTION -> Enchantment.PROTECTION_PROJECTILE;
            case EnchantmentMappings.QUICK_CHARGE -> Enchantment.QUICK_CHARGE;
            case EnchantmentMappings.RIPTIDE -> Enchantment.RIPTIDE;
            case EnchantmentMappings.SILK_TOUCH -> Enchantment.SILK_TOUCH;
            case EnchantmentMappings.SOUL_SPEED -> Enchantment.SOUL_SPEED;
            case EnchantmentMappings.SWEEPING_EDGE -> Enchantment.SWEEPING_EDGE;
            case EnchantmentMappings.THORNS -> Enchantment.THORNS;
            case EnchantmentMappings.CURSE_OF_VANISHING -> Enchantment.VANISHING_CURSE;
            case EnchantmentMappings.AQUA_AFFINITY -> Enchantment.WATER_WORKER;
            default -> null;
        };
    }

    public static PotionEffectType oldMappings(PotionEffectMappings mapping) {
        return switch (mapping) {
            case PotionEffectMappings.LUCK -> PotionEffectType.LUCK;
            case PotionEffectMappings.HASTE -> PotionEffectType.FAST_DIGGING;
            case PotionEffectMappings.SPEED -> PotionEffectType.SPEED;
            case PotionEffectMappings.HUNGER -> PotionEffectType.HUNGER;
            case PotionEffectMappings.NAUSEA -> PotionEffectType.CONFUSION;
            case PotionEffectMappings.POISON -> PotionEffectType.POISON;
            case PotionEffectMappings.WITHER -> PotionEffectType.WITHER;
            case PotionEffectMappings.GLOWING -> PotionEffectType.GLOWING;
            case PotionEffectMappings.BAD_LUCK -> PotionEffectType.UNLUCK;
            case PotionEffectMappings.DARKNESS -> PotionEffectType.DARKNESS;
            case PotionEffectMappings.BAD_OMEN -> PotionEffectType.BAD_OMEN;
            case PotionEffectMappings.SLOWNESS -> PotionEffectType.SLOW;
            case PotionEffectMappings.STRENGTH -> PotionEffectType.INCREASE_DAMAGE;
            case PotionEffectMappings.WEAKNESS -> PotionEffectType.WEAKNESS;
            case PotionEffectMappings.BLINDNESS -> PotionEffectType.BLINDNESS;
            case PotionEffectMappings.ABSORPTION -> PotionEffectType.ABSORPTION;
            case PotionEffectMappings.LEVITATION -> PotionEffectType.LEVITATION;
            case PotionEffectMappings.JUMP_BOOST -> PotionEffectType.JUMP;
            case PotionEffectMappings.RESISTANCE -> PotionEffectType.DAMAGE_RESISTANCE;
            case PotionEffectMappings.SATURATION -> PotionEffectType.SATURATION;
            case PotionEffectMappings.HEALTH_BOOST -> PotionEffectType.HEALTH_BOOST;
            case PotionEffectMappings.INVISIBILITY -> PotionEffectType.INVISIBILITY;
            case PotionEffectMappings.REGENERATION -> PotionEffectType.REGENERATION;
            case PotionEffectMappings.NIGHT_VISION -> PotionEffectType.NIGHT_VISION;
            case PotionEffectMappings.SLOW_FALLING -> PotionEffectType.SLOW_FALLING;
            case PotionEffectMappings.CONDUIT_POWER -> PotionEffectType.CONDUIT_POWER;
            case PotionEffectMappings.DOLPHINS_GRACE -> PotionEffectType.DOLPHINS_GRACE;
            case PotionEffectMappings.INSTANT_DAMAGE -> PotionEffectType.HARM;
            case PotionEffectMappings.INSTANT_HEALTH -> PotionEffectType.HEAL;
            case PotionEffectMappings.MINING_FATIGUE -> PotionEffectType.SLOW_DIGGING;
            case PotionEffectMappings.FIRE_RESISTANCE -> PotionEffectType.FIRE_RESISTANCE;
            case PotionEffectMappings.WATER_BREATHING -> PotionEffectType.WATER_BREATHING;
            case PotionEffectMappings.HERO_OF_THE_VILLAGE -> PotionEffectType.HERO_OF_THE_VILLAGE;
            default -> null;
        };
    }

    public static void addAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type, double amount, AttributeModifier.Operation operation) {
        AttributeInstance instance = e.getAttribute(type);
        if (instance != null) {
            instance.getModifiers().stream().filter(m -> m != null && m.getName().equals(identifier)).forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
            if (amount != 0.0) {
                instance.addModifier(new AttributeModifier(uuid, identifier, amount, operation));
            }
        }
    }

    public static boolean hasAttribute(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        AttributeInstance instance = e.getAttribute(type);
        return instance != null && instance.getModifiers().stream().anyMatch(m -> m != null && m.getName().equals(identifier));
    }

    public static double getAttributeValue(LivingEntity e, UUID uuid, String identifier, Attribute type) {
        AttributeInstance instance = e.getAttribute(type);
        if (instance != null) {
            return instance.getModifiers().stream().filter(m -> m != null && m.getName().equals(identifier) && m.getUniqueId().equals(uuid)).map(AttributeModifier::getAmount).findFirst().orElse(0.0);
        }
        return 0.0;
    }

    public static void removeAttribute(LivingEntity e, String identifier, Attribute type) {
        AttributeInstance instance = e.getAttribute(type);
        if (instance != null) {
            instance.getModifiers().stream().filter(m -> m != null && m.getName().equals(identifier)).forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
        }
    }

    @Override
    public void setItemModel(ItemMeta meta, String model) {
    }

    @Override
    public void setEquippable(ItemMeta meta, String modelKey, EquipmentSlot slot, String cameraOverlayKey, Sound equipSound, List<EntityType> allowedTypes) {
    }

    @Override
    public void setToolTipStyle(ItemMeta meta, String namespacedKey) {
    }

    @Override
    public String getItemModel(ItemMeta meta) {
        return null;
    }

    @Override
    public EquippableWrapper getEquippable(ItemMeta meta) {
        return null;
    }

    @Override
    public String getToolTipStyle(ItemMeta meta) {
        return null;
    }
}

