/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.nms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.event.ValhallaLootPopulateEvent;
import me.athlaeos.valhallammo.event.ValhallaLootReplacementEvent;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrialSpawner;
import org.bukkit.block.data.type.Vault;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;

public class VaultLootListener
implements Listener {
    private static final Map<Material, Collection<LootTables>> vaultMaterialToLikelyTableMappings = new HashMap<Material, Collection<LootTables>>();
    private static final Map<Material, Collection<LootTables>> vaultMaterialToLikelyOminousTableMappings = new HashMap<Material, Collection<LootTables>>();
    private static final Map<Material, Collection<LootTables>> spawnerMaterialToLikelyTableMappings = new HashMap<Material, Collection<LootTables>>();
    private static final Map<Material, Collection<LootTables>> spawnerMaterialToLikelyOminousTableMappings = new HashMap<Material, Collection<LootTables>>();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onVaultDispenseItem(BlockDispenseLootEvent e) {
        boolean bl;
        BlockData data = e.getBlock().getBlockData();
        if (!(data instanceof Vault) && !(data instanceof TrialSpawner)) {
            return;
        }
        if (data instanceof Vault) {
            Vault v = (Vault)data;
            bl = v.isOminous();
        } else {
            bl = ((TrialSpawner)data).isOminous();
        }
        boolean isOminous = bl;
        boolean isVault = data instanceof Vault;
        LikelyTables likelyTables = VaultLootListener.getLikelyLootTables(e.getDispensedLoot(), isOminous, isVault);
        ArrayList<DropDetails> details = new ArrayList<DropDetails>();
        Player player = e.getPlayer();
        AttributeInstance luckAttribute = player == null ? null : player.getAttribute(Attribute.GENERIC_LUCK);
        float luck = (float)(luckAttribute == null ? 0.0 : luckAttribute.getValue());
        LootContext context = new LootContext.Builder(e.getBlock().getLocation()).luck(luck).killer((HumanEntity)player).lootedEntity((Entity)player).build();
        boolean clearVanilla = false;
        for (LootTables table : likelyTables.likelyTables) {
            LootTable valhallaTable = LootTableRegistry.getLootTable(table);
            if (valhallaTable != null) {
                List<ItemStack> loot = LootTableRegistry.getLoot(valhallaTable, context, LootTable.LootType.VAULT);
                ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(valhallaTable, context, loot);
                ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
                if (!loottableEvent.isCancelled()) {
                    boolean clear;
                    switch (loottableEvent.getPreservationType()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case CLEAR: {
                            boolean bl2 = true;
                            break;
                        }
                        case CLEAR_UNLESS_EMPTY: {
                            boolean bl2;
                            if (!loottableEvent.getDrops().isEmpty()) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case KEEP: {
                            boolean bl2 = clear = false;
                        }
                    }
                    if (clear) {
                        clearVanilla = true;
                    }
                    details.addAll(loottableEvent.getDrops().stream().map(i -> new DropDetails((ItemStack)i, true, table)).toList());
                }
            } else {
                ItemStack vanillaDrop;
                ArrayList vanillaLoot = new ArrayList(table.getLootTable().populateLoot(Utils.getRandom(), context));
                ItemStack itemStack = vanillaDrop = vanillaLoot.isEmpty() ? null : (ItemStack)vanillaLoot.get(0);
                if (!ItemUtils.isEmpty(vanillaDrop)) {
                    details.add(new DropDetails(vanillaDrop, false, table));
                }
            }
            if (clearVanilla) {
                details.removeIf(d -> !d.isValhalla);
            }
            ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(likelyTables.unmatchedItems);
            for (DropDetails d2 : details) {
                ItemStack globalReplacement;
                ItemStack item;
                if (clearVanilla && !d2.isValhalla) continue;
                ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(d2.table);
                ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
                ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
                if (replacementTable != null) {
                    ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
                }
                if (replacementTable != null && event.isCancelled() || ItemUtils.isEmpty(item = d2.drop)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.VAULT, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.VAULT, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                newItems.add(item);
            }
            e.setDispensedLoot(newItems);
        }
    }

    private static LikelyTables getLikelyLootTables(List<ItemStack> drops, boolean isOminous, boolean isVault) {
        ArrayList<LootTables> likelyTables = new ArrayList<LootTables>();
        ArrayList<ItemStack> unmatchedItems = new ArrayList<ItemStack>();
        Map<Material, Collection<LootTables>> map = isOminous ? (isVault ? vaultMaterialToLikelyOminousTableMappings : spawnerMaterialToLikelyOminousTableMappings) : (isVault ? vaultMaterialToLikelyTableMappings : spawnerMaterialToLikelyTableMappings);
        int rareCount = 0;
        int commonCount = 0;
        int uniqueCount = 0;
        for (ItemStack i2 : drops) {
            if (isVault && ((Collection)map.getOrDefault(i2.getType(), new HashSet())).stream().anyMatch(l -> l.getLootTable().toString().contains("COMMON"))) {
                ++commonCount;
                continue;
            }
            if (isVault && ((Collection)map.getOrDefault(i2.getType(), new HashSet())).stream().anyMatch(l -> l.getLootTable().toString().contains("RARE"))) {
                ++rareCount;
                continue;
            }
            if (isVault && ((Collection)map.getOrDefault(i2.getType(), new HashSet())).stream().anyMatch(l -> l.getLootTable().toString().contains("UNIQUE"))) {
                ++uniqueCount;
                continue;
            }
            ArrayList possibilities = new ArrayList(map.getOrDefault(i2.getType(), new HashSet()));
            if (possibilities.isEmpty()) {
                unmatchedItems.add(i2);
                continue;
            }
            ItemMeta meta = i2.getItemMeta();
            if (meta != null && (meta.hasDisplayName() || meta.hasLore() || meta.hasCustomModelData())) {
                unmatchedItems.add(i2);
                continue;
            }
            likelyTables.add((LootTables)possibilities.get(0));
        }
        if (isVault) {
            if (rareCount == 0 && commonCount >= 3) {
                ++rareCount;
                --commonCount;
            }
            Utils.repeat(rareCount, i -> likelyTables.add(isOminous ? LootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE : LootTables.TRIAL_CHAMBERS_REWARD_RARE));
            Utils.repeat(commonCount, i -> likelyTables.add(isOminous ? LootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON : LootTables.TRIAL_CHAMBERS_REWARD_COMMON));
            Utils.repeat(uniqueCount, i -> likelyTables.add(isOminous ? LootTables.TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE : LootTables.TRIAL_CHAMBERS_REWARD_UNIQUE));
        }
        return new LikelyTables(likelyTables, unmatchedItems);
    }

    private static void map(boolean ominous, boolean vault, String material, String ... likelyLootTables) {
        Material mat = Catch.catchOrElse(() -> Material.valueOf((String)material), null);
        Collection tables = Stream.of(likelyLootTables).map(s -> Catch.catchOrElse(() -> LootTables.valueOf((String)s), null)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (mat == null || tables.isEmpty()) {
            return;
        }
        if (ominous) {
            (vault ? vaultMaterialToLikelyOminousTableMappings : spawnerMaterialToLikelyOminousTableMappings).put(mat, tables);
        } else {
            (vault ? vaultMaterialToLikelyTableMappings : spawnerMaterialToLikelyTableMappings).put(mat, tables);
        }
    }

    static {
        VaultLootListener.map(false, true, "EMERALD", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "ARROW", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "TIPPED_ARROW", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "IRON_INGOT", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "WIND_CHARGE", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "HONEY_BOTTLE", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "OMINOUS_BOTTLE", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "SHIELD", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "BOW", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "WIND_CHARGE", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "DIAMOND", "TRIAL_CHAMBERS_REWARD_COMMON", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "GOLDEN_APPLE", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "ENCHANTED_BOOK", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "CROSSBOW", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "IRON_AXE", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "IRON_CHESTPLATE", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "DIAMOND_AXE", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "DIAMOND_CHESTPLATE", "TRIAL_CHAMBERS_REWARD_RARE");
        VaultLootListener.map(false, true, "BOLT_ARMOR_TRIM_SMITHING_TEMPLATE", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "MUSIC_DISC", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "MUSIC_DISC_PRECIPICE", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "GUSTER_BANNER_PATTERN", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "BANNER_PATTERN", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(false, true, "TRIDENT", "TRIAL_CHAMBERS_REWARD_UNIQUE");
        VaultLootListener.map(true, true, "EMERALD", "TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "WIND_CHARGE", "TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "TIPPED_ARROW", "TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "DIAMOND", "TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "FLOW_ARMOR_TRIM_SMITHING_TEMPLATE", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "ENCHANTED_GOLDEN_APPLE", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "FLOW_BANNER_PATTERN", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "BANNER_PATTERN", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "OMINOUS_BOTTLE", "TRIAL_CHAMBERS_REWARD_OMINOUS_COMMON", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "EMERALD_BLOCK", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "CROSSBOW", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "IRON_BLOCK", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "GOLDEN_APPLE", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "DIAMOND_AXE", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "DIAMOND_CHESTPLATE", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "MUSIC_DISC", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "MUSIC_DISC_CREATOR", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "HEAVY_CORE", "TRIAL_CHAMBERS_REWARD_OMINOUS_UNIQUE");
        VaultLootListener.map(true, true, "ENCHANTED_BOOK", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(true, true, "DIAMOND_BLOCK", "TRIAL_CHAMBERS_REWARD_OMINOUS_RARE");
        VaultLootListener.map(false, false, "TRIAL_KEY", "TRIAL_CHAMBER_KEY");
        VaultLootListener.map(false, false, "BREAD", "TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(false, false, "COOKED_CHICKEN", "TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(false, false, "BAKED_POTATO", "TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(false, false, "POTION", "TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(true, false, "OMINOUS_TRIAL_KEY", "OMINOUS_TRIAL_CHAMBER_KEY");
        VaultLootListener.map(true, false, "BAKED_POTATO", "OMINOUS_TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(true, false, "COOKED_BEEF", "OMINOUS_TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(true, false, "GOLDEN_CARROT", "OMINOUS_TRIAL_CHAMBER_CONSUMABLES");
        VaultLootListener.map(true, false, "POTION", "OMINOUS_TRIAL_CHAMBER_CONSUMABLES");
    }

    private record LikelyTables(List<LootTables> likelyTables, List<ItemStack> unmatchedItems) {
    }

    private record DropDetails(ItemStack drop, boolean isValhalla, LootTables table) {
    }
}

