/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.parties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.dom.Pair;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.parties.Party;
import me.athlaeos.valhallammo.parties.PartyChatListener;
import me.athlaeos.valhallammo.parties.PartyEXPGainListener;
import me.athlaeos.valhallammo.parties.PartyPvPListener;
import me.athlaeos.valhallammo.placeholder.PlaceholderRegistry;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PartyManager {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().create();
    private static final Map<String, Party> allParties = new HashMap<String, Party>();
    private static final Map<UUID, Party> partiesByMember = new HashMap<UUID, Party>();
    private static final TreeMap<Integer, PartyLevel> partyLevels = new TreeMap();
    private static final Map<Integer, Double> levelRequirements = new HashMap<Integer, Double>();
    private static final Map<String, PartyRank> partyRanks = new HashMap<String, PartyRank>();
    private static String leaderTitle;
    private static String lowestRank;
    private static String highestRank;
    private static final Map<UUID, Collection<String>> partyInvites;
    private static final Collection<UUID> partyChatPlayers;
    private static final Collection<UUID> partySpyPlayers;
    private static boolean enabledParties;
    private static boolean enabledEXPSharing;
    private static boolean enabledItemSharing;
    private static int partyCreationCooldown;
    private static int itemSharingCooldown;
    private static double partyEXPConversionRate;
    private static int partyRenameCooldown;
    private static int partyDescriptionChangeCooldown;
    private static Pattern legalCharactersPattern;
    private static int partyNameMinimum;
    private static int partyNameMaximum;
    private static int partyDescriptionMaximum;
    private static String partyChatFormat;
    private static String partySpyFormat;
    private static List<String> partyInfoFormat;
    private static String partyLevelUpFormat;
    private static final Map<String, Integer> defaultInts;
    private static final Map<String, Float> defaultFloats;
    private static final Map<String, Boolean> defaultBools;
    private static final Map<String, Double> defaultCompanyStats;
    private static final Map<String, Pair<Long, PartyLevel>> partyLevelCache;

    public static Collection<Player> membersInEXPSharingRadius(Player p) {
        HashSet<Player> nearbyMembers = new HashSet<Player>();
        if (!enabledEXPSharing) {
            return nearbyMembers;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return nearbyMembers;
        }
        float expSharingMultiplier = PartyManager.getTotalFloatStat("exp_sharing_multiplier", party);
        int expSharingRadius = PartyManager.getTotalIntStat("exp_sharing_radius", party);
        if (expSharingRadius == 0 || expSharingMultiplier <= 0.0f) {
            return nearbyMembers;
        }
        return PartyManager.membersInRadius(p, expSharingRadius).stream().filter(pl -> !WorldGuardHook.inDisabledRegion(pl.getLocation(), pl, "vmmo-party-expsharing")).collect(Collectors.toSet());
    }

    public static Collection<Player> membersInRadius(Player p, int radius) {
        Party party = PartyManager.getParty(p);
        HashSet<Player> nearbyMembers = new HashSet<Player>();
        if (party == null || radius == 0 || party.isExpSharingEnabled() != null && !party.isExpSharingEnabled().booleanValue()) {
            return nearbyMembers;
        }
        for (Player member : PartyManager.getOnlinePartyMembers(party)) {
            if (member.getUniqueId().equals(p.getUniqueId()) || radius >= 0 && (!p.getWorld().getName().equals(member.getWorld().getName()) || !(p.getLocation().distanceSquared(member.getLocation()) < (double)(radius * radius)))) continue;
            nearbyMembers.add(member);
        }
        return nearbyMembers;
    }

    public static double getCompanyStats(Player p, String stat) {
        if (!enabledParties) {
            return 0.0;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return 0.0;
        }
        Map<String, Double> companyStats = PartyManager.getCompanyStats(party);
        if (!companyStats.containsKey(stat)) {
            return 0.0;
        }
        int companyRadius = PartyManager.getTotalIntStat("company_radius", party);
        int maxAccompanied = PartyManager.getTotalIntStat("company_member_cap", party);
        if (companyRadius == 0 || maxAccompanied == 0) {
            return 0.0;
        }
        Collection<Player> members = PartyManager.membersInRadius(p, companyRadius);
        int nearby = members.size();
        return companyStats.get(stat) * (double)(maxAccompanied >= 0 ? Math.min(maxAccompanied, nearby) : nearby);
    }

    public static Party getParty(Player p) {
        return partiesByMember.get(p.getUniqueId());
    }

    public static ErrorStatus validatePartyName(String name) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (name.length() > partyNameMaximum) {
            return ErrorStatus.EXCEEDED_CHARACTER_LIMIT;
        }
        if (name.length() < partyNameMinimum) {
            return ErrorStatus.NOT_ENOUGH_CHARACTERS;
        }
        if (legalCharactersPattern != null && !legalCharactersPattern.matcher(name).matches()) {
            return ErrorStatus.ILLEGAL_CHARACTERS_USED;
        }
        return null;
    }

    public static ErrorStatus validateDescription(String description) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (description.length() > partyDescriptionMaximum) {
            return ErrorStatus.EXCEEDED_CHARACTER_LIMIT;
        }
        if (legalCharactersPattern != null && !legalCharactersPattern.matcher(description).matches()) {
            return ErrorStatus.ILLEGAL_CHARACTERS_USED;
        }
        return null;
    }

    public static ErrorStatus registerParty(Player leader, Party party) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (!leader.hasPermission("valhalla.createparty")) {
            return ErrorStatus.NO_PERMISSION;
        }
        if (allParties.containsKey(party.getId())) {
            return ErrorStatus.PARTY_ALREADY_EXISTS;
        }
        if (!Timer.isCooldownPassed(leader.getUniqueId(), "cooldown_party_creation")) {
            return ErrorStatus.ON_COOLDOWN;
        }
        Party playersParty = PartyManager.getParty(leader);
        if (playersParty != null) {
            return ErrorStatus.ALREADY_IN_PARTY;
        }
        allParties.put(party.getId(), party);
        partiesByMember.put(leader.getUniqueId(), party);
        Timer.setCooldownIgnoreIfPermission((Entity)leader, partyCreationCooldown, "cooldown_party_creation");
        return null;
    }

    public static ErrorStatus displayPartyInfo(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        return PartyManager.displayPartyInfo(p, party);
    }

    public static ErrorStatus displayPartyInfo(Player p, Party party) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        PartyRank rank = partyRanks.get(party.getMembers().getOrDefault(p.getUniqueId(), ""));
        String title = party.getLeader().equals(p.getUniqueId()) ? leaderTitle : (rank != null ? rank.title : "");
        boolean expSharingEnabled = party.isExpSharingEnabled() != null ? party.isExpSharingEnabled() : PartyManager.getBoolStat("exp_sharing", party);
        boolean itemSharingEnabled = party.isItemSharingEnabled() != null ? party.isItemSharingEnabled() : PartyManager.getBoolStat("item_sharing", party);
        Pair<PartyLevel, Double> level = PartyManager.getPartyLevel(party);
        PartyLevel nextLevel = level == null ? null : partyLevels.get(level.getOne().level + 1);
        String expForNext = nextLevel == null ? TranslationManager.getTranslation("max_level") : String.format("%,.1f", levelRequirements.getOrDefault(nextLevel.level, 0.0) - levelRequirements.getOrDefault(level.getOne().level, 0.0));
        partyInfoFormat.forEach(s -> p.sendMessage(Utils.chat(PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(s.replace("%rank%", title).replace("%level%", level != null ? ((PartyLevel)level.getOne()).name : "").replace("%level_numeric%", level != null ? String.valueOf(((PartyLevel)level.getOne()).level) : "").replace("%level_roman%", level != null ? StringUtils.toRoman(((PartyLevel)level.getOne()).level) : "").replace("%exp%", String.format("%,.1f", level != null ? (Double)level.getTwo() : (double)p.getExp())).replace("%exp_next%", expForNext).replace("%name%", party.getDisplayName()).replace("%description%", party.getDescription()).replace("%member_count%", String.valueOf(party.getMembers().size() + 1)).replace("%member_cap%", String.valueOf(PartyManager.getTotalIntStat("party_capacity", party))), p), p).replace("%status_exp_sharing%", TranslationManager.getTranslation("translation_" + expSharingEnabled)).replace("%status_item_sharing%", TranslationManager.getTranslation("translation_" + itemSharingEnabled)).replace("%status_open%", TranslationManager.getTranslation("translation_" + party.isOpen())).replace("%member_list%", String.join((CharSequence)", ", PartyManager.getPartyMembers(party).keySet())))));
        return null;
    }

    public static ErrorStatus hasPermission(Player p, String permission) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (p.hasPermission("valhalla.manageparties")) {
            return null;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        if (party.getLeader().equals(p.getUniqueId())) {
            return null;
        }
        PartyRank rank = partyRanks.get(party.getMembers().getOrDefault(p.getUniqueId(), ""));
        if (rank == null) {
            return ErrorStatus.SENDER_NO_RANK;
        }
        if (!rank.permissions.contains(permission)) {
            return ErrorStatus.NO_PERMISSION;
        }
        return null;
    }

    public static ErrorStatus changeDescription(Player p, String description) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        if (!Timer.isCooldownPassed(p.getUniqueId(), "cooldown_party_description_change")) {
            return ErrorStatus.ON_COOLDOWN;
        }
        ErrorStatus permissionStatus = PartyManager.hasPermission(p, "manage_description");
        if (permissionStatus != null) {
            return permissionStatus;
        }
        ErrorStatus descriptionStatus = PartyManager.validateDescription(description);
        if (descriptionStatus != null) {
            return descriptionStatus;
        }
        if (PartyManager.getBoolStat("description_colors", party)) {
            party.setDescription(Utils.chat(description));
        } else {
            party.setDescription(description);
        }
        Timer.setCooldownIgnoreIfPermission((Entity)p, partyDescriptionChangeCooldown, "cooldown_party_description_change");
        return null;
    }

    public static ErrorStatus changeName(Player p, String name) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        if (!Timer.isCooldownPassed(p.getUniqueId(), "cooldown_party_rename")) {
            return ErrorStatus.ON_COOLDOWN;
        }
        ErrorStatus permissionStatus = PartyManager.hasPermission(p, "manage_name");
        if (permissionStatus != null) {
            return permissionStatus;
        }
        ErrorStatus nameChangeStatus = PartyManager.validatePartyName(name);
        if (nameChangeStatus != null) {
            return nameChangeStatus;
        }
        String newId = PartyManager.convertNameToID(name);
        if (allParties.containsKey(newId)) {
            return ErrorStatus.PARTY_ALREADY_EXISTS;
        }
        allParties.remove(party.getId());
        party.setId(newId);
        allParties.put(newId, party);
        if (PartyManager.getBoolStat("party_colors", party)) {
            party.setDisplayName(Utils.chat(name));
        } else {
            party.setDescription(name);
        }
        Timer.setCooldownIgnoreIfPermission((Entity)p, partyRenameCooldown, "cooldown_party_rename");
        return null;
    }

    public static ErrorStatus togglePartyChat(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        ErrorStatus chatStatus = PartyManager.hasPermission(p, "party_chat");
        if (chatStatus != null) {
            return chatStatus;
        }
        if (!partyChatPlayers.remove(p.getUniqueId())) {
            partyChatPlayers.add(p.getUniqueId());
        }
        return null;
    }

    public static ErrorStatus shareItem(Player from, Player to) {
        boolean itemSharingEnabled;
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (!enabledItemSharing) {
            return ErrorStatus.FEATURE_NOT_UNLOCKED;
        }
        if (from.getUniqueId().equals(to.getUniqueId())) {
            return ErrorStatus.TARGET_SENDER_SAME;
        }
        Party fromParty = PartyManager.getParty(from);
        if (fromParty == null) {
            return ErrorStatus.SENDER_NO_PARTY;
        }
        if (WorldGuardHook.inDisabledRegion(from.getLocation(), from, "vmmo-party-itemsharing")) {
            return ErrorStatus.FORBIDDEN_REGION;
        }
        Party toParty = PartyManager.getParty(to);
        if (toParty == null) {
            return ErrorStatus.TARGET_NO_PARTY;
        }
        if (WorldGuardHook.inDisabledRegion(to.getLocation(), to, "vmmo-party-itemsharing")) {
            return ErrorStatus.FORBIDDEN_REGION;
        }
        if (!fromParty.getId().equals(toParty.getId())) {
            return ErrorStatus.NOT_IN_SAME_PARTY;
        }
        boolean bl = itemSharingEnabled = fromParty.isItemSharingEnabled() != null ? fromParty.isItemSharingEnabled() : PartyManager.getBoolStat("item_sharing", fromParty);
        if (!itemSharingEnabled) {
            return ErrorStatus.FEATURE_NOT_UNLOCKED;
        }
        int reach = PartyManager.getTotalIntStat("item_sharing_radius", fromParty);
        if (reach >= 0 && (!from.getWorld().getName().equals(to.getWorld().getName()) || from.getLocation().distanceSquared(to.getLocation()) > (double)(reach * reach))) {
            return ErrorStatus.OUT_OF_RANGE;
        }
        if (!Timer.isCooldownPassed(from.getUniqueId(), "cooldown_share_item")) {
            return ErrorStatus.ON_COOLDOWN;
        }
        ItemStack hand = from.getInventory().getItemInMainHand();
        if (ItemUtils.isEmpty(hand)) {
            return ErrorStatus.NO_ITEM;
        }
        ItemBuilder handMeta = new ItemBuilder(hand);
        to.sendMessage(Utils.chat(TranslationManager.getTranslation("status_command_party_item_received").replace("%player%", from.getName()).replace("%amount%", String.valueOf(hand.getAmount())).replace("%item%", ItemUtils.getItemName(handMeta))));
        ItemUtils.addItem(to, hand.clone(), true);
        from.getInventory().setItemInMainHand(null);
        Timer.setCooldownIgnoreIfPermission((Entity)from, itemSharingCooldown, "cooldown_share_item");
        return null;
    }

    public static ErrorStatus togglePartyOpen(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        ErrorStatus openStatus = PartyManager.hasPermission(p, "open_party");
        if (openStatus != null) {
            return openStatus;
        }
        party.setOpen(!party.isOpen());
        return null;
    }

    public static ErrorStatus toggleItemSharing(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        ErrorStatus toggleStatus = PartyManager.hasPermission(p, "toggle_item_sharing");
        if (toggleStatus != null) {
            return toggleStatus;
        }
        if (!PartyManager.getBoolStat("item_sharing", party)) {
            return ErrorStatus.FEATURE_NOT_UNLOCKED;
        }
        party.setItemSharingEnabled(party.isItemSharingEnabled() == null || party.isItemSharingEnabled() == false);
        return null;
    }

    public static ErrorStatus toggleFriendlyFire(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        ErrorStatus toggleStatus = PartyManager.hasPermission(p, "toggle_friendly_fire");
        if (toggleStatus != null) {
            return toggleStatus;
        }
        party.setFriendlyFireEnabled(!party.isFriendlyFireEnabled());
        return null;
    }

    public static ErrorStatus toggleExpSharing(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        ErrorStatus toggleStatus = PartyManager.hasPermission(p, "toggle_exp_sharing");
        if (toggleStatus != null) {
            return toggleStatus;
        }
        if (!PartyManager.getBoolStat("exp_sharing", party)) {
            return ErrorStatus.FEATURE_NOT_UNLOCKED;
        }
        party.setExpSharingEnabled(party.isExpSharingEnabled() == null || party.isExpSharingEnabled() == false);
        return null;
    }

    public static ErrorStatus leaveParty(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        if (party.getLeader().equals(p.getUniqueId())) {
            return ErrorStatus.CANNOT_KICK_LEADER;
        }
        party.getMembers().remove(p.getUniqueId());
        partiesByMember.remove(p.getUniqueId());
        partyChatPlayers.remove(p.getUniqueId());
        return null;
    }

    public static ErrorStatus acceptInvite(Player p, String party) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party existingParty = PartyManager.getParty(p);
        if (existingParty != null) {
            return ErrorStatus.ALREADY_IN_PARTY;
        }
        Party toJoin = allParties.get(party);
        if (toJoin == null) {
            return ErrorStatus.PARTY_DOES_NOT_EXIST;
        }
        if (!toJoin.isOpen() && !((Collection)partyInvites.getOrDefault(p.getUniqueId(), new HashSet())).contains(party)) {
            return ErrorStatus.NOT_INVITED;
        }
        ErrorStatus joinStatus = PartyManager.joinParty(p, toJoin);
        if (joinStatus != null) {
            return joinStatus;
        }
        Collection<Player> members = PartyManager.getOnlinePartyMembers(toJoin);
        for (Player member : members) {
            Utils.sendMessage((CommandSender)member, PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(TranslationManager.getTranslation("status_command_party_member_joined").replace("%player%", p.getName()).replace("%party%", toJoin.getDisplayName()), member), member));
        }
        return null;
    }

    public static ErrorStatus joinParty(Player p, Party party) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        if (party == null || !allParties.containsKey(party.getId())) {
            return ErrorStatus.PARTY_DOES_NOT_EXIST;
        }
        Party existingParty = PartyManager.getParty(p);
        if (existingParty != null || party.getMembers().containsKey(p.getUniqueId()) || party.getLeader().equals(p.getUniqueId())) {
            return ErrorStatus.ALREADY_IN_PARTY;
        }
        if (party.getMembers().size() + 1 >= PartyManager.getTotalIntStat("party_capacity", party)) {
            return ErrorStatus.MEMBER_CAP_REACHED;
        }
        party.getMembers().put(p.getUniqueId(), lowestRank);
        partiesByMember.put(p.getUniqueId(), party);
        return null;
    }

    public static ErrorStatus kickMember(Player kicker, UUID kicked) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(kicker);
        if (party == null) {
            return ErrorStatus.SENDER_NO_PARTY;
        }
        Party kickedParty = partiesByMember.get(kicked);
        if (kickedParty == null) {
            return ErrorStatus.TARGET_NO_PARTY;
        }
        if (!party.getId().equals(kickedParty.getId())) {
            return ErrorStatus.NOT_IN_SAME_PARTY;
        }
        if (party.getLeader().equals(kicked)) {
            return ErrorStatus.CANNOT_KICK_LEADER;
        }
        ErrorStatus kickStatus = PartyManager.hasPermission(kicker, "kick_members");
        if (kickStatus != null) {
            return kickStatus;
        }
        PartyRank kickerRank = partyRanks.get(party.getMembers().getOrDefault(kicker.getUniqueId(), ""));
        PartyRank kickedRank = partyRanks.get(party.getMembers().getOrDefault(kicked, ""));
        if (party.getLeader().equals(kicker.getUniqueId()) || kickedRank == null || kickedRank.rating < kickerRank.rating) {
            party.getMembers().remove(kicked);
            partiesByMember.remove(kicked);
            Player k = ValhallaMMO.getInstance().getServer().getPlayer(kicked);
            if (k != null) {
                Utils.sendMessage((CommandSender)k, TranslationManager.getTranslation("status_command_party_member_kicked"));
            }
            return null;
        }
        return ErrorStatus.TARGET_HIGHER_RANK;
    }

    public static ErrorStatus forceKickMember(CommandSender kicker, UUID kicked) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party kickedParty = partiesByMember.get(kicked);
        if (kickedParty == null) {
            return ErrorStatus.TARGET_NO_PARTY;
        }
        if (kickedParty.getLeader().equals(kicked)) {
            return ErrorStatus.CANNOT_KICK_LEADER;
        }
        if (!kicker.hasPermission("valhalla.manageparties")) {
            return ErrorStatus.NO_PERMISSION;
        }
        kickedParty.getMembers().remove(kicked);
        partiesByMember.remove(kicked);
        Player k = ValhallaMMO.getInstance().getServer().getPlayer(kicked);
        if (k != null) {
            Utils.sendMessage((CommandSender)k, TranslationManager.getTranslation("status_command_party_member_kicked"));
        }
        return null;
    }

    public static ErrorStatus disbandParty(Player p) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(p);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        if (!party.getLeader().equals(p.getUniqueId())) {
            return ErrorStatus.NO_PERMISSION;
        }
        return PartyManager.disbandParty(party);
    }

    public static ErrorStatus disbandParty(Party party) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        for (UUID uuid : party.getMembers().keySet()) {
            partiesByMember.remove(uuid);
            Player online = ValhallaMMO.getInstance().getServer().getPlayer(uuid);
            if (online == null) continue;
            Utils.sendMessage((CommandSender)online, TranslationManager.getTranslation("status_command_party_disbanded"));
        }
        partiesByMember.remove(party.getLeader());
        Player online = ValhallaMMO.getInstance().getServer().getPlayer(party.getLeader());
        if (online != null) {
            Utils.sendMessage((CommandSender)online, TranslationManager.getTranslation("status_command_party_disbanded"));
        }
        allParties.remove(party.getId());
        return null;
    }

    public static ErrorStatus invite(Player inviter, Player who) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party inviterParty = PartyManager.getParty(inviter);
        if (inviterParty == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        Party invitedParty = PartyManager.getParty(who);
        if (invitedParty != null) {
            return ErrorStatus.ALREADY_IN_PARTY;
        }
        if (inviterParty.getMembers().size() + 1 >= PartyManager.getTotalIntStat("party_capacity", inviterParty)) {
            return ErrorStatus.MEMBER_CAP_REACHED;
        }
        ErrorStatus inviteStatus = PartyManager.hasPermission(inviter, "invite_members");
        if (inviteStatus != null) {
            return inviteStatus;
        }
        Collection existingInvites = partyInvites.getOrDefault(who.getUniqueId(), new HashSet());
        if (existingInvites.contains(inviterParty.getId())) {
            return ErrorStatus.TARGET_NOT_INVITEABLE;
        }
        existingInvites.add(inviterParty.getId());
        partyInvites.put(who.getUniqueId(), existingInvites);
        if (!PartyManager.hasInvitesMuted(who)) {
            Utils.sendMessage((CommandSender)who, TranslationManager.getTranslation("status_command_party_invite_received").replace("%party%", inviterParty.getDisplayName()).replace("%player%", inviter.getName()).replace("%party_id%", inviterParty.getId()));
        }
        return null;
    }

    public static ErrorStatus setMemberRank(Player who, Player target, String newRank) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(who);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        Party targetParty = PartyManager.getParty(target);
        if (targetParty == null) {
            return ErrorStatus.TARGET_NO_PARTY;
        }
        PartyRank rankToGrant = partyRanks.get(newRank);
        if (rankToGrant == null) {
            return ErrorStatus.RANK_NOT_FOUND;
        }
        if (!party.getId().equals(targetParty.getId())) {
            return ErrorStatus.NOT_IN_SAME_PARTY;
        }
        ErrorStatus rankupStatus = PartyManager.hasPermission(who, "manage_roles");
        if (rankupStatus != null) {
            return rankupStatus;
        }
        boolean allowed = party.getLeader().equals(who.getUniqueId());
        if (!allowed) {
            PartyRank rank = partyRanks.get(party.getMembers().getOrDefault(who.getUniqueId(), ""));
            if (rank == null) {
                return ErrorStatus.SENDER_NO_RANK;
            }
            if (rankToGrant.rating > rank.rating) {
                return ErrorStatus.RANK_HIGHER_SENDER;
            }
            PartyRank targetRank = partyRanks.get(party.getMembers().getOrDefault(who.getUniqueId(), ""));
            boolean bl = allowed = !party.getLeader().equals(target.getUniqueId()) && (targetRank == null || targetRank.rating < rank.rating);
        }
        if (!allowed) {
            return ErrorStatus.TARGET_HIGHER_RANK;
        }
        party.getMembers().put(target.getUniqueId(), rankToGrant.id);
        return null;
    }

    public static ErrorStatus changeLeader(Player leader, Player to) {
        if (!enabledParties) {
            return ErrorStatus.PARTIES_DISABLED;
        }
        Party party = PartyManager.getParty(leader);
        if (party == null) {
            return ErrorStatus.NOT_IN_PARTY;
        }
        Party targetParty = PartyManager.getParty(to);
        if (targetParty == null) {
            return ErrorStatus.TARGET_NO_PARTY;
        }
        if (!party.getId().equals(targetParty.getId())) {
            return ErrorStatus.NOT_IN_SAME_PARTY;
        }
        if (!party.getLeader().equals(leader.getUniqueId())) {
            return ErrorStatus.SENDER_NOT_LEADER;
        }
        if (leader.getUniqueId().equals(to.getUniqueId())) {
            return ErrorStatus.TARGET_SENDER_SAME;
        }
        party.setLeader(to.getUniqueId());
        party.getMembers().put(leader.getUniqueId(), highestRank);
        return null;
    }

    public static boolean toggleInviteMute(Player p) {
        if (p.hasMetadata("valhallammo_party_invite_mute")) {
            p.removeMetadata("valhallammo_party_invite_mute", (Plugin)ValhallaMMO.getInstance());
            return false;
        }
        p.setMetadata("valhallammo_party_invite_mute", (MetadataValue)new FixedMetadataValue((Plugin)ValhallaMMO.getInstance(), (Object)1));
        return true;
    }

    public static boolean hasInvitesMuted(Player p) {
        return p.hasMetadata("valhallammo_party_invite_mute");
    }

    public static Party createParty(Player leader, String name) {
        if (!enabledParties) {
            return null;
        }
        return new Party(PartyManager.convertNameToID(name), name, leader.getUniqueId());
    }

    private static String convertNameToID(String name) {
        return name.toLowerCase(Locale.US).replaceAll(" ", "_").replaceAll("&[0-9a-fA-FkmolnrKMOLNR]", "");
    }

    public static Pair<PartyLevel, Double> getPartyLevel(Party p) {
        if (!enabledParties) {
            return null;
        }
        if (partyLevelCache.containsKey(p.getId()) && partyLevelCache.get(p.getId()).getOne() + 3000L > System.currentTimeMillis()) {
            return new Pair<PartyLevel, Double>(partyLevelCache.get(p.getId()).getTwo(), p.getExp() - levelRequirements.get(PartyManager.partyLevelCache.get((Object)p.getId()).getTwo().level));
        }
        int lv = 0;
        for (int level : levelRequirements.keySet()) {
            if (p.getExp() < levelRequirements.get(level)) break;
            lv = level;
        }
        partyLevelCache.put(p.getId(), new Pair<Long, PartyLevel>(System.currentTimeMillis(), partyLevels.get(lv)));
        return new Pair<PartyLevel, Double>(partyLevels.get(lv), p.getExp() - levelRequirements.get(lv));
    }

    public static void addEXP(Party party, double exp) {
        Pair<PartyLevel, Double> level = PartyManager.getPartyLevel(party);
        party.setExp(party.getExp() + exp);
        if (level != null && level.getOne().nextLevelEXP >= 0.0 && party.getExp() >= level.getOne().nextLevelEXP) {
            partyLevelCache.remove(party.getId());
            level = PartyManager.getPartyLevel(party);
            if (level == null) {
                return;
            }
            for (Player p : PartyManager.getOnlinePartyMembers(party)) {
                if (PartyManager.getPartyLevelUpFormat() != null) {
                    Utils.sendMessage((CommandSender)p, PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(PartyManager.getPartyLevelUpFormat().replace("%party%", party.getDisplayName()).replace("%level%", level.getOne().getName()).replace("%level_numeric%", String.valueOf(level.getOne().getLevel())).replace("%level_roman%", StringUtils.toRoman(level.getOne().getLevel())), p), p));
                }
                if (level.getOne().getLevelUpDescription() == null) continue;
                level.getOne().getLevelUpDescription().forEach(d -> Utils.sendMessage((CommandSender)p, Utils.chat(PlaceholderRegistry.parsePapi(PlaceholderRegistry.parse(d, p), p))));
            }
        }
    }

    public static boolean togglePartySpy(Player p) {
        if (!partySpyPlayers.remove(p.getUniqueId())) {
            partySpyPlayers.add(p.getUniqueId());
            return true;
        }
        return false;
    }

    public static float getTotalFloatStat(String stat, Party p) {
        if (!defaultFloats.containsKey(stat) || !enabledParties) {
            return 0.0f;
        }
        float def = defaultFloats.getOrDefault(stat, Float.valueOf(0.0f)).floatValue() + p.getFloats().getOrDefault(stat, Float.valueOf(0.0f)).floatValue();
        Pair<PartyLevel, Double> partyLevel = PartyManager.getPartyLevel(p);
        if (partyLevel == null) {
            return def;
        }
        for (int i = 0; i <= partyLevel.getOne().level; ++i) {
            if (!partyLevels.containsKey(i)) continue;
            def += PartyManager.partyLevels.get((Object)Integer.valueOf((int)i)).floatStatBuffs.getOrDefault(stat, Float.valueOf(0.0f)).floatValue();
        }
        return def;
    }

    public static int getTotalIntStat(String stat, Party p) {
        if (!defaultInts.containsKey(stat) || !enabledParties) {
            return 0;
        }
        int def = defaultInts.getOrDefault(stat, 0) + p.getInts().getOrDefault(stat, 0);
        Pair<PartyLevel, Double> partyLevel = PartyManager.getPartyLevel(p);
        if (partyLevel == null) {
            return def;
        }
        for (int i = 0; i <= partyLevel.getOne().level; ++i) {
            if (!partyLevels.containsKey(i)) continue;
            def += PartyManager.partyLevels.get((Object)Integer.valueOf((int)i)).intStatBuffs.getOrDefault(stat, 0).intValue();
        }
        return def;
    }

    public static boolean getBoolStat(String stat, Party p) {
        if (!defaultBools.containsKey(stat) || !enabledParties) {
            return false;
        }
        if (p.getBools().containsKey(stat)) {
            return p.getBools().get(stat);
        }
        boolean def = defaultBools.getOrDefault(stat, false);
        Pair<PartyLevel, Double> partyLevel = PartyManager.getPartyLevel(p);
        if (partyLevel == null || def) {
            return def;
        }
        for (int i = 0; i <= partyLevel.getOne().level; ++i) {
            if (!partyLevels.containsKey(i) || !PartyManager.partyLevels.get((Object)Integer.valueOf((int)i)).boolStats.getOrDefault(stat, false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Double> getCompanyStats(Party p) {
        if (!enabledParties) {
            return new HashMap<String, Double>();
        }
        HashMap<String, Double> companyStats = new HashMap<String, Double>(defaultCompanyStats);
        Pair<PartyLevel, Double> partyLevel = PartyManager.getPartyLevel(p);
        if (partyLevel == null) {
            return companyStats;
        }
        for (int i = 0; i <= partyLevel.getOne().level; ++i) {
            PartyLevel level = partyLevels.get(i);
            if (level == null) continue;
            for (String stat : level.companyStats.keySet()) {
                if (companyStats.containsKey(stat)) {
                    companyStats.put(stat, companyStats.getOrDefault(stat, 0.0) + level.companyStats.get(stat));
                    continue;
                }
                companyStats.put(stat, level.companyStats.get(stat));
            }
        }
        return companyStats;
    }

    public static Collection<Player> getOnlinePartyMembers(Party party) {
        HashSet<UUID> members = new HashSet<UUID>(party.getMembers().keySet());
        members.add(party.getLeader());
        return new HashSet<Player>(Utils.getOnlinePlayersFromUUIDs(members).values());
    }

    public static Map<String, OfflinePlayer> getPartyMembers(Party party) {
        HashSet<UUID> members = new HashSet<UUID>(party.getMembers().keySet());
        members.add(party.getLeader());
        return Utils.getPlayersFromUUIDs(members);
    }

    public static void registerIntStat(String key) {
        defaultInts.put(key, 0);
    }

    public static void registerFloatStat(String key) {
        defaultFloats.put(key, Float.valueOf(0.0f));
    }

    public static void registerBooleanStat(String key) {
        defaultBools.put(key, false);
    }

    public static void loadParties() {
        ConfigurationSection configurationSection;
        YamlConfiguration config = ConfigManager.getConfig("parties.yml").reload().get();
        enabledParties = config.getBoolean("enabled");
        if (!enabledParties) {
            return;
        }
        enabledEXPSharing = config.getBoolean("exp_sharing");
        enabledItemSharing = config.getBoolean("item_sharing");
        partyCreationCooldown = config.getInt("party_creation_cooldown");
        itemSharingCooldown = config.getInt("item_share_cooldown");
        partyEXPConversionRate = config.getDouble("party_exp_rate");
        partyRenameCooldown = config.getInt("party_rename_cooldown");
        partyDescriptionChangeCooldown = config.getInt("party_description_change_cooldown");
        String pattern = config.getString("legal_characters_regex");
        if (StringUtils.isEmpty(pattern)) {
            legalCharactersPattern = Pattern.compile(pattern);
        }
        partyNameMinimum = config.getInt("name_character_minimum");
        partyNameMaximum = config.getInt("name_character_maximum");
        partyDescriptionMaximum = config.getInt("description_character_maximum");
        partyChatFormat = config.getString("party_chat_format");
        partySpyFormat = config.getString("party_spy_format");
        partyInfoFormat = TranslationManager.translateListPlaceholders(config.getStringList("party_info_format"));
        partyLevelUpFormat = config.getString("party_levelup_format");
        for (String string : defaultInts.keySet()) {
            defaultInts.put(string, config.getInt("defaults." + string, 0));
        }
        for (String string : defaultFloats.keySet()) {
            defaultFloats.put(string, Float.valueOf((float)config.getDouble("defaults." + string, 0.0)));
        }
        for (String string : defaultBools.keySet()) {
            defaultBools.put(string, config.getBoolean("defaults." + string, false));
        }
        ConfigurationSection defaultStatSection = config.getConfigurationSection("default_company_stats");
        if (defaultStatSection != null) {
            for (String stat : defaultStatSection.getKeys(false)) {
                if (!AccumulativeStatManager.getSources().containsKey(stat)) continue;
                defaultCompanyStats.put(stat, config.getDouble("default_company_stats." + stat));
            }
        }
        if ((configurationSection = config.getConfigurationSection("levels")) != null) {
            double expTotal = 0.0;
            PartyLevel previousLevel = null;
            for (String level : configurationSection.getKeys(false)) {
                int lv = Catch.catchOrElse(() -> Integer.parseInt(level), -1);
                if (lv < 0) continue;
                String name = TranslationManager.translatePlaceholders(config.getString("levels." + level + ".name"));
                double requiredEXP = lv == 0 ? 0.0 : config.getDouble("levels." + level + ".exp_required");
                levelRequirements.put(lv, expTotal += requiredEXP);
                List<String> levelUpDescription = lv == 0 ? null : TranslationManager.translateListPlaceholders(config.getStringList("levels." + level + ".levelup_description"));
                PartyLevel partyLevel = new PartyLevel(lv, name, requiredEXP, levelUpDescription);
                if (previousLevel != null) {
                    previousLevel.setNextLevelEXP(expTotal);
                }
                previousLevel = partyLevel;
                if (lv != 0) {
                    for (String intStat : defaultInts.keySet()) {
                        int stat = config.getInt("levels." + level + "." + intStat, 0);
                        if (stat == 0) continue;
                        partyLevel.intStatBuffs.put(intStat, stat);
                    }
                    for (String floatStat : defaultFloats.keySet()) {
                        float stat = (float)config.getDouble("levels." + level + "." + floatStat, 0.0);
                        if (stat == 0.0f) continue;
                        partyLevel.floatStatBuffs.put(floatStat, Float.valueOf(stat));
                    }
                    for (String boolStat : defaultBools.keySet()) {
                        partyLevel.boolStats.put(boolStat, config.getBoolean("levels." + level + "." + boolStat, false));
                    }
                    ConfigurationSection levelStatSection = config.getConfigurationSection("levels." + level + ".stats");
                    if (levelStatSection != null) {
                        for (String stat : levelStatSection.getKeys(false)) {
                            if (!AccumulativeStatManager.getSources().containsKey(stat)) continue;
                            partyLevel.companyStats.put(stat, config.getDouble("levels." + level + ".stats." + stat));
                        }
                    }
                }
                partyLevels.put(partyLevel.level, partyLevel);
            }
        }
        leaderTitle = TranslationManager.translatePlaceholders(config.getString("leader_title"));
        PartyRank lowest = null;
        PartyRank highest = null;
        ConfigurationSection rankSection = config.getConfigurationSection("ranks");
        if (rankSection != null) {
            for (String rank : rankSection.getKeys(false)) {
                int rating = config.getInt("ranks." + rank + ".rating");
                String title = TranslationManager.translatePlaceholders(config.getString("ranks." + rank + ".title"));
                List permissions = config.getStringList("ranks." + rank + ".permissions");
                PartyRank partyRank = new PartyRank(rank, rating, title, permissions);
                if (lowest == null || lowest.rating > rating) {
                    lowest = partyRank;
                }
                if (highest == null || highest.rating < rating) {
                    highest = partyRank;
                }
                partyRanks.put(rank, partyRank);
            }
        }
        if (lowest == null) {
            enabledParties = false;
            return;
        }
        lowestRank = lowest.id;
        if (highest == null) {
            enabledParties = false;
            return;
        }
        highestRank = highest.id;
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new PartyChatListener(), (Plugin)ValhallaMMO.getInstance());
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new PartyEXPGainListener(), (Plugin)ValhallaMMO.getInstance());
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)new PartyPvPListener(), (Plugin)ValhallaMMO.getInstance());
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/parties.json");
        try {
            f.createNewFile();
        }
        catch (IOException rank) {
            // empty catch block
        }
        try (BufferedReader setsReader = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
            Party[] sets = (Party[])gson.fromJson((Reader)setsReader, Party[].class);
            if (sets == null) {
                return;
            }
            for (Party party : sets) {
                allParties.put(party.getId(), party);
                party.getMembers().forEach((m, p) -> partiesByMember.put((UUID)m, party));
                partiesByMember.put(party.getLeader(), party);
            }
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaMMO.logSevere("Could not load parties from parties.json, " + exception.getMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void saveParties() {
        if (!enabledParties) {
            return;
        }
        File f = new File(ValhallaMMO.getInstance().getDataFolder(), "/parties.json");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8));){
            JsonElement element = gson.toJsonTree(new ArrayList<Party>(allParties.values()), new TypeToken<ArrayList<Party>>(){}.getType());
            gson.toJson(element, (Appendable)writer);
            writer.flush();
        }
        catch (JsonSyntaxException | IOException exception) {
            ValhallaMMO.logSevere("Could not save parties to parties.json, " + exception.getMessage());
        }
    }

    public static String getPartyChatFormat() {
        return partyChatFormat;
    }

    public static String getPartySpyFormat() {
        return partySpyFormat;
    }

    public static String getLeaderTitle() {
        return leaderTitle;
    }

    public static Map<String, Party> getAllParties() {
        return new HashMap<String, Party>(allParties);
    }

    public static TreeMap<Integer, PartyLevel> getPartyLevels() {
        return new TreeMap<Integer, PartyLevel>((SortedMap<Integer, PartyLevel>)partyLevels);
    }

    public static Map<String, PartyRank> getPartyRanks() {
        return new HashMap<String, PartyRank>(partyRanks);
    }

    public static Collection<UUID> getPartyChatPlayers() {
        return partyChatPlayers;
    }

    public static Collection<UUID> getPartySpyPlayers() {
        return partySpyPlayers;
    }

    public static Map<UUID, Collection<String>> getPartyInvites() {
        return partyInvites;
    }

    public static double getPartyEXPConversionRate() {
        return partyEXPConversionRate;
    }

    public static String getPartyLevelUpFormat() {
        return partyLevelUpFormat;
    }

    public static String getLowestRank() {
        return lowestRank;
    }

    public static String getHighestRank() {
        return highestRank;
    }

    public static Map<String, Boolean> getDefaultBools() {
        return new HashMap<String, Boolean>(defaultBools);
    }

    public static Map<String, Float> getDefaultFloats() {
        return new HashMap<String, Float>(defaultFloats);
    }

    public static Map<String, Integer> getDefaultInts() {
        return new HashMap<String, Integer>(defaultInts);
    }

    public static Map<Integer, Double> getLevelRequirements() {
        return levelRequirements;
    }

    static {
        partyInvites = new HashMap<UUID, Collection<String>>();
        partyChatPlayers = new HashSet<UUID>();
        partySpyPlayers = new HashSet<UUID>();
        enabledParties = true;
        legalCharactersPattern = null;
        defaultInts = new HashMap<String, Integer>();
        defaultFloats = new HashMap<String, Float>();
        defaultBools = new HashMap<String, Boolean>();
        defaultCompanyStats = new HashMap<String, Double>();
        defaultInts.put("party_capacity", 0);
        defaultInts.put("exp_sharing_radius", 0);
        defaultInts.put("item_sharing_radius", 0);
        defaultInts.put("company_radius", 0);
        defaultInts.put("company_member_cap", 0);
        defaultFloats.put("exp_sharing_multiplier", Float.valueOf(0.0f));
        defaultBools.put("party_chat", false);
        defaultBools.put("exp_sharing", false);
        defaultBools.put("item_sharing", false);
        defaultBools.put("name_colors", false);
        defaultBools.put("description_colors", false);
        defaultBools.put("rename_party", false);
        partyLevelCache = new HashMap<String, Pair<Long, PartyLevel>>();
    }

    public static enum ErrorStatus {
        NO_PERMISSION("error_command_no_permission"),
        TARGET_NOT_INVITEABLE("status_command_party_member_not_inviteable"),
        FORBIDDEN_REGION("status_command_party_forbidden_region"),
        TARGET_NO_PARTY("status_command_party_target_no_party"),
        SENDER_NO_PARTY("status_command_party_sender_no_party"),
        TARGET_HIGHER_RANK("status_command_party_target_higher_rank"),
        RANK_HIGHER_SENDER("status_command_party_rank_higher_sender"),
        TARGET_SENDER_SAME("status_command_party_target_sender_same"),
        SENDER_NOT_LEADER("status_command_party_sender_not_leader"),
        SENDER_NO_RANK("status_command_party_sender_no_rank"),
        NOT_IN_SAME_PARTY("status_command_party_not_in_same_party"),
        ALREADY_IN_PARTY("status_command_party_already_in_party"),
        NOT_IN_PARTY("status_command_party_not_in_party"),
        PARTY_DOES_NOT_EXIST("status_command_party_party_not_found"),
        RANK_NOT_FOUND("status_command_party_rank_not_found"),
        PARTY_ALREADY_EXISTS("status_command_party_party_already_exists"),
        FEATURE_NOT_UNLOCKED("status_command_party_feature_not_unlocked"),
        CANNOT_KICK_LEADER("status_command_party_cannot_kick_leader"),
        ON_COOLDOWN("status_command_party_on_cooldown"),
        NO_ITEM("status_command_party_no_item_held"),
        EXCEEDED_CHARACTER_LIMIT("status_command_party_character_limit_reached"),
        NOT_ENOUGH_CHARACTERS("status_command_party_name_not_long_enough"),
        ILLEGAL_CHARACTERS_USED("status_command_party_invalid_characters_used"),
        NOT_INVITED("status_command_party_not_invited"),
        OUT_OF_RANGE("status_command_item_share_outranged"),
        PARTIES_DISABLED("status_command_parties_disabled"),
        MEMBER_CAP_REACHED("status_command_party_member_cap_reached");

        final String message;

        private ErrorStatus(String translationPath) {
            this.message = TranslationManager.getTranslation(translationPath);
        }

        public void sendErrorMessage(CommandSender p) {
            Utils.sendMessage(p, this.message);
        }

        public void sendErrorMessage(CommandSender p, Player target) {
            Utils.sendMessage(p, this.message.replace("%player%", target.getName()));
        }

        public String getMessage() {
            return this.message;
        }
    }

    public record PartyRank(String id, int rating, String title, Collection<String> permissions) {
        public PartyRank(String id, int rating, String title, Collection<String> permissions) {
            this.id = id;
            this.rating = rating;
            this.title = title;
            this.permissions = new HashSet<String>(permissions);
        }
    }

    public static class PartyLevel {
        private final int level;
        private final String name;
        private final double requiredEXP;
        private double nextLevelEXP = -1.0;
        private final List<String> levelUpDescription;
        private final Map<String, Integer> intStatBuffs = new HashMap<String, Integer>();
        private final Map<String, Float> floatStatBuffs = new HashMap<String, Float>();
        private final Map<String, Boolean> boolStats = new HashMap<String, Boolean>();
        private final Map<String, Double> companyStats = new HashMap<String, Double>();

        public PartyLevel(int level, String name, double requiredEXP, List<String> levelUpDescription) {
            this.level = level;
            this.name = name;
            this.requiredEXP = requiredEXP;
            this.levelUpDescription = levelUpDescription;
        }

        public int getLevel() {
            return this.level;
        }

        public double getNextLevelEXP() {
            return this.nextLevelEXP;
        }

        public String getName() {
            return this.name;
        }

        public double getRequiredEXP() {
            return this.requiredEXP;
        }

        public List<String> getLevelUpDescription() {
            return this.levelUpDescription;
        }

        public void setNextLevelEXP(double nextLevelEXP) {
            this.nextLevelEXP = nextLevelEXP;
        }
    }
}

