/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.persistence;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonAdapter<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final String propertyName;

    public GsonAdapter(String propertyName) {
        this.propertyName = propertyName;
    }

    public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get(this.propertyName);
        String className = prim.getAsString();
        Class<?> klass = this.getObjectClass(className);
        return (T)jsonDeserializationContext.deserialize(jsonObject.get("DATA"), klass);
    }

    public JsonElement serialize(T jsonElement, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(this.propertyName, jsonElement.getClass().getName());
        jsonObject.add("DATA", jsonSerializationContext.serialize(jsonElement));
        return jsonObject;
    }

    public Class<?> getObjectClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException(e.getMessage());
        }
    }
}

