/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.profiles;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.BooleanProperties;
import me.athlaeos.valhallammo.playerstats.profiles.properties.PropertyBuilder;
import me.athlaeos.valhallammo.playerstats.profiles.properties.StatProperties;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileBooleanSet;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileBooleanToggle;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileDoubleAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileDoubleSet;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileFloatAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileFloatSet;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileIntAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.ProfileIntSet;
import me.athlaeos.valhallammo.skills.skills.Skill;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class Profile {
    protected UUID owner;
    private final Map<String, StatProperties> numberStatProperties = new HashMap<String, StatProperties>();
    protected Collection<String> tablesToUpdate = new HashSet<String>();
    protected Collection<String> allStatNames = new HashSet<String>();
    protected Map<String, NumberHolder<Integer>> ints = new HashMap<String, NumberHolder<Integer>>();
    protected Map<String, NumberHolder<Float>> floats = new HashMap<String, NumberHolder<Float>>();
    protected Map<String, NumberHolder<Double>> doubles = new HashMap<String, NumberHolder<Double>>();
    protected Map<String, Collection<String>> stringSets = new HashMap<String, Collection<String>>();
    protected Map<String, BooleanHolder> booleans = new HashMap<String, BooleanHolder>();
    private final NamespacedKey key;

    public abstract String getTableName();

    public Profile(UUID owner) {
        this.intStat("level", new PropertyBuilder().format(StatFormat.INT).min(0.0).create());
        this.doubleStat("exp", new PropertyBuilder().format(StatFormat.FLOAT_P2).create());
        this.doubleStat("exp_total", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).create());
        this.intStat("newGamePlus");
        this.intStat("maxAllowedLevel", Short.MAX_VALUE, new PropertyBuilder().format(StatFormat.INT).min(0.0).perkReward().create());
        this.booleanStat("forcePersist", new BooleanProperties(true, true));
        this.key = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "PDC_persistence_" + this.getClass().getSimpleName().toLowerCase(Locale.US));
        if (owner == null) {
            return;
        }
        this.owner = owner;
    }

    public void onCacheRefresh() {
    }

    public int getLevel() {
        return this.getInt("level");
    }

    public void setLevel(int level) {
        this.setInt("level", level);
    }

    public double getEXP() {
        return this.getDouble("exp");
    }

    public void setEXP(double exp) {
        this.setDouble("exp", exp);
    }

    public double getTotalEXP() {
        return this.getDouble("exp_total");
    }

    public void setTotalEXP(double exp) {
        this.setDouble("exp_total", exp);
    }

    public int getNewGamePlus() {
        return this.getInt("newGamePlus");
    }

    public void setNewGamePlus(int newGamePlus) {
        this.setInt("newGamePlus", newGamePlus);
    }

    public int getMaxAllowedLevel() {
        return this.getInt("maxAllowedLevel");
    }

    public void setMaxAllowedLevel(int maxAllowedLevel) {
        this.setInt("maxAllowedLevel", maxAllowedLevel);
    }

    public boolean shouldForcePersist() {
        return this.getBoolean("forcePersist");
    }

    public void setShouldForcePersist(boolean forcePersist) {
        this.setBoolean("forcePersist", forcePersist);
    }

    public abstract Class<? extends Skill> getSkillType();

    public Collection<String> getInts() {
        return this.ints.keySet();
    }

    public Collection<String> getDoubles() {
        return this.doubles.keySet();
    }

    public Collection<String> getFloats() {
        return this.floats.keySet();
    }

    public Collection<String> getStringSets() {
        return this.stringSets.keySet();
    }

    public Collection<String> getBooleans() {
        return this.booleans.keySet();
    }

    public boolean isInt(String stat) {
        return this.ints.containsKey(stat);
    }

    public int getInt(String stat) {
        NumberHolder<Integer> holder = this.ints.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No int stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getValue();
    }

    public int getDefaultInt(String stat) {
        NumberHolder<Integer> holder = this.ints.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No int stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getDefault();
    }

    public void setInt(String stat, int value) {
        NumberHolder<Integer> holder = this.ints.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No int stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        StatProperties properties = this.numberStatProperties.get(stat);
        if (properties != null) {
            if (!Double.isNaN(properties.getMin())) {
                value = (int)Math.max(properties.getMin(), (double)value);
            }
            if (!Double.isNaN(properties.getMax())) {
                value = (int)Math.min(properties.getMax(), (double)value);
            }
        }
        holder.setValue(value);
    }

    public boolean isFloat(String stat) {
        return this.floats.containsKey(stat);
    }

    public float getFloat(String stat) {
        NumberHolder<Float> holder = this.floats.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No float stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getValue().floatValue();
    }

    public float getDefaultFloat(String stat) {
        NumberHolder<Float> holder = this.floats.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No float stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getDefault().floatValue();
    }

    public void setFloat(String stat, float value) {
        NumberHolder<Float> holder = this.floats.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No float stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        StatProperties properties = this.numberStatProperties.get(stat);
        if (properties != null) {
            if (!Double.isNaN(properties.getMin())) {
                value = (float)Math.max(properties.getMin(), (double)value);
            }
            if (!Double.isNaN(properties.getMax())) {
                value = (float)Math.min(properties.getMax(), (double)value);
            }
        }
        holder.setValue(Float.valueOf(value));
    }

    public boolean isDouble(String stat) {
        return this.doubles.containsKey(stat);
    }

    public double getDouble(String stat) {
        NumberHolder<Double> holder = this.doubles.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No double stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getValue();
    }

    public double getDefaultDouble(String stat) {
        NumberHolder<Double> holder = this.doubles.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No double stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getDefault();
    }

    public void setDouble(String stat, double value) {
        NumberHolder<Double> holder = this.doubles.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No double stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        StatProperties properties = this.numberStatProperties.get(stat);
        if (properties != null) {
            if (!Double.isNaN(properties.getMin())) {
                value = Math.max(properties.getMin(), value);
            }
            if (!Double.isNaN(properties.getMax())) {
                value = Math.min(properties.getMax(), value);
            }
        }
        holder.setValue(value);
    }

    public boolean isStringSet(String stat) {
        return this.stringSets.containsKey(stat);
    }

    public Collection<String> getStringSet(String stat) {
        Collection<String> strings = this.stringSets.get(stat);
        if (strings == null) {
            throw new IllegalArgumentException("No stringSet stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return strings;
    }

    public void setStringSet(String stat, Collection<String> value) {
        if (!this.stringSets.containsKey(stat)) {
            throw new IllegalArgumentException("No stringSet stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        this.stringSets.put(stat, value);
    }

    public boolean isBoolean(String stat) {
        return this.booleans.containsKey(stat);
    }

    public boolean getBoolean(String stat) {
        BooleanHolder holder = this.booleans.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No boolean stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getValue();
    }

    public boolean getDefaultBoolean(String stat) {
        BooleanHolder holder = this.booleans.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No boolean stat with name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        return holder.getDefault();
    }

    public boolean shouldBooleanStatHavePerkReward(String stat) {
        BooleanHolder holder = this.booleans.get(stat);
        if (holder == null || holder.getProperties() == null) {
            return false;
        }
        return holder.getProperties().generatePerkReward();
    }

    public void setBoolean(String stat, boolean value) {
        BooleanHolder holder = this.booleans.get(stat);
        if (holder == null) {
            throw new IllegalArgumentException("No boolean stat with this name " + stat + " is registered under " + this.getClass().getSimpleName());
        }
        holder.setValue(value);
    }

    public Collection<String> intStatNames() {
        return this.ints.keySet();
    }

    public Collection<String> floatStatNames() {
        return this.floats.keySet();
    }

    public Collection<String> doubleStatNames() {
        return this.doubles.keySet();
    }

    public Collection<String> stringSetStatNames() {
        return this.stringSets.keySet();
    }

    public Collection<String> booleanStatNames() {
        return this.booleans.keySet();
    }

    public Collection<String> getAllStatNames() {
        return this.allStatNames;
    }

    protected void intStat(String name) {
        this.intStat(name, 0, new PropertyBuilder().format(StatFormat.INT).perkReward().create());
    }

    protected void intStat(String name, StatProperties properties) {
        this.intStat(name, 0, properties);
    }

    protected void intStat(String name, int def, StatProperties properties) {
        if (this.allStatNames.contains(name)) {
            return;
        }
        this.allStatNames.add(name);
        this.ints.put(name, new NumberHolder<Integer>(def, def, properties));
        if (properties != null) {
            this.numberStatProperties.put(name, properties);
        }
        this.tablesToUpdate.add(name);
    }

    protected void floatStat(String name) {
        this.floatStat(name, 0.0f, new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
    }

    protected void floatStat(String name, StatProperties properties) {
        this.floatStat(name, 0.0f, properties);
    }

    protected void floatStat(String name, float def, StatProperties properties) {
        if (this.allStatNames.contains(name)) {
            return;
        }
        this.allStatNames.add(name);
        this.floats.put(name, new NumberHolder<Float>(Float.valueOf(def), Float.valueOf(def), properties));
        if (properties != null) {
            this.numberStatProperties.put(name, properties);
        }
        this.tablesToUpdate.add(name);
    }

    protected void doubleStat(String name) {
        this.doubleStat(name, 0.0, new PropertyBuilder().format(StatFormat.FLOAT_P2).perkReward().create());
    }

    protected void doubleStat(String name, StatProperties properties) {
        this.doubleStat(name, 0.0, properties);
    }

    protected void doubleStat(String name, double def, StatProperties properties) {
        if (this.allStatNames.contains(name)) {
            return;
        }
        this.allStatNames.add(name);
        this.doubles.put(name, new NumberHolder<Double>(def, def, properties));
        if (properties != null) {
            this.numberStatProperties.put(name, properties);
        }
        this.tablesToUpdate.add(name);
    }

    protected void stringSetStat(String name) {
        if (this.allStatNames.contains(name)) {
            return;
        }
        this.allStatNames.add(name);
        this.stringSets.put(name, new HashSet());
        this.tablesToUpdate.add(name);
    }

    protected void booleanStat(String name) {
        this.booleanStat(name, false, new BooleanProperties(true, true));
    }

    protected void booleanStat(String name, BooleanProperties properties) {
        this.booleanStat(name, false, properties);
    }

    protected void booleanStat(String name, boolean def, BooleanProperties properties) {
        if (this.allStatNames.contains(name)) {
            return;
        }
        this.allStatNames.add(name);
        this.booleans.put(name, new BooleanHolder(def, def, properties));
        this.tablesToUpdate.add(name);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public StatFormat getStatFormat(String stat) {
        StatProperties properties = this.numberStatProperties.get(stat);
        return properties != null ? properties.getFormat() : null;
    }

    public StatProperties getStatProperties(String stat) {
        return this.numberStatProperties.get(stat);
    }

    public Map<String, StatProperties> getNumberStatProperties() {
        return this.numberStatProperties;
    }

    public Profile getBlankProfile(Player player) {
        return this.getBlankProfile(player.getUniqueId());
    }

    public abstract Profile getBlankProfile(UUID var1);

    @OverridingMethodsMustInvokeSuper
    public void initStats() {
        this.intStat("level", new PropertyBuilder().format(StatFormat.INT).min(0.0).create());
        this.doubleStat("exp", new PropertyBuilder().format(StatFormat.FLOAT_P2).create());
        this.doubleStat("exp_total", new PropertyBuilder().format(StatFormat.FLOAT_P2).min(0.0).create());
        this.intStat("newGamePlus");
        this.intStat("maxAllowedLevel", Short.MAX_VALUE, new PropertyBuilder().format(StatFormat.INT).min(0.0).perkReward().create());
    }

    public void copyStats(Profile profile) {
        this.numberStatProperties.putAll(profile.numberStatProperties);
        this.tablesToUpdate.addAll(profile.tablesToUpdate);
        this.allStatNames.addAll(profile.allStatNames);
        for (Map.Entry<String, NumberHolder<Integer>> entry : profile.ints.entrySet()) {
            this.ints.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<String, NumberHolder<Number>> entry : profile.floats.entrySet()) {
            this.floats.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<String, NumberHolder<Number>> entry : profile.doubles.entrySet()) {
            this.doubles.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<String, Object> entry : profile.stringSets.entrySet()) {
            this.stringSets.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : profile.booleans.entrySet()) {
            this.booleans.put(entry.getKey(), ((BooleanHolder)entry.getValue()).copy());
        }
    }

    public Profile merge(Profile profile, Player owner) {
        Profile merged = this.getBlankProfile(owner.getUniqueId());
        for (String s : this.allStatNames) {
            NumberHolder<Integer> intStat = this.ints.get(s);
            if (intStat != null) {
                NumberHolder<Integer> other = profile.ints.get(s);
                merged.ints.get((Object)s).value = (int)this.mergeNumbers(intStat.properties, ((Integer)intStat.value).intValue(), ((Integer)other.value).intValue(), ((Integer)other.def).intValue());
                continue;
            }
            NumberHolder<Double> doubleStat = this.doubles.get(s);
            if (doubleStat != null) {
                NumberHolder<Double> other = profile.doubles.get(s);
                merged.doubles.get((Object)s).value = this.mergeNumbers(doubleStat.properties, (Double)doubleStat.value, (Double)other.value, (Double)other.def);
                continue;
            }
            NumberHolder<Float> floatStat = this.floats.get(s);
            if (floatStat != null) {
                NumberHolder<Float> other = profile.floats.get(s);
                merged.floats.get((Object)s).value = Float.valueOf((float)this.mergeNumbers(floatStat.properties, ((Float)floatStat.value).floatValue(), ((Float)other.value).floatValue(), ((Float)other.def).floatValue()));
                continue;
            }
            Collection<String> strings = this.stringSets.get(s);
            if (strings != null) {
                HashSet<String> allStrings = new HashSet<String>(profile.stringSets.get(s));
                allStrings.addAll(strings);
                merged.stringSets.put(s, allStrings);
                continue;
            }
            BooleanHolder booleanStat = this.booleans.get(s);
            if (booleanStat != null) {
                BooleanHolder other = profile.booleans.get(s);
                merged.booleans.get(s).setValue(booleanStat.getProperties().shouldPrioritizeTrue() ? other.getValue() || booleanStat.getValue() : other.getValue() && booleanStat.getValue());
                continue;
            }
            ValhallaMMO.logWarning("Stat " + s + " in " + this.getClass().getSimpleName() + " was not associated to datatype");
        }
        return merged;
    }

    private double mergeNumbers(StatProperties mode, double n1, double n2, double def) {
        if (mode.addWhenMerged()) {
            return n1 + n2 - def;
        }
        if (mode.shouldPrioritizePositive()) {
            return Math.max(n1, n2);
        }
        return Math.min(n1, n2);
    }

    public static StatFormat getFormat(Class<? extends Profile> type, String stat) {
        Profile profile = ProfileRegistry.getRegisteredProfiles().get(type);
        for (String i : profile.intStatNames()) {
            if (!i.equals(stat)) continue;
            return profile.getNumberStatProperties().get(i).getFormat();
        }
        for (String i : profile.floatStatNames()) {
            if (!i.equals(stat)) continue;
            return profile.getNumberStatProperties().get(i).getFormat();
        }
        for (String i : profile.doubleStatNames()) {
            if (!i.equals(stat)) continue;
            return profile.getNumberStatProperties().get(i).getFormat();
        }
        return null;
    }

    public void registerPerkRewards() {
        String skill = this.getSkillType().getSimpleName().toLowerCase(Locale.US).replace("skill", "");
        if (this.getSkillType() == null) {
            return;
        }
        for (String s : this.getAllStatNames()) {
            StatProperties properties = this.getNumberStatProperties().get(s);
            if (properties != null && properties.generatePerkRewards()) {
                if (this.intStatNames().contains(s)) {
                    PerkRewardRegistry.register(new ProfileIntAdd(skill + "_" + s + "_add", s, this.getClass()));
                    PerkRewardRegistry.register(new ProfileIntSet(skill + "_" + s + "_set", s, this.getClass()));
                } else if (this.floatStatNames().contains(s)) {
                    PerkRewardRegistry.register(new ProfileFloatAdd(skill + "_" + s + "_add", s, this.getClass()));
                    PerkRewardRegistry.register(new ProfileFloatSet(skill + "_" + s + "_set", s, this.getClass()));
                } else if (this.doubleStatNames().contains(s)) {
                    PerkRewardRegistry.register(new ProfileDoubleAdd(skill + "_" + s + "_add", s, this.getClass()));
                    PerkRewardRegistry.register(new ProfileDoubleSet(skill + "_" + s + "_set", s, this.getClass()));
                }
            }
            if (!this.shouldBooleanStatHavePerkReward(s)) continue;
            PerkRewardRegistry.register(new ProfileBooleanSet(skill + "_" + s + "_set", s, this.getClass()));
            PerkRewardRegistry.register(new ProfileBooleanToggle(skill + "_" + s + "_toggle", s, this.getClass()));
        }
    }

    public Collection<String> getTablesToUpdate() {
        return this.tablesToUpdate;
    }

    protected static class NumberHolder<T extends Number> {
        private T value;
        private final T def;
        private final StatProperties properties;

        public NumberHolder(T value, T def, StatProperties additive) {
            this.value = value;
            this.def = def;
            this.properties = additive;
        }

        public StatProperties getProperties() {
            return this.properties;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public T getDefault() {
            return this.def;
        }

        public NumberHolder<T> copy() {
            return new NumberHolder<T>(this.value, this.def, this.properties);
        }
    }

    protected static class BooleanHolder {
        private boolean value;
        private final boolean def;
        private final BooleanProperties properties;

        public BooleanHolder(boolean value, boolean def, BooleanProperties additive) {
            this.value = value;
            this.def = def;
            this.properties = additive;
        }

        public BooleanProperties getProperties() {
            return this.properties;
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean getDefault() {
            return this.def;
        }

        public BooleanHolder copy() {
            return new BooleanHolder(this.value, this.def, this.properties);
        }
    }
}

