/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.Collection;
import me.athlaeos.valhallammo.item.ArmorSet;
import me.athlaeos.valhallammo.item.ArmorSetRegistry;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.utility.EntityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class AttributeSource
implements AccumulativeStatSource {
    private final String attribute;
    private WeightClass weightClass = null;
    private String statPenalty = null;
    private final boolean negative;

    public AttributeSource(String attribute) {
        this.attribute = attribute;
        this.negative = false;
    }

    public AttributeSource(String attribute, boolean negative) {
        this.attribute = attribute;
        this.negative = negative;
    }

    public AttributeSource penalty(String statPenalty) {
        this.statPenalty = statPenalty;
        return this;
    }

    public AttributeSource weight(WeightClass weightClass) {
        this.weightClass = weightClass;
        return this;
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        if (statPossessor instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)statPossessor;
            double value = (double)(this.negative ? -1 : 1) * EntityUtils.combinedAttributeValue(l, this.attribute, this.weightClass, this.statPenalty, false);
            Collection<ArmorSet> activeSets = ArmorSetRegistry.getActiveArmorSets(l);
            for (ArmorSet set : activeSets) {
                value += (double)(this.negative ? -1 : 1) * set.getSetBonus().getOrDefault(this.attribute, 0.0);
            }
            return value;
        }
        return 0.0;
    }
}

