/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.UUID;
import me.athlaeos.valhallammo.item.WeightClass;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.EntityProperties;
import me.athlaeos.valhallammo.playerstats.EvEAccumulativeStatSource;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.skills.SkillRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProfileStatDefenderArmorWeightSource
implements AccumulativeStatSource,
EvEAccumulativeStatSource {
    private final Class<? extends Profile> type;
    private final String stat;
    private final Class<? extends Number> numberType;
    private final Profile baseProfile;
    private final double def;
    private final WeightClass weightClass;
    private boolean negative = false;

    public ProfileStatDefenderArmorWeightSource(Class<? extends Profile> type, String stat, WeightClass weightClass) {
        this.type = type;
        this.stat = stat;
        this.weightClass = weightClass;
        this.baseProfile = ProfileRegistry.getBlankProfile((UUID)null, type);
        if (this.baseProfile.intStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultInt(stat);
            this.numberType = Integer.class;
        } else if (this.baseProfile.floatStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultFloat(stat);
            this.numberType = Float.class;
        } else if (this.baseProfile.doubleStatNames().contains(stat)) {
            this.def = this.baseProfile.getDefaultDouble(stat);
            this.numberType = Double.class;
        } else {
            this.def = 0.0;
            this.numberType = null;
        }
        if (this.numberType == null) {
            throw new IllegalArgumentException("ProfileStatAttackerWeightSource:" + type.getSimpleName() + " with stat " + stat + " was initialized, but this profile type does not have such a stat");
        }
    }

    public ProfileStatDefenderArmorWeightSource n() {
        this.negative = true;
        return this;
    }

    @Override
    public double fetch(Entity p, boolean use) {
        return this.fetch(p, null, use);
    }

    public StatFormat getFormat() {
        return this.baseProfile.getNumberStatProperties().get(this.stat).getFormat();
    }

    @Override
    public double fetch(Entity victim, Entity attackedBy, boolean use) {
        if (victim instanceof Player) {
            String requiredPermission;
            int quantity;
            Player pl = (Player)victim;
            EntityProperties properties = EntityCache.getAndCacheProperties((LivingEntity)pl);
            switch (this.weightClass) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LIGHT: {
                    int n = properties.getLightArmorCount();
                    break;
                }
                case HEAVY: {
                    int n = properties.getHeavyArmorCount();
                    break;
                }
                case WEIGHTLESS: {
                    int n = properties.getWeightlessArmorCount();
                    break;
                }
                case NONE: {
                    int n = quantity = properties.getNoArmorCount();
                }
            }
            if (quantity == 0) {
                return this.def;
            }
            Profile profile = ProfileCache.getOrCache(pl, this.type);
            String string = requiredPermission = SkillRegistry.isRegistered(profile.getSkillType()) ? SkillRegistry.getSkill(profile.getSkillType()).getRequiredPermission() : null;
            if (requiredPermission != null && !pl.hasPermission(requiredPermission)) {
                return this.def;
            }
            if (this.numberType.equals(Integer.class)) {
                return (this.negative ? -1 : 1) * profile.getInt(this.stat) * quantity;
            }
            if (this.numberType.equals(Float.class)) {
                return (float)(this.negative ? -1 : 1) * profile.getFloat(this.stat) * (float)quantity;
            }
            return (double)(this.negative ? -1 : 1) * profile.getDouble(this.stat) * (double)quantity;
        }
        return this.def;
    }
}

