/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.playerstats.statsources;

import java.util.Collection;
import me.athlaeos.valhallammo.item.ArmorSet;
import me.athlaeos.valhallammo.item.ArmorSetRegistry;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class SetBonusSource
implements AccumulativeStatSource {
    private final String attribute;
    private final boolean negative;

    public SetBonusSource(String attribute) {
        this.attribute = attribute;
        this.negative = false;
    }

    public SetBonusSource(String attribute, boolean negative) {
        this.attribute = attribute;
        this.negative = negative;
    }

    @Override
    public double fetch(Entity statPossessor, boolean use) {
        if (statPossessor instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)statPossessor;
            double value = 0.0;
            Collection<ArmorSet> activeSets = ArmorSetRegistry.getActiveArmorSets(l);
            for (ArmorSet set : activeSets) {
                value += (double)(this.negative ? -1 : 1) * set.getSetBonus().getOrDefault(this.attribute, 0.0);
            }
            return value;
        }
        return 0.0;
    }
}

