/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.event.EntityCustomPotionEffectEvent;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemAttributesRegistry;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.EntityCache;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.CustomEffectDisplay;
import me.athlaeos.valhallammo.potioneffects.CustomEffectSidebarDisplay;
import me.athlaeos.valhallammo.potioneffects.CustomPotionEffect;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.potioneffects.implementations.Bleed;
import me.athlaeos.valhallammo.potioneffects.implementations.ChocolateMilk;
import me.athlaeos.valhallammo.potioneffects.implementations.CleanseBleed;
import me.athlaeos.valhallammo.potioneffects.implementations.Fire;
import me.athlaeos.valhallammo.potioneffects.implementations.GenericWrapper;
import me.athlaeos.valhallammo.potioneffects.implementations.InstantCustomDamage;
import me.athlaeos.valhallammo.potioneffects.implementations.InstantCustomHeal;
import me.athlaeos.valhallammo.potioneffects.implementations.Milk;
import me.athlaeos.valhallammo.potioneffects.implementations.Recall;
import me.athlaeos.valhallammo.potioneffects.implementations.Stun;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.SideBarUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.utility.Utils;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class PotionEffectRegistry {
    private static final NamespacedKey POTION_EFFECTS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "potion_effects");
    private static final NamespacedKey ACTUAL_STORED_EFFECTS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "stored_effects");
    private static final NamespacedKey DEFAULT_STORED_EFFECTS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "default_stored_effects");
    private static final Map<String, PotionEffectWrapper> registeredEffects = new HashMap<String, PotionEffectWrapper>();
    private static final Collection<UUID> entitiesWithEffects = new HashSet<UUID>();
    private static CustomEffectDisplay customEffectDisplay = ValhallaMMO.getPluginConfig().getBoolean("custom_effect_display", true) ? new CustomEffectSidebarDisplay() : null;
    private static final Map<PotionType, Map<String, PotionTypeEffectWrapper>> typeToEffectWrappings = new HashMap<PotionType, Map<String, PotionTypeEffectWrapper>>();

    public static void markAsUnaffected(LivingEntity entity) {
        entitiesWithEffects.remove(entity.getUniqueId());
        if (entity instanceof Player) {
            Player p = (Player)entity;
            SideBarUtils.hideSideBarFromPlayer(p, "valhalla_effects");
        }
    }

    public static void updatePlayerAffectedStatus(Player p) {
        if (!PotionEffectRegistry.getActiveEffects((LivingEntity)p).isEmpty()) {
            entitiesWithEffects.add(p.getUniqueId());
        } else {
            PotionEffectRegistry.markAsUnaffected((LivingEntity)p);
        }
    }

    public static void registerEffects() {
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SPEED", i -> true, "\ued00", StatFormat.ROMAN).addModifier(Material.SUGAR, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SLOW", i -> false, "\ued01", StatFormat.ROMAN).addModifier(Material.ICE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FAST_DIGGING", i -> true, "\ued02", StatFormat.ROMAN).addModifier(Material.GOLDEN_PICKAXE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SLOW_DIGGING", i -> false, "\ued03", StatFormat.ROMAN).addModifier(Material.SPONGE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("INCREASE_DAMAGE", i -> true, "\ued04", StatFormat.ROMAN).addModifier(Material.BLAZE_POWDER, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEAL", i -> true, "\ued05", StatFormat.ROMAN).addModifier(Material.GLISTERING_MELON_SLICE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HARM", i -> false, "\ued06", StatFormat.ROMAN).addModifier(Material.DRAGON_BREATH, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("JUMP", i -> true, "\ued07", StatFormat.ROMAN).addModifier(Material.SLIME_BLOCK, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CONFUSION", i -> false, "\ued08", StatFormat.ROMAN).addModifier(Material.ANVIL, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("REGENERATION", i -> true, "\ued09", StatFormat.ROMAN).addModifier(Material.GHAST_TEAR, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_RESISTANCE", i -> true, "\ued0a", StatFormat.ROMAN).addModifier(Material.ENCHANTED_GOLDEN_APPLE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FIRE_RESISTANCE", i -> true, "\ued0b", StatFormat.ROMAN).addModifier(Material.MAGMA_CREAM, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WATER_BREATHING", i -> true, "\ued0c", StatFormat.ROMAN).addModifier(Material.PUFFERFISH, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("INVISIBILITY", i -> true, "\ued0d", StatFormat.ROMAN).addModifier(Material.GLASS, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLINDNESS", i -> false, "\ued0e", StatFormat.ROMAN).addModifier(Material.INK_SAC, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DARKNESS", i -> false, "\ued0f", StatFormat.ROMAN).addModifier(Material.BLACK_STAINED_GLASS, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("NIGHT_VISION", i -> true, "\ued10", StatFormat.ROMAN).addModifier(Material.GOLDEN_CARROT, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HUNGER", i -> false, "\ued11", StatFormat.ROMAN).addModifier(Material.ROTTEN_FLESH, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WEAKNESS", i -> false, "\ued12", StatFormat.ROMAN).addModifier(Material.WOODEN_SWORD, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("POISON", i -> false, "\ued13", StatFormat.ROMAN).addModifier(Material.SPIDER_EYE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WITHER", i -> false, "\ued14", StatFormat.ROMAN).addModifier(Material.WITHER_SKELETON_SKULL, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEALTH_BOOST", i -> true, "\ued15", StatFormat.ROMAN).addModifier(Material.SWEET_BERRIES, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ABSORPTION", i -> true, "\ued16", StatFormat.ROMAN).addModifier(Material.GOLDEN_APPLE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SATURATION", i -> true, "\ued17", StatFormat.ROMAN).addModifier(Material.COOKED_BEEF, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GLOWING", i -> true, "\ued18", StatFormat.ROMAN).addModifier(Material.GLOWSTONE_DUST, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LEVITATION", i -> false, "\ued19", StatFormat.ROMAN).addModifier(Material.SHULKER_SHELL, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LUCK", i -> true, "\ued1a", StatFormat.ROMAN).addModifier(Material.RABBIT_FOOT, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("UNLUCK", i -> false, "\ued1b", StatFormat.ROMAN).addModifier(Material.BONE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SLOW_FALLING", i -> true, "\ued1c", StatFormat.ROMAN).addModifier(Material.PHANTOM_MEMBRANE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CONDUIT_POWER", i -> true, "\ued1d", StatFormat.ROMAN).addModifier(Material.CONDUIT, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DOLPHINS_GRACE", i -> true, "\ued1e", StatFormat.ROMAN).addModifier(Material.HEART_OF_THE_SEA, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BAD_OMEN", i -> false, "\ued1f", StatFormat.ROMAN).addModifier(Material.IRON_AXE, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HERO_OF_THE_VILLAGE", i -> true, "\ued20", StatFormat.ROMAN).addModifier(Material.EMERALD, 0.01, 0.25));
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
            PotionEffectRegistry.registerNewEffect(new GenericWrapper("INFESTED", i -> false, "\ued21", StatFormat.ROMAN).addModifier(Material.STONE, 0.01, 0.25));
            PotionEffectRegistry.registerNewEffect(new GenericWrapper("OOZING", i -> false, "\ued22", StatFormat.ROMAN).addModifier(Material.SLIME_BLOCK, 0.01, 0.25));
            PotionEffectRegistry.registerNewEffect(new GenericWrapper("WEAVING", i -> false, "\ued23", StatFormat.ROMAN).addModifier(Material.COBWEB, 0.01, 0.25));
            PotionEffectRegistry.registerNewEffect(new GenericWrapper("WIND_CHARGED", i -> false, "\ued24", StatFormat.ROMAN).addModifier(Material.TNT, 0.01, 0.25));
        }
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BOW_STRENGTH", i -> i >= 0.0, "\uee00", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BOW));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARROW_DAMAGE", i -> i >= 0.0, "\uee01", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.ARROW, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("AMMO_CONSUMPTION", i -> i <= 0.0, "\uee02", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPECTRAL_ARROW));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARROW_VELOCITY", i -> i >= 0.0, "\uee03", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CROSSBOW));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARROW_ACCURACY", i -> i >= 0.0, "\uee04", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.TARGET, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARROW_PIERCING", i -> i >= 0.0, "\uee05", StatFormat.DIFFERENCE_INT).addModifier(Material.TIPPED_ARROW, 1.0, 5.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("KNOCKBACK", i -> i >= 0.0, "\uee06", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SLIME_BLOCK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("STUN_CHANCE", i -> i >= 0.0, "\uee07", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_BLOCK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLEED_CHANCE", i -> i >= 0.0, "\uee08", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_AXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLEED_DAMAGE", i -> i >= 0.0, "\uee09", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.NETHERITE_AXE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLEED_DURATION", i -> i >= 0.0, "\uee0a", StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1).addModifier(Material.IRON_AXE, 20.0, 100.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CRIT_CHANCE", i -> i >= 0.0, "\uee0b", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_SWORD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CRIT_DAMAGE", i -> i >= 0.0, "\uee0c", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_SWORD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_PENETRATION_FLAT", i -> i >= 0.0, "\uee0d", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.LEATHER_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIGHT_ARMOR_PENETRATION_FLAT", i -> i >= 0.0, "\uee0e", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.CHAINMAIL_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEAVY_ARMOR_PENETRATION_FLAT", i -> i >= 0.0, "\uee0f", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_PENETRATION_FRACTION", i -> i >= 0.0, "\uee10", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LEATHER_CHESTPLATE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIGHT_ARMOR_PENETRATION_FRACTION", i -> i >= 0.0, "\uee11", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CHAINMAIL_CHESTPLATE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEAVY_ARMOR_PENETRATION_FRACTION", i -> i >= 0.0, "\uee12", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_CHESTPLATE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEAVY_ARMOR_DAMAGE", i -> i >= 0.0, "\uee13", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_HELMET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIGHT_ARMOR_DAMAGE", i -> i >= 0.0, "\uee14", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CHAINMAIL_HELMET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("IMMUNITY_BONUS_FRACTION", i -> i >= 0.0, "\uee15", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ENCHANTED_GOLDEN_APPLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("IMMUNITY_BONUS_FLAT", i -> i >= 0.0, "\uee16", StatFormat.DIFFERENCE_INT).addModifier(Material.GOLDEN_APPLE, 1.0, 5.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("IMMUNITY_REDUCTION", i -> i >= 0.0, "\uee17", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.WITHER_ROSE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_UNARMED", i -> i >= 0.0, "\uee18", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BLAZE_POWDER));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_MELEE", i -> i >= 0.0, "\uee19", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND_SWORD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_RANGED", i -> i >= 0.0, "\uee1a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BOW));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_ALL", i -> i >= 0.0, "\uee1b", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BLAZE_ROD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ATTACK_REACH", i -> i >= 0.0, "\uee1c", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.ENDER_PEARL, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("VELOCITY_DAMAGE", i -> i >= 0.0, "\uee1d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND_HORSE_ARMOR));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DISMOUNT_CHANCE", i -> i >= 0.0, "\uee1e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SADDLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CUSTOM_DAMAGE_RESISTANCE", i -> i >= 0.0, "\uee1f", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_INGOT));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXPLOSION_RESISTANCE", i -> i >= 0.0, "\uee20", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.TNT));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FALL_DAMAGE_RESISTANCE", i -> i >= 0.0, "\uee21", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LEATHER_BOOTS));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CUSTOM_FIRE_RESISTANCE", i -> i >= 0.0, "\uee22", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LAVA_BUCKET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MAGIC_RESISTANCE", i -> i >= 0.0, "\uee23", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DRAGON_BREATH));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLEED_RESISTANCE", i -> i >= 0.0, "\uee24", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.REDSTONE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("STUN_RESISTANCE", i -> i >= 0.0, "\uee25", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.NETHERITE_HELMET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("POISON_RESISTANCE", i -> i >= 0.0, "\uee26", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPIDER_EYE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("PROJECTILE_RESISTANCE", i -> i >= 0.0, "\uee27", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ARROW));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MELEE_RESISTANCE", i -> i >= 0.0, "\uee28", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SHIELD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DODGE_CHANCE", i -> i >= 0.0, "\uee29", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LEATHER_LEGGINGS));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEALING_BONUS", i -> i >= 0.0, "\uee2a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GLISTERING_MELON_SLICE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FOOD_CONSUMPTION", i -> i <= 0.0, "\uee2b", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.APPLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("COOLDOWN_REDUCTION", i -> i >= 0.0, "\uee2c", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CLOCK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXPLOSION_POWER", i -> i >= 0.0, "\uee2d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.TNT_MINECART));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CRAFTING_SPEED", i -> i >= 0.0, "\uee2e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CRAFTING_TABLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ALCHEMY_QUALITY", i -> i >= 0.0, "\uee2f", StatFormat.DIFFERENCE_INT).addModifier(Material.BREWING_STAND, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ALCHEMY_QUALITY_FRACTION", i -> i >= 0.0, "\uee30", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BREWING_STAND));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_QUALITY", i -> i >= 0.0, "\uee31", StatFormat.DIFFERENCE_INT).addModifier(Material.ENCHANTING_TABLE, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_QUALITY_FRACTION", i -> i >= 0.0, "\uee32", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ENCHANTING_TABLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ANVIL_QUALITY_FLAT", i -> i >= 0.0, "\uee33", StatFormat.DIFFERENCE_INT).addModifier(Material.ANVIL, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ANVIL_QUALITY_FRACTION", i -> i >= 0.0, "\uee34", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ANVIL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BREWING_INGREDIENT_CONSUMPTION", i -> i <= 0.0, "\uee35", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GLASS_BOTTLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BREWING_SPEED", i -> i >= 0.0, "\uee36", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BLAZE_ROD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("POTION_CONSUMPTION", i -> i <= 0.0, "\uee37", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPLASH_POTION));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("THROWING_VELOCITY", i -> i >= 0.0, "\uee38", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SNOWBALL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SMITHING_QUALITY", i -> i >= 0.0, "\uee39", StatFormat.DIFFERENCE_INT).addModifier(Material.ANVIL, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SMITHING_QUALITY_FRACTION", i -> i >= 0.0, "\uee3a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ANVIL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MINING_RARE_DROPS", i -> i >= 0.0, "\uee3b", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_PICKAXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MINING_DROPS", i -> i >= 0.0, "\uee3c", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_PICKAXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WOODCUTTING_RARE_DROPS", i -> i >= 0.0, "\uee3d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_AXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WOODCUTTING_DROPS", i -> i >= 0.0, "\uee3e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_AXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DIGGING_RARE_DROPS", i -> i >= 0.0, "\uee3f", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_SHOVEL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DIGGING_DROPS", i -> i >= 0.0, "\uee40", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_SHOVEL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FARMING_RARE_DROPS", i -> i >= 0.0, "\uee41", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_HOE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FARMING_DROPS", i -> i >= 0.0, "\uee42", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_HOE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FISHING_LUCK", i -> i >= 0.0, "\uee43", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.FISHING_ROD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SKILL_EXP_GAIN", i -> i >= 0.0, "\uee44", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BOOK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("VANILLA_EXP_GAIN", i -> i >= 0.0, "\uee45", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.EXPERIENCE_BOTTLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_TAKEN", i -> i <= 0.0, "\uee46", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SKELETON_SKULL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("REFLECT_CHANCE", i -> i >= 0.0, "\uee47", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SHIELD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("REFLECT_FRACTION", i -> i >= 0.0, "\uee48", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SHIELD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SMITHING_MASTERPIECE_FLAT", i -> i >= 0.0, false, true, "\uee49", StatFormat.DIFFERENCE_INT).addModifier(Material.ANVIL, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SMITHING_MASTERPIECE_FRACTION", i -> i >= 0.0, false, true, "\uee4a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ANVIL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_MASTERPIECE_FLAT", i -> i >= 0.0, false, true, "\uee4b", StatFormat.DIFFERENCE_INT).addModifier(Material.ENCHANTING_TABLE, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_MASTERPIECE_FRACTION", i -> i >= 0.0, false, true, "\uee4c", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ENCHANTING_TABLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ALCHEMY_MASTERPIECE_FLAT", i -> i >= 0.0, false, true, "\uee4d", StatFormat.DIFFERENCE_INT).addModifier(Material.BREWING_STAND, 1.0, 10.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ALCHEMY_MASTERPIECE_FRACTION", i -> i >= 0.0, false, true, "\uee4e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BREWING_STAND));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CUSTOM_LUCK", i -> i >= 0.0, "\uee4f", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.RABBIT_FOOT, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_FLAT", i -> i >= 0.0, "\uee50", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_FRACTION", i -> i >= 0.0, "\uee51", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_TOUGHNESS_FLAT", i -> i >= 0.0, "\uee52", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.DIAMOND_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ARMOR_TOUGHNESS_FRACTION", i -> i >= 0.0, "\uee53", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_ATTACK_DAMAGE", i -> i >= 0.0, "\uee54", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.IRON_SWORD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ATTACK_SPEED", i -> i >= 0.0, "\uee55", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_SWORD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("KNOCKBACK_RESISTANCE", i -> i >= 0.0, "\uee56", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.NETHERITE_CHESTPLATE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MAX_HEALTH_FLAT", i -> i >= 0.0, "\uee57", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.GOLDEN_APPLE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MAX_HEALTH_FRACTION", i -> i >= 0.0, "\uee58", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_APPLE, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("MOVEMENT_SPEED", i -> i >= 0.0, "\uee59", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SUGAR));
        PotionEffectRegistry.registerNewEffect(new ChocolateMilk("CHOCOLATE_MILK", "\uee5a").addModifier(Material.COCOA_BEANS, 0.0, 0.0));
        PotionEffectRegistry.registerNewEffect(new Milk("MILK", "\uee5b").addModifier(Material.MILK_BUCKET, 0.0, 0.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SNEAK_MOVEMENT_SPEED_BONUS", i -> i >= 0.0, "\uee5c", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLDEN_BOOTS));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SPRINT_MOVEMENT_SPEED_BONUS", i -> i >= 0.0, "\uee5d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LEATHER_BOOTS));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_EXPLOSION", i -> i >= 0.0, "\uee5e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.TNT_MINECART));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_FIRE", i -> i >= 0.0, "\uee5f", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.FIRE_CHARGE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_MAGIC", i -> i >= 0.0, "\uee60", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPLASH_POTION));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_POISON", i -> i >= 0.0, "\uee61", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPIDER_EYE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_BLUDGEONING", i -> i >= 0.0, "\uee62", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.COBBLESTONE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_LIGHTNING", i -> i >= 0.0, "\uee63", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.PRISMARINE_SHARD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_FREEZING", i -> i >= 0.0, "\uee64", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ICE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_RADIANT", i -> i >= 0.0, "\uee65", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLD_INGOT));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_NECROTIC", i -> i >= 0.0, "\uee66", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BONE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("COOKING_SPEED", i -> i >= 0.0, "\uee67", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BLAST_FURNACE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("JUMP_HEIGHT", i -> i >= 0.0, "\uee68", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SLIME_BLOCK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("JUMPS", i -> i >= 0.0, "\uee69", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.STICKY_PISTON));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_EXPLOSION_DAMAGE", i -> i >= 0.0, "\uee6a", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.TNT, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_FIRE_DAMAGE", i -> i >= 0.0, "\uee6b", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.FIRE_CHARGE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_MAGIC_DAMAGE", i -> i >= 0.0, "\uee6c", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.END_CRYSTAL, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_POISON_DAMAGE", i -> i >= 0.0, "\uee6d", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.SPIDER_EYE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_BLUDGEONING_DAMAGE", i -> i >= 0.0, "\uee6e", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.COBBLESTONE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_LIGHTNING_DAMAGE", i -> i >= 0.0, "\uee6f", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.PRISMARINE_SHARD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_FREEZING_DAMAGE", i -> i >= 0.0, "\uee70", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.ICE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_RADIANT_DAMAGE", i -> i >= 0.0, "\uee71", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.GOLD_INGOT, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("EXTRA_NECROTIC_DAMAGE", i -> i >= 0.0, "\uee72", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.BONE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BLUDGEONING_RESISTANCE", i -> i >= 0.0, "\uee73", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.COBBLESTONE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIGHTNING_RESISTANCE", i -> i >= 0.0, "\uee74", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.PRISMARINE_SHARD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FREEZING_RESISTANCE", i -> i >= 0.0, "\uee75", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ICE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("RADIANT_RESISTANCE", i -> i >= 0.0, "\uee76", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.GOLD_INGOT));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("NECROTIC_RESISTANCE", i -> i >= 0.0, "\uee77", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BONE));
        PotionEffectRegistry.registerNewEffect(new Stun("STUN", "\uee78").addModifier(Material.IRON_BLOCK));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DURABILITY_MULTIPLIER", i -> i >= 0.0, "\uee79", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENTITY_DROPS", i -> i >= 0.0, "\uee7a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CHEST));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIGHT_ARMOR", i -> i >= 0.0, "\uee7b", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.CHAINMAIL_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("HEAVY_ARMOR", i -> i >= 0.0, "\uee7c", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.IRON_CHESTPLATE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CRIT_CHANCE_RESISTANCE", i -> i >= 0.0, "\uee7d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.REDSTONE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("CRIT_DAMAGE_RESISTANCE", i -> i >= 0.0, "\uee7e", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.REDSTONE));
        PotionEffectRegistry.registerNewEffect(new Fire("FIRE", "\uee7f").addModifier(Material.LAVA_BUCKET));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_EXPLOSION_DAMAGE", "ENTITY_EXPLOSION", "\uee80").addModifier(Material.TNT, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_FIRE_DAMAGE", "FIRE", "\uee81").addModifier(Material.FIRE_CHARGE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_POISON_DAMAGE", "POISON", "\uee82").addModifier(Material.SPIDER_EYE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_MAGIC_DAMAGE", "MAGIC", "\uee83").addModifier(Material.END_CRYSTAL, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_MELEE_DAMAGE", "ENTITY_ATTACK", "\uee84").addModifier(Material.IRON_SWORD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_PROJECTILE_DAMAGE", "PROJECTILE", "\uee85").addModifier(Material.ARROW, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_BLUDGEONING_DAMAGE", "BLUDGEONING", "\uee86").addModifier(Material.COBBLESTONE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_LIGHTNING_DAMAGE", "LIGHTNING", "\uee87").addModifier(Material.PRISMARINE_SHARD, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_FREEZING_DAMAGE", "FREEZE", "\uee88").addModifier(Material.ICE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_RADIANT_DAMAGE", "RADIANT", "\uee89").addModifier(Material.GOLD_INGOT, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomDamage("INSTANT_NECROTIC_DAMAGE", "NECROTIC", "\uee8a").addModifier(Material.BONE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new Bleed("BLEED", "\uee8b").addModifier(Material.REDSTONE, 0.05, 1.0));
        PotionEffectRegistry.registerNewEffect(new CleanseBleed("ANTIBLEED", "\uee8c").addModifier(Material.PAPER, 0.0, 0.0));
        PotionEffectRegistry.registerNewEffect(new Recall("RECALL", "\uee8d").addModifier(Material.PAPER, 0.0, 0.0));
        PotionEffectRegistry.registerNewEffect(new InstantCustomHeal("CUSTOM_HEAL", "\uee8e").addModifier(Material.GLISTERING_MELON_SLICE, 0.1, 1.0));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LAPIS_SAVE_CHANCE", i -> i <= 0.0, "\uee8f", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LAPIS_LAZULI));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_REFUND_CHANCE", i -> i >= 0.0, "\uee90", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ENCHANTING_TABLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENCHANTING_REFUND_FRACTION", i -> i >= 0.0, "\uee91", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.EXPERIENCE_BOTTLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LINGERING_DURATION_MULTIPLIER", i -> i >= 0.0, "\uee92", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LINGERING_POTION));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LINGERING_RADIUS_MULTIPLIER", i -> i >= 0.0, "\uee93", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.LINGERING_POTION));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SPLASH_INTENSITY_MINIMUM", i -> i >= 0.0, "\uee94", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.SPLASH_POTION));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ENTITY_RARE_DROPS", i -> i >= 0.0, "\uee95", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.CHEST));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DIG_SPEED", i -> i >= 0.0, "\uee96", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.DIAMOND_PICKAXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_SCALE", i -> i >= 0.0, "\uee9a", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.RED_MUSHROOM, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_BLOCK_INTERACTION_RANGE", i -> i >= 0.0, "\uee9b", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.SCAFFOLDING, 0.01, 0.25));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_STEP_HEIGHT", i -> i >= 0.0, "\uee9c", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.RABBIT_FOOT, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("ATTACK_REACH_MULTIPLIER", i -> i >= 0.0, "\uee9d", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.ENDER_PEARL));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SHIELD_DISARMING", i -> i >= 0.0, "\uee9e", StatFormat.DIFFERENCE_TIME_SECONDS_BASE_20_P1).addModifier(Material.NETHERITE_AXE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("LIFE_STEAL", i -> i >= 0.0, "\uee9f", StatFormat.PERCENTILE_BASE_1_P2).addModifier(Material.GHAST_TEAR));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_GRAVITY", i -> i <= 0.0, "\ueea0", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.BEDROCK, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_SAFE_FALL_DISTANCE", i -> i >= 0.0, "\ueea1", StatFormat.DIFFERENCE_FLOAT_P2).addModifier(Material.LEATHER_BOOTS, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("GENERIC_FALL_DAMAGE_MULTIPLIER", i -> i <= 0.0, "\ueea2", StatFormat.DIFFERENCE_PERCENTILE_BASE_1_P1).addModifier(Material.NETHERITE_BOOTS, 0.01, 0.1));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("PVP_RESISTANCE", i -> i >= 0.0, "\ueea3", StatFormat.PERCENTILE_BASE_1_P2).addModifier(Material.IRON_CHESTPLATE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_PLAYER", i -> i >= 0.0, "\ueea4", StatFormat.PERCENTILE_BASE_1_P2).addModifier(Material.IRON_SWORD));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_MOUNTED", i -> i >= 0.0, "\ueea5", StatFormat.PERCENTILE_BASE_1_P2).addModifier(Material.SADDLE));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("WATER_MOVEMENT_EFFICIENCY", i -> i >= 0.0, "\ueea6", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.CONDUIT));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("SUBMERGED_MINING_SPEED", i -> i >= 0.0, "\ueea7", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.HEART_OF_THE_SEA));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FLIGHT_SPEED_BONUS", i -> i >= 0.0, "\ueea8", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.FEATHER));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("OXYGEN_BONUS", i -> i >= 0.0, "\ueea9", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.TURTLE_HELMET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("BACK_PROTECTION", i -> i >= 0.0, "\ueeaa", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.TURTLE_HELMET));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("FRONT_PROTECTION", i -> i >= 0.0, "\ueeab", StatFormat.PERCENTILE_BASE_1_P1).addModifier(Material.OBSERVER));
        PotionEffectRegistry.registerNewEffect(new GenericWrapper("DAMAGE_ABSORPTION", i -> i >= 0.0, "\ueeac", StatFormat.FLOAT_P2).addModifier(Material.OBSIDIAN));
    }

    public static void reload() {
        registeredEffects.clear();
        PotionEffectRegistry.registerEffects();
    }

    public static void setDefaultStoredEffects(ItemBuilder item, Map<String, PotionEffectWrapper> effects) {
        if (item == null) {
            return;
        }
        if (effects == null || effects.isEmpty()) {
            PotionEffectRegistry.clean(item);
        } else {
            ArrayList<PotionEffectWrapper> sorted = new ArrayList<PotionEffectWrapper>(effects.values());
            sorted.sort(Comparator.comparing(PotionEffectWrapper::getEffect));
            item.stringTag(DEFAULT_STORED_EFFECTS, sorted.stream().map(s -> s.getEffect() + ":" + s.getAmplifier() + ":" + s.getDuration() + (String)(s.getCharges() >= 0 ? ":" + s.getCharges() : "")).collect(Collectors.joining(";")));
        }
    }

    public static Map<String, PotionEffectWrapper> getStoredEffects(ItemMeta meta, boolean def) {
        if (meta == null) {
            return new HashMap<String, PotionEffectWrapper>();
        }
        if (meta.getPersistentDataContainer().has(def ? DEFAULT_STORED_EFFECTS : ACTUAL_STORED_EFFECTS, PersistentDataType.STRING)) {
            return PotionEffectRegistry.parseRawData(PotionEffectRegistry.getRawData(meta, def));
        }
        if (meta instanceof PotionMeta) {
            PotionMeta p = (PotionMeta)meta;
            Map<String, PotionTypeEffectWrapper> wrapper = typeToEffectWrappings.get(ValhallaMMO.getNms().getPotionType(p));
            if (wrapper == null) {
                return new HashMap<String, PotionEffectWrapper>();
            }
            return wrapper.values().stream().map(e -> e.get(ValhallaMMO.getNms().isUpgraded(p), ValhallaMMO.getNms().isExtended(p))).collect(Collectors.toMap(PotionEffectWrapper::getEffect, e -> e));
        }
        return new HashMap<String, PotionEffectWrapper>();
    }

    public static String getRawData(ItemMeta meta, boolean def) {
        if (meta == null) {
            return null;
        }
        return ItemUtils.getPDCString(def ? DEFAULT_STORED_EFFECTS : ACTUAL_STORED_EFFECTS, meta, null);
    }

    public static Map<String, PotionEffectWrapper> parseRawData(String data) {
        HashMap<String, PotionEffectWrapper> effects = new HashMap<String, PotionEffectWrapper>();
        if (!StringUtils.isEmpty(data)) {
            for (String effectDetails : data.split(";")) {
                String[] args = effectDetails.split(":");
                if (args.length < 3) continue;
                try {
                    int charges;
                    String effect = args[0];
                    double amplifier = StringUtils.parseDouble(args[1]);
                    long duration = Long.parseLong(args[2]);
                    int n = charges = args.length > 3 ? Integer.parseInt(args[3]) : -1;
                    if (charges == 0) continue;
                    PotionEffectWrapper wrapper = PotionEffectRegistry.getEffect(effect);
                    wrapper.setAmplifier(amplifier);
                    wrapper.setDuration(duration);
                    wrapper.setCharges(charges);
                    effects.put(effect, wrapper);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return effects;
    }

    public static void updateEffectLore(ItemBuilder item) {
        PotionEffectRegistry.getStoredEffects(item.getMeta(), false).values().forEach(w -> w.onApply(item));
    }

    public static void setActualStoredEffects(ItemBuilder item, Map<String, PotionEffectWrapper> effects) {
        if (item == null) {
            return;
        }
        if (effects == null || effects.isEmpty()) {
            PotionEffectRegistry.clean(item);
        } else {
            ItemMeta itemMeta = item.getMeta();
            if (itemMeta instanceof PotionMeta) {
                PotionMeta p = (PotionMeta)itemMeta;
                p.clearCustomEffects();
            }
            registeredEffects.values().stream().filter(w -> effects.containsKey(w.getEffect())).forEach(w -> w.onRemove(item));
            Map<String, PotionEffectWrapper> defaultEffects = PotionEffectRegistry.getStoredEffects(item.getMeta(), true);
            HashSet<String> exclude = new HashSet<String>();
            ArrayList<PotionEffectWrapper> orderedWrappers = new ArrayList<PotionEffectWrapper>(effects.values());
            orderedWrappers.sort(Comparator.comparingInt(a -> a.getEffectName().length()).thenComparing(PotionEffectWrapper::getEffect));
            Collections.reverse(orderedWrappers);
            for (PotionEffectWrapper effect : orderedWrappers) {
                if (!defaultEffects.containsKey(effect.getEffect()) || effect.getCharges() == 0) {
                    exclude.add(effect.getEffect());
                    continue;
                }
                if (effect.isVanilla()) {
                    int amplifier = Math.max(0, (int)Math.floor(effect.getAmplifier()));
                    int duration = (int)effect.getDuration();
                    ItemMeta itemMeta2 = item.getMeta();
                    if (itemMeta2 instanceof PotionMeta) {
                        PotionMeta p = (PotionMeta)itemMeta2;
                        p.addCustomEffect(new PotionEffect(effect.getVanillaEffect(), duration, amplifier), true);
                    }
                }
                effect.onApply(item);
            }
            ItemMeta itemMeta3 = item.getMeta();
            if (itemMeta3 instanceof PotionMeta) {
                PotionMeta p = (PotionMeta)itemMeta3;
                ValhallaMMO.getNms().setPotionType(p, MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? null : PotionType.valueOf((String)"UNCRAFTABLE"));
            }
            ArrayList<PotionEffectWrapper> sorted = new ArrayList<PotionEffectWrapper>(effects.values());
            sorted.sort(Comparator.comparing(PotionEffectWrapper::getEffect));
            item.stringTag(ACTUAL_STORED_EFFECTS, sorted.stream().filter(e -> !exclude.contains(e.getEffect())).map(e -> e.getEffect() + ":" + e.getAmplifier() + ":" + e.getDuration() + (String)(e.getCharges() >= 0 ? ":" + e.getCharges() : "")).collect(Collectors.joining(";")));
        }
    }

    public static PotionEffectWrapper getStoredEffect(ItemMeta meta, String effect, boolean def) {
        return PotionEffectRegistry.getStoredEffects(meta, def).get(effect);
    }

    public static void addDefaultEffect(ItemBuilder item, PotionEffectWrapper wrapper) {
        Map<String, PotionEffectWrapper> defaultEffects = PotionEffectRegistry.getStoredEffects(item.getMeta(), true);
        if (wrapper.getAmplifier() != (double)(wrapper.isVanilla ? -1 : 0)) {
            defaultEffects.put(wrapper.getEffect(), wrapper);
        } else {
            defaultEffects.remove(wrapper.getEffect());
        }
        PotionEffectRegistry.setDefaultStoredEffects(item, defaultEffects);
        Map<String, PotionEffectWrapper> actualEffects = PotionEffectRegistry.getStoredEffects(item.getMeta(), false);
        if (wrapper.getAmplifier() != (double)(wrapper.isVanilla ? -1 : 0)) {
            actualEffects.putIfAbsent(wrapper.getEffect(), wrapper);
        } else {
            actualEffects.remove(wrapper.getEffect());
        }
        PotionEffectRegistry.setActualStoredEffects(item, actualEffects);
    }

    public static void removeEffect(ItemBuilder item, String effect) {
        Map<String, PotionEffectWrapper> defaultEffects = PotionEffectRegistry.getStoredEffects(item.getMeta(), true);
        defaultEffects.remove(effect);
        PotionEffectRegistry.setDefaultStoredEffects(item, defaultEffects);
        Map<String, PotionEffectWrapper> actualEffects = PotionEffectRegistry.getStoredEffects(item.getMeta(), false);
        actualEffects.remove(effect);
        PotionEffectRegistry.setActualStoredEffects(item, actualEffects);
    }

    public static void setStoredEffect(ItemBuilder item, String effect, double amplifier, long duration, int charges, boolean def) {
        PotionEffectWrapper wrapper = PotionEffectRegistry.getEffect(effect);
        if (wrapper == null) {
            return;
        }
        wrapper.setAmplifier(amplifier);
        wrapper.setDuration(duration);
        wrapper.setCharges(charges);
        PotionEffectRegistry.setStoredEffect(item, wrapper, def);
    }

    public static void setStoredEffect(ItemBuilder item, PotionEffectWrapper wrapper, boolean def) {
        Map<String, PotionEffectWrapper> stats = PotionEffectRegistry.getStoredEffects(item.getMeta(), def);
        if (!stats.containsKey(wrapper.getEffect())) {
            return;
        }
        stats.put(wrapper.getEffect(), wrapper);
        if (def) {
            PotionEffectRegistry.setDefaultStoredEffects(item, stats);
        } else {
            PotionEffectRegistry.setActualStoredEffects(item, stats);
        }
    }

    public static boolean spendCharge(ItemBuilder item, String effect) {
        PotionEffectWrapper wrapper = PotionEffectRegistry.getStoredEffect(item.getMeta(), effect, false);
        if (wrapper == null) {
            return false;
        }
        if ((wrapper = wrapper.copy()).getCharges() < 0) {
            return true;
        }
        if (wrapper.getCharges() == 0) {
            return false;
        }
        if (wrapper.getCharges() == 1) {
            PotionEffectRegistry.removeEffect(item, effect);
            CustomFlag.removeItemFlag(item.getMeta(), CustomFlag.TEMPORARY_POTION_DISPLAY);
            if (ItemAttributesRegistry.hasCustomStats(item.getMeta())) {
                ItemAttributesRegistry.setActualStats(item, ItemAttributesRegistry.getStats(item.getMeta(), false));
            }
        } else {
            wrapper.setCharges(wrapper.getCharges() - 1);
            PotionEffectRegistry.setStoredEffect(item, wrapper, false);
        }
        return true;
    }

    public static int getCharges(ItemMeta meta, String effect) {
        PotionEffectWrapper wrapper = PotionEffectRegistry.getStoredEffect(meta, effect, false);
        return wrapper == null ? 0 : wrapper.getCharges();
    }

    public static void clean(ItemBuilder item) {
        item.getMeta().getPersistentDataContainer().remove(DEFAULT_STORED_EFFECTS);
        item.getMeta().getPersistentDataContainer().remove(ACTUAL_STORED_EFFECTS);
        ItemMeta itemMeta = item.getMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta p = (PotionMeta)itemMeta;
            p.clearCustomEffects();
        }
        registeredEffects.values().forEach(a -> a.onRemove(item));
    }

    public static Map<String, CustomPotionEffect> getActiveEffects(LivingEntity p) {
        Player pl;
        HashMap<String, CustomPotionEffect> effects = new HashMap<String, CustomPotionEffect>();
        if (p instanceof Player && !(pl = (Player)p).isOnline() || !p.isValid() || p.isDead()) {
            return effects;
        }
        String encodedEffects = (String)p.getPersistentDataContainer().getOrDefault(POTION_EFFECTS, PersistentDataType.STRING, (Object)"");
        if (!StringUtils.isEmpty(encodedEffects)) {
            for (String encodedEffect : encodedEffects.split(";")) {
                String effect;
                PotionEffectWrapper customEffect;
                String[] args = encodedEffect.split(":");
                if (args.length != 3 || (customEffect = registeredEffects.get(effect = args[0])) == null || customEffect.isVanilla()) continue;
                long effectiveUntil = Long.parseLong(args[1]);
                double amplifier = StringUtils.parseDouble(args[2].replace(",", "."));
                if (effectiveUntil != -1L && effectiveUntil < System.currentTimeMillis()) continue;
                effects.put(effect, new CustomPotionEffect(customEffect, effectiveUntil, amplifier));
            }
        }
        return effects;
    }

    public static void setActiveEffects(LivingEntity e, Collection<CustomPotionEffect> effects) {
        Map<String, CustomPotionEffect> currentEffects = PotionEffectRegistry.getActiveEffects(e);
        if (effects == null || effects.isEmpty()) {
            for (CustomPotionEffect effect : currentEffects.values()) {
                effect.setEffectiveUntil(0L);
                PotionEffectRegistry.addEffect(e, null, effect, true, 1.0, EntityPotionEffectEvent.Cause.PLUGIN, EntityPotionEffectEvent.Action.CLEARED);
            }
        } else {
            for (CustomPotionEffect effect : effects) {
                PotionEffectRegistry.addEffect(e, null, effect, true, 1.0, EntityPotionEffectEvent.Cause.PLUGIN, currentEffects.containsKey(effect.getWrapper().getEffect()) ? EntityPotionEffectEvent.Action.CHANGED : EntityPotionEffectEvent.Action.ADDED);
            }
        }
        EntityCache.resetPotionEffects(e);
    }

    private static void setActiveEffects(LivingEntity p, Map<String, CustomPotionEffect> effects) {
        if (effects == null || effects.isEmpty()) {
            p.getPersistentDataContainer().remove(POTION_EFFECTS);
        } else {
            String effect = effects.values().stream().filter(e -> e.getEffectiveUntil() == -1L || e.getEffectiveUntil() > System.currentTimeMillis()).map(e -> String.format("%s:%d:%.6f", e.getWrapper().getEffect(), e.getEffectiveUntil(), e.getAmplifier())).collect(Collectors.joining(";"));
            p.getPersistentDataContainer().set(POTION_EFFECTS, PersistentDataType.STRING, (Object)effect);
        }
        EntityCache.resetPotionEffects(p);
    }

    public static void addEffect(LivingEntity e, LivingEntity causedBy, CustomPotionEffect effect, boolean force, double intensity, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        if (!registeredEffects.containsKey(effect.getWrapper().getEffect())) {
            ValhallaMMO.logWarning("Attempting to apply custom effect " + String.valueOf(effect.getWrapper()) + ", but it was not registered");
            return;
        }
        Map<String, CustomPotionEffect> currentEffects = PotionEffectRegistry.getActiveEffects(e);
        EntityCustomPotionEffectEvent event = new EntityCustomPotionEffectEvent(e, currentEffects.get(effect.getWrapper().getEffect()), effect, cause, action, force);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            CustomPotionEffect newEffect = event.getNewEffect();
            if (newEffect.getWrapper().isInstant()) {
                newEffect.getWrapper().onInflict(e, causedBy, newEffect.getAmplifier(), newEffect.getOriginalDuration(), intensity);
                return;
            }
            if (!event.isOverride() && currentEffects.containsKey(newEffect.getWrapper().getEffect()) && currentEffects.get(newEffect.getWrapper().getEffect()).getAmplifier() > newEffect.getAmplifier()) {
                return;
            }
            if (newEffect.getEffectiveUntil() == -1L || newEffect.getEffectiveUntil() > 0L) {
                currentEffects.put(newEffect.getWrapper().getEffect(), event.getNewEffect());
                newEffect.getWrapper().onInflict(e, causedBy, newEffect.getAmplifier(), newEffect.getOriginalDuration(), intensity);
            } else {
                currentEffects.remove(event.getNewEffect().getWrapper().getEffect());
                newEffect.getWrapper().onExpire(e);
            }
            if (currentEffects.isEmpty()) {
                PotionEffectRegistry.markAsUnaffected(e);
            } else {
                entitiesWithEffects.add(e.getUniqueId());
            }
            PotionEffectRegistry.setActiveEffects(e, currentEffects);
        }
    }

    public static void addEffect(LivingEntity e, LivingEntity causedBy, CustomPotionEffect effect, boolean force, double intensity, EntityPotionEffectEvent.Cause cause) {
        Map<String, CustomPotionEffect> currentEffects = PotionEffectRegistry.getActiveEffects(e);
        EntityPotionEffectEvent.Action action = currentEffects.containsKey(effect.getWrapper().getEffect()) ? EntityPotionEffectEvent.Action.CHANGED : (effect.getEffectiveUntil() != -1L && effect.getEffectiveUntil() < 0L ? EntityPotionEffectEvent.Action.REMOVED : EntityPotionEffectEvent.Action.ADDED);
        PotionEffectRegistry.addEffect(e, causedBy, effect, force, intensity, cause, action);
    }

    public static void removePotionEffects(LivingEntity e, EntityPotionEffectEvent.Cause cause, Predicate<CustomPotionEffect> filter) {
        for (CustomPotionEffect eff : PotionEffectRegistry.getActiveEffects(e).values()) {
            if (filter != null && !filter.test(eff)) continue;
            eff.setEffectiveUntil(0L);
            PotionEffectRegistry.addEffect(e, null, eff, true, 1.0, cause);
        }
        EntityCache.resetPotionEffects(e);
    }

    public static long getActiveDuration(LivingEntity e, String effect) {
        CustomPotionEffect activeEffect = PotionEffectRegistry.getActiveEffects(e).get(effect);
        if (activeEffect != null) {
            if (activeEffect.getEffectiveUntil() == -1L) {
                return -1L;
            }
            if (activeEffect.getEffectiveUntil() > System.currentTimeMillis()) {
                return activeEffect.getEffectiveUntil() - System.currentTimeMillis();
            }
        }
        return 0L;
    }

    public static double getActiveAmplifier(LivingEntity e, String effect, boolean use) {
        CustomPotionEffect activeEffect = PotionEffectRegistry.getActiveEffects(e).get(effect);
        if (activeEffect != null) {
            if (use && activeEffect.getWrapper().isSingleUse()) {
                activeEffect.setEffectiveUntil(0L);
                PotionEffectRegistry.addEffect(e, null, activeEffect, true, 1.0, EntityPotionEffectEvent.Cause.EXPIRATION, EntityPotionEffectEvent.Action.REMOVED);
            }
            EntityCache.resetPotionEffects(e);
            return activeEffect.getAmplifier();
        }
        return 0.0;
    }

    public static CustomPotionEffect getActiveEffect(LivingEntity e, String effect) {
        CustomPotionEffect activeEffect = PotionEffectRegistry.getActiveEffects(e).get(effect);
        if (activeEffect != null && (activeEffect.getEffectiveUntil() == -1L || activeEffect.getEffectiveUntil() > System.currentTimeMillis())) {
            return activeEffect;
        }
        return null;
    }

    public static void registerNewEffect(PotionEffectWrapper effect) {
        registeredEffects.put(effect.getEffect(), effect);
    }

    public static Map<String, PotionEffectWrapper> getRegisteredEffects() {
        return Collections.unmodifiableMap(registeredEffects);
    }

    public static PotionEffectWrapper getEffect(String effect) {
        if (!registeredEffects.containsKey(effect)) {
            throw new IllegalArgumentException("Custom potion effect " + effect + " does not exist!");
        }
        return registeredEffects.get(effect).copy();
    }

    public static Collection<UUID> affectedEntityTracker() {
        return entitiesWithEffects;
    }

    public static CustomEffectDisplay getCustomEffectDisplay() {
        return customEffectDisplay;
    }

    public static void setCustomEffectDisplay(CustomEffectDisplay customEffectDisplay) {
        PotionEffectRegistry.customEffectDisplay = customEffectDisplay;
    }

    public static void updateItemName(ItemBuilder item, boolean override, boolean combined) {
        if (item == null) {
            return;
        }
        Material base = item.getItem().getType();
        String c = combined ? "combined_" : "";
        String key = switch (base) {
            case Material.SPLASH_POTION -> "potion_splash_format";
            case Material.LINGERING_POTION -> "potion_lingering_format";
            case Material.TIPPED_ARROW -> "tipped_arrow_format";
            case Material.POTION -> "potion_base_format";
            default -> "item_generic_format";
        };
        String plainFormat = TranslationManager.getTranslation(key);
        String format = TranslationManager.getTranslation(c + key);
        if (item.getName() == null || override || ChatColor.stripColor((String)item.getName()).contains(ChatColor.stripColor((String)Utils.chat(plainFormat.replace("%effect%", ""))))) {
            Map<String, PotionEffectWrapper> effects = PotionEffectRegistry.getStoredEffects(item.getMeta(), true);
            if (effects.isEmpty()) {
                PotionType type;
                ItemMeta itemMeta = item.getMeta();
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta pm = (PotionMeta)itemMeta;
                    v1 = ValhallaMMO.getNms().getPotionType(pm);
                } else {
                    v1 = type = null;
                }
                if (type != null) {
                    for (PotionTypeEffectWrapper typeWrapper : ((Map)typeToEffectWrappings.getOrDefault(type, new HashMap())).values()) {
                        PotionEffectWrapper effectWrapper;
                        PotionEffectWrapper potionEffectWrapper = effectWrapper = typeWrapper.potionEffectType == null ? null : PotionEffectRegistry.getEffect(typeWrapper.potionEffectType);
                        if (effectWrapper == null) continue;
                        effects.put(effectWrapper.getEffect(), effectWrapper);
                    }
                }
            }
            if (effects.isEmpty()) {
                return;
            }
            PotionEffectWrapper effectForName = effects.values().stream().findAny().orElse(null);
            String effectName = effectForName.getPotionName();
            item.name(Utils.chat(format.replace("%icon%", effectForName.getEffectIcon()).replace("%effect%", effectName).replace("%item%", ItemUtils.getItemName(item))));
        }
    }

    public static String getItemName(ItemBuilder item, boolean combined) {
        Material base = item.getItem().getType();
        String c = combined ? "combined_" : "";
        String key = switch (base) {
            case Material.SPLASH_POTION -> "potion_splash_format";
            case Material.LINGERING_POTION -> "potion_lingering_format";
            case Material.TIPPED_ARROW -> "tipped_arrow_format";
            case Material.POTION -> "potion_base_format";
            default -> "item_generic_format";
        };
        String plainFormat = TranslationManager.getTranslation(key);
        String format = TranslationManager.getTranslation(c + key);
        if (ChatColor.stripColor((String)item.getName()).contains(ChatColor.stripColor((String)Utils.chat(plainFormat.replace("%effect%", ""))))) {
            Map<String, PotionEffectWrapper> effects = PotionEffectRegistry.getStoredEffects(item.getMeta(), true);
            if (effects.isEmpty()) {
                PotionType type;
                ItemMeta itemMeta = item.getMeta();
                if (itemMeta instanceof PotionMeta) {
                    PotionMeta pm = (PotionMeta)itemMeta;
                    v1 = ValhallaMMO.getNms().getPotionType(pm);
                } else {
                    v1 = type = null;
                }
                if (type != null) {
                    for (PotionTypeEffectWrapper typeWrapper : ((Map)typeToEffectWrappings.getOrDefault(type, new HashMap())).values()) {
                        PotionEffectWrapper effectWrapper;
                        PotionEffectWrapper potionEffectWrapper = effectWrapper = typeWrapper.potionEffectType == null ? null : PotionEffectRegistry.getEffect(typeWrapper.potionEffectType);
                        if (effectWrapper == null) continue;
                        effects.put(effectWrapper.getEffect(), effectWrapper);
                    }
                }
            }
            if (effects.isEmpty()) {
                return null;
            }
            PotionEffectWrapper effectForName = effects.values().stream().findAny().orElse(null);
            String effectName = effectForName.getPotionName();
            return Utils.chat(format.replace("%icon%", effectForName.getEffectIcon()).replace("%effect%", effectName).replace("%item%", ItemUtils.getItemName(item)));
        }
        return null;
    }

    static {
        if (MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5)) {
            typeToEffectWrappings.put(PotionType.valueOf((String)"FIRE_RESISTANCE"), Map.of("FIRE_RESISTANCE", new PotionTypeEffectWrapper("FIRE_RESISTANCE").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_FIRE_RESISTANCE"), Map.of("FIRE_RESISTANCE", new PotionTypeEffectWrapper("FIRE_RESISTANCE").dB(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"HARMING"), Map.of("INSTANT_DAMAGE", new PotionTypeEffectWrapper("INSTANT_DAMAGE").aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_HARMING"), Map.of("INSTANT_DAMAGE", new PotionTypeEffectWrapper("INSTANT_DAMAGE").aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"HEALING"), Map.of("INSTANT_HEALTH", new PotionTypeEffectWrapper("INSTANT_HEALTH").aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_HEALING"), Map.of("INSTANT_HEALTH", new PotionTypeEffectWrapper("INSTANT_HEALTH").aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"INVISIBILITY"), Map.of("INVISIBILITY", new PotionTypeEffectWrapper("INVISIBILITY").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_INVISIBILITY"), Map.of("INVISIBILITY", new PotionTypeEffectWrapper("INVISIBILITY").dB(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LEAPING"), Map.of("JUMP_BOOST", new PotionTypeEffectWrapper("JUMP_BOOST").dB(180).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_LEAPING"), Map.of("JUMP_BOOST", new PotionTypeEffectWrapper("JUMP_BOOST").dB(480).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_LEAPING"), Map.of("JUMP_BOOST", new PotionTypeEffectWrapper("JUMP_BOOST").dB(180).aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LUCK"), Map.of("LUCK", new PotionTypeEffectWrapper("LUCK").dB(300)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"NIGHT_VISION"), Map.of("NIGHT_VISION", new PotionTypeEffectWrapper("NIGHT_VISION").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_NIGHT_VISION"), Map.of("NIGHT_VISION", new PotionTypeEffectWrapper("NIGHT_VISION").dB(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"POISON"), Map.of("POISON", new PotionTypeEffectWrapper("POISON").dB(45).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_POISON"), Map.of("POISON", new PotionTypeEffectWrapper("POISON").dB(90).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_POISON"), Map.of("POISON", new PotionTypeEffectWrapper("POISON").dB(22).aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"REGENERATION"), Map.of("REGENERATION", new PotionTypeEffectWrapper("REGENERATION").dB(45).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_REGENERATION"), Map.of("REGENERATION", new PotionTypeEffectWrapper("REGENERATION").dB(90).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_REGENERATION"), Map.of("REGENERATION", new PotionTypeEffectWrapper("REGENERATION").dB(22).aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SLOW_FALLING"), Map.of("SLOW_FALLING", new PotionTypeEffectWrapper("SLOW_FALLING").dB(90)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_SLOW_FALLING"), Map.of("SLOW_FALLING", new PotionTypeEffectWrapper("SLOW_FALLING").dB(240)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SLOWNESS"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(90).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_SLOWNESS"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(240).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_SLOWNESS"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(20).aB(4)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SWIFTNESS"), Map.of("SWIFTNESS", new PotionTypeEffectWrapper("SWIFTNESS").dB(180).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_SWIFTNESS"), Map.of("SWIFTNESS", new PotionTypeEffectWrapper("SWIFTNESS").dB(480).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_SWIFTNESS"), Map.of("SWIFTNESS", new PotionTypeEffectWrapper("SWIFTNESS").dB(180).aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRENGTH"), Map.of("STRENGTH", new PotionTypeEffectWrapper("STRENGTH").dB(180).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_STRENGTH"), Map.of("STRENGTH", new PotionTypeEffectWrapper("STRENGTH").dB(480).aB(0)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_STRENGTH"), Map.of("STRENGTH", new PotionTypeEffectWrapper("STRENGTH").dB(180).aB(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"TURTLE_MASTER"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(20).aB(3), "DAMAGE_RESISTANCE", new PotionTypeEffectWrapper("RESISTANCE").dB(20).aB(2)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_TURTLE_MASTER"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(40).aB(3), "DAMAGE_RESISTANCE", new PotionTypeEffectWrapper("RESISTANCE").dB(40).aB(2)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRONG_TURTLE_MASTER"), Map.of("SLOWNESS", new PotionTypeEffectWrapper("SLOWNESS").dB(20).aB(5), "DAMAGE_RESISTANCE", new PotionTypeEffectWrapper("RESISTANCE").dB(20).aB(3)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WATER_BREATHING"), Map.of("WATER_BREATHING", new PotionTypeEffectWrapper("WATER_BREATHING").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_WATER_BREATHING"), Map.of("WATER_BREATHING", new PotionTypeEffectWrapper("WATER_BREATHING").dB(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WEAKNESS"), Map.of("WEAKNESS", new PotionTypeEffectWrapper("WEAKNESS").dB(90)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LONG_WEAKNESS"), Map.of("WEAKNESS", new PotionTypeEffectWrapper("WEAKNESS").dB(240)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"INFESTED"), Map.of("INFESTED", new PotionTypeEffectWrapper("INFESTED").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"OOZING"), Map.of("OOZING", new PotionTypeEffectWrapper("OOZING").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WEAVING"), Map.of("WEAVING", new PotionTypeEffectWrapper("WEAVING").dB(180)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WIND_CHARGED"), Map.of("WIND_CHARGED", new PotionTypeEffectWrapper("WIND_CHARGED").dB(180)));
        } else {
            typeToEffectWrappings.put(PotionType.valueOf((String)"FIRE_RESISTANCE"), Map.of("FIRE_RESISTANCE", new PotionTypeEffectWrapper("FIRE_RESISTANCE").dB(180).dEx(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"INSTANT_DAMAGE"), Map.of("HARM", new PotionTypeEffectWrapper("HARM").aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"INSTANT_HEAL"), Map.of("HEAL", new PotionTypeEffectWrapper("HEAL").aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"INVISIBILITY"), Map.of("INVISIBILITY", new PotionTypeEffectWrapper("INVISIBILITY").dB(180).dEx(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"JUMP"), Map.of("JUMP", new PotionTypeEffectWrapper("JUMP").dB(180).dEx(480).dUp(180).aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"LUCK"), Map.of("LUCK", new PotionTypeEffectWrapper("LUCK").dB(300)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"NIGHT_VISION"), Map.of("NIGHT_VISION", new PotionTypeEffectWrapper("NIGHT_VISION").dB(180).dEx(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"POISON"), Map.of("POISON", new PotionTypeEffectWrapper("POISON").dB(45).dEx(90).dUp(22).aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"REGEN"), Map.of("REGENERATION", new PotionTypeEffectWrapper("REGENERATION").dB(45).dEx(90).dUp(22).aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SLOW_FALLING"), Map.of("SLOW_FALLING", new PotionTypeEffectWrapper("SLOW_FALLING").dB(90).dEx(240)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SLOWNESS"), Map.of("SLOW", new PotionTypeEffectWrapper("SLOW").dB(90).dEx(240).dUp(20).aB(0).aU(4)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"SPEED"), Map.of("SPEED", new PotionTypeEffectWrapper("SPEED").dB(180).dEx(480).dUp(180).aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"STRENGTH"), Map.of("INCREASE_DAMAGE", new PotionTypeEffectWrapper("INCREASE_DAMAGE").dB(180).dEx(480).dUp(180).aB(0).aU(1)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"TURTLE_MASTER"), Map.of("SLOW", new PotionTypeEffectWrapper("SLOW").dB(20).dEx(40).dUp(20).aB(3).aU(5), "DAMAGE_RESISTANCE", new PotionTypeEffectWrapper("DAMAGE_RESISTANCE").dB(20).dEx(40).dUp(20).aB(2).aU(3)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WATER_BREATHING"), Map.of("WATER_BREATHING", new PotionTypeEffectWrapper("WATER_BREATHING").dB(180).dEx(480)));
            typeToEffectWrappings.put(PotionType.valueOf((String)"WEAKNESS"), Map.of("WEAKNESS", new PotionTypeEffectWrapper("WEAKNESS").dB(90).dEx(240)));
        }
    }

    private static class PotionTypeEffectWrapper {
        private final String potionEffectType;
        private int durationBase = 0;
        private int durationUpgraded = 0;
        private int durationExtended = 0;
        private int amplifierBase = 0;
        private int amplifierUpgraded = 0;

        public PotionTypeEffectWrapper(String type) {
            this.potionEffectType = type;
        }

        public PotionTypeEffectWrapper dB(int duration) {
            this.durationBase = duration * 20;
            return this;
        }

        public PotionTypeEffectWrapper dUp(int duration) {
            this.durationUpgraded = duration * 20;
            return this;
        }

        public PotionTypeEffectWrapper dEx(int duration) {
            this.durationExtended = duration * 20;
            return this;
        }

        public PotionTypeEffectWrapper aB(int amplifier) {
            this.amplifierBase = amplifier;
            return this;
        }

        public PotionTypeEffectWrapper aU(int amplifier) {
            this.amplifierUpgraded = amplifier;
            return this;
        }

        public PotionEffectWrapper get(boolean upgraded, boolean extended) {
            return PotionEffectRegistry.getEffect(PotionEffectMappings.getEffect(this.potionEffectType).getOldEffect()).setAmplifier(upgraded ? (double)this.amplifierUpgraded : (double)this.amplifierBase).setDuration(extended ? (long)this.durationExtended : (upgraded ? (long)this.durationUpgraded : (long)this.durationBase));
        }
    }
}

