/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.effect_triggers.implementations;

import me.athlaeos.valhallammo.dom.DayTime;
import me.athlaeos.valhallammo.potioneffects.effect_triggers.EffectTrigger;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;

public class DayTimeOrLightExposure
implements EffectTrigger.ConstantTrigger {
    private final Boolean day;
    private final Boolean light;
    private final Boolean outside;

    public DayTimeOrLightExposure(Boolean day, Boolean light, Boolean outside) {
        this.day = day;
        this.light = light;
        this.outside = outside;
    }

    @Override
    public boolean shouldTrigger(LivingEntity entity) {
        boolean outside;
        DayTime time = DayTime.getTime(entity.getWorld());
        Block b = entity.getEyeLocation().getBlock();
        byte lightLevel = b.getLightLevel();
        byte skyExposure = b.getLightFromSky();
        if (time.isDay()) {
            lightLevel = (byte)Math.max(lightLevel, skyExposure);
        }
        if (lightLevel == 15 && b.getWorld().getHighestBlockYAt(b.getLocation()) > b.getY()) {
            skyExposure = (byte)(skyExposure - 1);
        }
        boolean bl = outside = skyExposure > 14;
        if (this.day != null) {
            if (this.light != null) {
                if (this.light.booleanValue() && lightLevel > 0) {
                    return this.outside == null || this.outside == outside;
                }
                if (!this.light.booleanValue() && lightLevel <= 0) {
                    return this.outside == null || this.outside == outside;
                }
                if (time == DayTime.TIMELESS) {
                    return false;
                }
                return this.day.booleanValue() == time.isDay() && (this.outside == null || this.outside == outside);
            }
            if (time == DayTime.TIMELESS) {
                return false;
            }
            return (this.outside == null || this.outside == outside) && this.day.booleanValue() == time.isDay();
        }
        return this.light != false && lightLevel > 0 || this.light == false && lightLevel <= 0 && (this.outside == null || this.outside == outside);
    }

    @Override
    public int tickDelay() {
        return 10;
    }

    @Override
    public String id() {
        if (this.day != null) {
            if (this.light != null) {
                return "while_" + (this.day != false ? "day" : "night") + "_or_" + (this.light != false ? "light" : "dark") + (this.outside == null ? "" : (this.outside != false ? "_and_outside" : "_and_sheltered"));
            }
            return "while_" + (this.day != false ? "day" : "night") + (this.outside == null ? "" : (this.outside != false ? "_and_outside" : "_and_sheltered"));
        }
        if (this.light != null) {
            return "while_" + (this.light != false ? "light" : "dark") + (this.outside == null ? "" : (this.outside != false ? "_and_outside" : "_and_sheltered"));
        }
        if (this.outside != null) {
            return "while_" + (this.outside != false ? "outside" : "sheltered");
        }
        return null;
    }

    @Override
    public void onRegister() {
    }
}

