/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.potioneffects.implementations;

import java.util.function.Predicate;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.dom.MinecraftVersion;
import me.athlaeos.valhallammo.item.CustomFlag;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.potioneffects.EffectClass;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.StringUtils;
import me.athlaeos.valhallammo.version.PotionEffectMappings;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;

public class GenericWrapper
extends PotionEffectWrapper {
    private final boolean singleUse;
    private final Predicate<Double> isPositive;
    private final String defaultIcon;

    public GenericWrapper(String effect, Predicate<Double> isPositive, boolean removable, boolean singleUse, String defaultIcon, StatFormat format) {
        super(effect, removable, GenericWrapper.getOrDefault(effect).isInstant(), format);
        this.isPositive = isPositive;
        this.singleUse = singleUse;
        this.defaultIcon = defaultIcon;
    }

    public GenericWrapper(String effect, Predicate<Double> isPositive, String defaultIcon, StatFormat format) {
        super(effect, true, GenericWrapper.getOrDefault(effect).isInstant(), format);
        this.isPositive = isPositive;
        this.singleUse = false;
        this.defaultIcon = defaultIcon;
    }

    private static PotionEffectType getOrDefault(String effect) {
        PotionEffectType type = PotionEffectMappings.getPotionEffectType(effect);
        return type == null ? PotionEffectType.REGENERATION : type;
    }

    @Override
    public void onApply(ItemBuilder i) {
        boolean customFlag = CustomFlag.hasFlag(i.getMeta(), CustomFlag.DISPLAY_ATTRIBUTES);
        boolean vanillaFlag = i.getMeta().hasItemFlag(MinecraftVersion.currentVersionNewerThan(MinecraftVersion.MINECRAFT_1_20_5) ? ItemFlag.valueOf((String)"HIDE_ADDITIONAL_TOOLTIP") : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS"));
        boolean temporaryCoatingDisplay = CustomFlag.hasFlag(i.getMeta(), CustomFlag.TEMPORARY_POTION_DISPLAY);
        if (this.isVanilla && i.getMeta() instanceof PotionMeta && !customFlag || this.isVanilla && !(i.getMeta() instanceof PotionMeta) && !customFlag && (!temporaryCoatingDisplay || this.charges == 0) || !this.isVanilla && (!temporaryCoatingDisplay || this.charges == 0) && vanillaFlag && !customFlag) {
            this.onRemove(i);
        } else {
            String translation = this.getEffectName();
            if (StringUtils.isEmpty(translation)) {
                return;
            }
            String prefix = GenericWrapper.prefix(this.isPositive.test(this.amplifier));
            long duration = this.duration;
            Material base = i.getItem().getType();
            if (base == Material.LINGERING_POTION) {
                duration = (long)Math.floor((double)duration / 4.0);
            } else if (base == Material.TIPPED_ARROW) {
                duration = (long)Math.floor((double)duration / 8.0);
            }
            String charges = TranslationManager.getTranslation("potion_effect_charges_format").replace("%prefix%", prefix).replace("%charges_roman%", this.charges >= 0 ? StringUtils.toRoman(this.charges) : "").replace("%charges_numeric%", String.valueOf(this.charges));
            i.appendLore(prefix + (translation.replace("%icon%", this.getEffectIcon() + prefix).replace("%value%", this.format.format(this.amplifier + (double)(this.isVanilla ? 1 : 0))).replace("%duration%", String.format("(%s)", StringUtils.toTimeStamp(duration, 20L))) + (this.charges <= 0 ? "" : charges)).trim());
        }
    }

    @Override
    public void onInflict(LivingEntity entity, LivingEntity causedBy, double amplifier, int duration, double intensity) {
    }

    @Override
    public void onRemove(ItemBuilder i) {
        String translation = this.getEffectName();
        if (StringUtils.isEmpty(translation)) {
            return;
        }
        ItemUtils.removeIfLoreContains(i, translation.replace("%icon%", "").replace("%value%", "").replace("%duration%", "").trim());
    }

    @Override
    public void onExpire(LivingEntity entity) {
    }

    @Override
    public EffectClass getClassification(double amplifier) {
        return this.isPositive.test(amplifier) ? EffectClass.BUFF : EffectClass.DEBUFF;
    }

    @Override
    public boolean isSingleUse() {
        return this.singleUse;
    }

    @Override
    public String getEffectIcon() {
        return StringUtils.isEmpty(super.getEffectIcon()) ? (ValhallaMMO.isResourcePackConfigForced() ? "&f" + this.defaultIcon : super.getEffectIcon()) : super.getEffectIcon();
    }

    @Override
    public PotionEffectWrapper copy() {
        return new GenericWrapper(this.getEffect(), this.isPositive, this.isRemovable(), this.singleUse, this.defaultIcon, this.format).setDuration(this.duration).setAmplifier(this.amplifier).setCharges(this.charges);
    }
}

