/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.perk_rewards.implementations;

import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.format.StatFormat;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.playerstats.profiles.properties.StatProperties;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkReward;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardArgumentType;
import org.bukkit.entity.Player;

public class ProfileDoubleSet
extends PerkReward {
    private double value;
    private final String stat;
    private final Class<? extends Profile> type;

    public ProfileDoubleSet(String name, String stat, Class<? extends Profile> type) {
        super(name);
        this.stat = stat;
        this.type = type;
    }

    @Override
    public void apply(Player player) {
        Profile profile = this.isPersistent() ? ProfileRegistry.getPersistentProfile(player, this.type) : ProfileRegistry.getSkillProfile(player, this.type);
        profile.setDouble(this.stat, this.value);
        if (this.isPersistent()) {
            profile.setShouldForcePersist(true);
            ProfileRegistry.setPersistentProfile(player, profile, this.type);
        } else {
            ProfileRegistry.setSkillProfile(player, profile, this.type);
        }
        AccumulativeStatManager.uncacheProfile(player, this.type);
    }

    @Override
    public void remove(Player player) {
    }

    @Override
    public void parseArgument(Object argument) {
        this.value = this.parseDouble(argument);
    }

    @Override
    public String rewardPlaceholder() {
        StatProperties properties = ProfileRegistry.getRegisteredProfiles().get(this.type).getNumberStatProperties().get(this.stat);
        if (properties == null) {
            return StatFormat.FLOAT_P2.format(this.value);
        }
        return properties.getFormat().format(this.value);
    }

    @Override
    public PerkRewardArgumentType getRequiredType() {
        return PerkRewardArgumentType.DOUBLE;
    }
}

