/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.ModifierRegistry;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.item_misc.SkillRequirementAdd;
import me.athlaeos.valhallammo.crafting.dynamicitemmodifiers.implementations.rewards.SkillExperience;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.PerkRewardRegistry;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.SkillEXPAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.SkillLevelsAdd;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.SkillRefund;
import me.athlaeos.valhallammo.skills.perk_rewards.implementations.SkillReset;
import me.athlaeos.valhallammo.skills.skills.PerkRegistry;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.skills.skills.implementations.AlchemySkill;
import me.athlaeos.valhallammo.skills.skills.implementations.ArcherySkill;
import me.athlaeos.valhallammo.skills.skills.implementations.DiggingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.EnchantingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.FarmingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.FishingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.HeavyArmorSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.HeavyWeaponsSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.LightArmorSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.LightWeaponsSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.MiningSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.PowerSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.SmithingSkill;
import me.athlaeos.valhallammo.skills.skills.implementations.WoodcuttingSkill;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkillRegistry {
    private static Map<Class<?>, Skill> allSkills = Collections.unmodifiableMap(new HashMap());
    private static Map<String, Skill> allSkillsByType = Collections.unmodifiableMap(new HashMap());

    public static void registerSkills() {
        SkillRegistry.registerSkill(new PowerSkill("POWER"));
        SkillRegistry.registerIfConfigEnabled("alchemy", new AlchemySkill("ALCHEMY"));
        SkillRegistry.registerIfConfigEnabled("smithing", new SmithingSkill("SMITHING"));
        SkillRegistry.registerIfConfigEnabled("enchanting", new EnchantingSkill("ENCHANTING"));
        SkillRegistry.registerIfConfigEnabled("farming", new FarmingSkill("FARMING"));
        SkillRegistry.registerIfConfigEnabled("mining", new MiningSkill("MINING"));
        SkillRegistry.registerIfConfigEnabled("fishing", new FishingSkill("FISHING"));
        SkillRegistry.registerIfConfigEnabled("digging", new DiggingSkill("DIGGING"));
        SkillRegistry.registerIfConfigEnabled("woodcutting", new WoodcuttingSkill("WOODCUTTING"));
        SkillRegistry.registerIfConfigEnabled("archery", new ArcherySkill("ARCHERY"));
        SkillRegistry.registerIfConfigEnabled("armor_light", new LightArmorSkill("LIGHT_ARMOR"));
        SkillRegistry.registerIfConfigEnabled("armor_heavy", new HeavyArmorSkill("HEAVY_ARMOR"));
        SkillRegistry.registerIfConfigEnabled("weapons_light", new LightWeaponsSkill("LIGHT_WEAPONS"));
        SkillRegistry.registerIfConfigEnabled("weapons_heavy", new HeavyWeaponsSkill("HEAVY_WEAPONS"));
    }

    private static void registerIfConfigEnabled(String key, Skill skill) {
        YamlConfiguration config = ConfigManager.getConfig("config.yml").get();
        if (config.getBoolean("enabled_skills." + key, true)) {
            SkillRegistry.registerSkill(skill);
        }
    }

    public static Map<Class<?>, Skill> getAllSkills() {
        return allSkills;
    }

    public static Map<String, Skill> getAllSkillsByType() {
        return allSkillsByType;
    }

    public static <T extends Skill> Skill getSkill(Class<T> skill) {
        if (!allSkills.containsKey(skill)) {
            throw new IllegalArgumentException("Skill " + skill.getSimpleName() + " was not registered for usage");
        }
        return allSkills.get(skill);
    }

    public static Skill getSkill(String skill) {
        return allSkillsByType.get(skill);
    }

    public static void registerSkill(Skill skill) {
        HashMap skills = new HashMap(allSkills);
        skills.put(skill.getClass(), skill);
        allSkills = Collections.unmodifiableMap(skills);
        HashMap<String, Skill> skillsByType = new HashMap<String, Skill>(allSkillsByType);
        skillsByType.put(skill.getType(), skill);
        allSkillsByType = Collections.unmodifiableMap(skillsByType);
        PerkRewardRegistry.register(new SkillReset("reset_skill_" + skill.getType().toLowerCase(Locale.US), skill.getType()));
        PerkRewardRegistry.register(new SkillRefund("refund_skill_" + skill.getType().toLowerCase(Locale.US)));
        PerkRewardRegistry.register(new SkillLevelsAdd("skill_levels_add_" + skill.getType().toLowerCase(Locale.US), skill));
        PerkRewardRegistry.register(new SkillEXPAdd("skill_exp_add_" + skill.getType().toLowerCase(Locale.US), skill));
        ModifierRegistry.register(new SkillExperience("reward_" + skill.getType().toLowerCase(Locale.US) + "_experience", skill.getType()));
        ModifierRegistry.register(new SkillRequirementAdd("requirement_add_" + skill.getType().toLowerCase(Locale.US), skill.getType()));
        skill.loadConfiguration();
        skill.perks.forEach(PerkRegistry::registerPerk);
    }

    public static boolean isRegistered(Class<? extends Skill> skill) {
        return allSkills.containsKey(skill);
    }

    public static void reload() {
        PerkRegistry.clearRegistry();
        allSkills = Collections.unmodifiableMap(new HashMap());
        SkillRegistry.registerSkills();
    }

    public static void updateSkillProgression(Player p, boolean runPersistentStartingPerks) {
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskAsynchronously((Plugin)ValhallaMMO.getInstance(), () -> {
            allSkills.values().forEach(s -> ProfileRegistry.setSkillProfile(p, ProfileRegistry.getBlankProfile(p, s.getProfileType()), s.getProfileType()));
            SkillRegistry.getSkill(PowerSkill.class).updateSkillStats(p, runPersistentStartingPerks);
            allSkills.values().forEach(s -> {
                if (s instanceof PowerSkill) {
                    return;
                }
                s.updateSkillStats(p, runPersistentStartingPerks);
            });
        });
    }
}

