/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.item.ItemBuilder;
import me.athlaeos.valhallammo.listeners.BrewingStandListener;
import me.athlaeos.valhallammo.localization.TranslationManager;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.AlchemyProfile;
import me.athlaeos.valhallammo.potioneffects.PotionEffectRegistry;
import me.athlaeos.valhallammo.potioneffects.PotionEffectWrapper;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.BlockUtils;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Timer;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class AlchemySkill
extends Skill
implements Listener {
    private boolean quickEmptyPotions = true;
    private final Collection<Material> validCombiningItems = new HashSet<Material>();
    private final NamespacedKey COMBINATIONS_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "alchemy_combinations");
    private static final Map<String, Transmutation> transmutations = new HashMap<String, Transmutation>();
    private final Map<String, Transmutation> transmutationsByMaterial = new HashMap<String, Transmutation>();
    private boolean transmutationFlash = true;
    private Sound transmutationSound = null;
    private static List<String> transmutationPotionLore = new ArrayList<String>();
    private static String transmutationPotionName = null;
    private double qualityPotionExperienceMultiplier = 0.0;
    private double expMultiplierAutomated = 0.25;
    private double expMultiplierManual = 2.0;
    private static final NamespacedKey TRANSMUTATION_POTION = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "transmutation_potion");

    public AlchemySkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/alchemy_transmutations.yml");
        ValhallaMMO.getInstance().save("skills/alchemy_progression.yml");
        ValhallaMMO.getInstance().save("skills/alchemy.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/alchemy.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/alchemy_progression.yml").get();
        YamlConfiguration transmutationConfig = ConfigManager.getConfig("skills/alchemy_transmutations.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.quickEmptyPotions = skillConfig.getBoolean("quick_empty_potions");
        this.transmutationFlash = skillConfig.getBoolean("transmutation_liquid_flash");
        this.transmutationSound = Utils.getSound(skillConfig.getString("transmutation_sound"), null, "Invalid transmutation sound given in skills/alchemy.yml");
        this.validCombiningItems.addAll(ItemUtils.getMaterialSet(skillConfig.getStringList("valid_combining_items")));
        transmutationPotionLore = Utils.chat(TranslationManager.translateListPlaceholders(skillConfig.getStringList("transmutation_lore")));
        transmutationPotionName = Utils.chat(TranslationManager.translatePlaceholders(skillConfig.getString("transmutation_name")));
        this.qualityPotionExperienceMultiplier = progressionConfig.getDouble("experience.exp_multiplier_quality", 0.01);
        this.expMultiplierAutomated = progressionConfig.getDouble("experience.multiplier_automated");
        this.expMultiplierManual = progressionConfig.getDouble("experience.multiplier_manual");
        ConfigurationSection section = transmutationConfig.getConfigurationSection("transmutations");
        if (section != null) {
            for (String name : section.getKeys(false)) {
                String from = transmutationConfig.getString("transmutations." + name + ".from");
                String to = transmutationConfig.getString("transmutations." + name + ".to");
                if (from == null || to == null) continue;
                Transmutation transmutation = new Transmutation(name, from, to);
                transmutations.put(name, transmutation);
                this.transmutationsByMaterial.put(transmutation.from, transmutation);
            }
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return AlchemyProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 15;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-alchemy")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("ALCHEMY_EXP_GAIN", (Entity)p, 10000L, true);
        }
        double multiplier = reason != PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION ? 1.0 : (BrewingStandListener.isMarkedAutomatedBrewing(p) ? this.expMultiplierAutomated : this.expMultiplierManual);
        super.addEXP(p, multiplier * amount, silent, reason);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPotionCombine(InventoryClickEvent e) {
        int cursorCombinations;
        if (ValhallaMMO.isWorldBlacklisted(e.getWhoClicked().getWorld().getName()) || !e.isRightClick() || !Timer.isCooldownPassed(e.getWhoClicked().getUniqueId(), "delay_combining_attempts") || WorldGuardHook.inDisabledRegion(e.getWhoClicked().getLocation(), (Player)e.getWhoClicked(), "vmmo-skill-alchemy") || !this.hasPermissionAccess((Player)e.getWhoClicked())) {
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory) || !e.isRightClick()) {
            return;
        }
        Timer.setCooldown(e.getWhoClicked().getUniqueId(), 500, "delay_combining_attempts");
        if (ItemUtils.isEmpty(e.getCurrentItem()) || ItemUtils.isEmpty(e.getCursor())) {
            return;
        }
        if (e.getCurrentItem().getType() != e.getCursor().getType()) {
            return;
        }
        if (!this.validCombiningItems.contains(e.getCursor().getType())) {
            return;
        }
        AlchemyProfile profile = ProfileCache.getOrCache((Player)e.getWhoClicked(), AlchemyProfile.class);
        if (!profile.isPotionCombiningUnlocked()) {
            return;
        }
        ItemBuilder clicked = new ItemBuilder(e.getCurrentItem());
        ItemBuilder cursor = new ItemBuilder(e.getCursor());
        int clickedCombinations = ItemUtils.getPDCInt(this.COMBINATIONS_KEY, clicked.getMeta(), 0);
        if (clickedCombinations + (cursorCombinations = ItemUtils.getPDCInt(this.COMBINATIONS_KEY, cursor.getMeta(), 0)) + 1 > profile.getPotionCombiningMaxCombinations()) {
            return;
        }
        Map<String, PotionEffectWrapper> clickedWrappers = PotionEffectRegistry.getStoredEffects(clicked.getMeta(), false);
        Map<String, PotionEffectWrapper> cursorWrappers = PotionEffectRegistry.getStoredEffects(cursor.getMeta(), false);
        if (clickedWrappers.isEmpty() || cursorWrappers.isEmpty()) {
            return;
        }
        HashMap<String, PotionEffectWrapper> combinedEffects = new HashMap<String, PotionEffectWrapper>();
        for (PotionEffectWrapper wrapper : cursorWrappers.values()) {
            PotionEffectWrapper clickedEquivalent = clickedWrappers.get(wrapper.getEffect());
            if (clickedEquivalent != null) {
                combinedEffects.put(wrapper.getEffect(), clickedEquivalent.getAmplifier() > wrapper.getAmplifier() ? clickedEquivalent : wrapper);
                continue;
            }
            combinedEffects.put(wrapper.getEffect(), wrapper);
        }
        for (PotionEffectWrapper wrapper : clickedWrappers.values()) {
            PotionEffectWrapper cursorEquivalent = cursorWrappers.get(wrapper.getEffect());
            if (cursorEquivalent != null) {
                combinedEffects.put(wrapper.getEffect(), cursorEquivalent.getAmplifier() > wrapper.getAmplifier() ? cursorEquivalent : wrapper);
                continue;
            }
            combinedEffects.put(wrapper.getEffect(), wrapper);
        }
        if (combinedEffects.size() == clickedWrappers.size()) {
            return;
        }
        for (PotionEffectWrapper wrapper : combinedEffects.values()) {
            if (wrapper.isVanilla()) {
                wrapper.setAmplifier((1.0 + wrapper.getAmplifier()) * (double)(1.0f + profile.getPotionCombiningAmplifierMultiplier()) - 1.0);
            } else {
                wrapper.setAmplifier(wrapper.getAmplifier() * (double)(1.0f + profile.getPotionCombiningAmplifierMultiplier()));
            }
            wrapper.setDuration((int)Math.floor((float)wrapper.getDuration() * (1.0f + profile.getPotionCombiningDurationMultiplier())));
            combinedEffects.put(wrapper.getEffect(), wrapper);
        }
        PotionEffectRegistry.setDefaultStoredEffects(clicked, combinedEffects);
        PotionEffectRegistry.setActualStoredEffects(clicked, combinedEffects);
        clicked.intTag(this.COMBINATIONS_KEY, clickedCombinations + cursorCombinations + 1);
        PotionEffectRegistry.updateItemName(clicked, false, true);
        e.setCurrentItem(clicked.get());
        e.setCancelled(true);
        e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 1.0f);
        e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
        if (cursor.getItem().getAmount() == 1) {
            e.getWhoClicked().setItemOnCursor(null);
        } else {
            e.getCursor().setAmount(e.getCursor().getAmount() - 1);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCauldronInteract(PlayerInteractEvent e) {
        if (!this.quickEmptyPotions || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-alchemy")) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b != null && (b.getType() == Material.CAULDRON || b.getType().toString().equals("WATER_CAULDRON"))) {
            ItemStack hand = e.getPlayer().getInventory().getItemInMainHand();
            if (ItemUtils.isEmpty(hand) || hand.getType() != Material.POTION) {
                return;
            }
            hand = new ItemStack(Material.GLASS_BOTTLE, hand.getAmount());
            e.getPlayer().getInventory().setItemInMainHand(hand);
            e.getClickedBlock().getWorld().playSound(b.getLocation().add(0.5, 0.5, 0.5), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProjectileHitBlock(PotionSplashEvent e) {
        Player p;
        ProjectileSource projectileSource;
        if (ValhallaMMO.isWorldBlacklisted(e.getEntity().getWorld().getName()) || e.getHitBlock() == null || !((projectileSource = e.getEntity().getShooter()) instanceof Player) || WorldGuardHook.inDisabledRegion((p = (Player)projectileSource).getLocation(), p, "vmmo-skill-alchemy") || !this.hasPermissionAccess(p)) {
            return;
        }
        ItemMeta potionMeta = ItemUtils.getItemMeta(e.getPotion().getItem());
        if (!AlchemySkill.isTransmutationPotion(potionMeta)) {
            return;
        }
        AlchemyProfile profile = ProfileCache.getOrCache(p, AlchemyProfile.class);
        if (profile.getUnlockedTransmutations().isEmpty() || profile.getTransmutationRadius() <= 0) {
            return;
        }
        Collection<Block> affectedBlocks = BlockUtils.getBlocksTouching(e.getHitBlock(), profile.getTransmutationRadius(), 1, profile.getTransmutationRadius(), Material::isAir);
        for (Block b : affectedBlocks) {
            String type = BlockUtils.getBlockType(b);
            if (!this.transmutationsByMaterial.containsKey(type) || ValhallaMMO.isHookFunctional(WorldGuardHook.class) && !WorldGuardHook.canPlaceBlocks(b.getLocation(), p)) continue;
            BlockUtils.setBlockType(b, this.transmutationsByMaterial.get((Object)type).to);
        }
        if (this.transmutationFlash) {
            e.getHitBlock().getWorld().spawnParticle(Particle.FLASH, e.getEntity().getLocation(), 0);
        }
        if (this.transmutationSound != null) {
            e.getHitBlock().getWorld().playSound(e.getHitBlock().getLocation(), this.transmutationSound, 1.0f, 1.0f);
        }
    }

    public static void setTransmutationPotion(ItemMeta meta, boolean set) {
        if (set) {
            meta.getPersistentDataContainer().set(TRANSMUTATION_POTION, PersistentDataType.BYTE, (Object)1);
            meta.setLore(transmutationPotionLore);
            if (transmutationPotionName != null) {
                meta.setDisplayName(transmutationPotionName);
            }
        } else {
            meta.getPersistentDataContainer().remove(TRANSMUTATION_POTION);
        }
    }

    public static boolean isTransmutationPotion(ItemMeta meta) {
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(TRANSMUTATION_POTION, PersistentDataType.BYTE);
    }

    public static Map<String, Transmutation> getTransmutations() {
        return transmutations;
    }

    public double getQualityPotionExperienceMultiplier() {
        return this.qualityPotionExperienceMultiplier;
    }

    public record Transmutation(String key, String from, String to) {
    }
}

