/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.skills.skills.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Fetcher;
import me.athlaeos.valhallammo.dom.Weighted;
import me.athlaeos.valhallammo.event.PlayerSkillExperienceGainEvent;
import me.athlaeos.valhallammo.event.ValhallaLootPopulateEvent;
import me.athlaeos.valhallammo.event.ValhallaLootReplacementEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.listeners.LootListener;
import me.athlaeos.valhallammo.loot.LootTable;
import me.athlaeos.valhallammo.loot.LootTableRegistry;
import me.athlaeos.valhallammo.loot.ReplacementTable;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.playerstats.profiles.Profile;
import me.athlaeos.valhallammo.playerstats.profiles.ProfileCache;
import me.athlaeos.valhallammo.playerstats.profiles.implementations.FishingProfile;
import me.athlaeos.valhallammo.skills.ChunkEXPNerf;
import me.athlaeos.valhallammo.skills.skills.Skill;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FishingSkill
extends Skill
implements Listener {
    private final Map<String, Double> dropsExpValues = new HashMap<String, Double>();
    private final Collection<String> baitMaterials = new HashSet<String>();
    private boolean forgivingDropMultipliers = true;
    private boolean isChunkNerfed = true;
    private final Map<UUID, Integer> preparedBaitInfo = new HashMap<UUID, Integer>();
    private static final NamespacedKey BAIT_POWER_KEY = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "bait_power");
    private static final Collection<FishingTableEntry> fishingTables = Set.of(new FishingTableEntry(LootTables.FISHING_FISH, LootTableRegistry::getFishingFishLootTable, 1700.0, -3.0), new FishingTableEntry(LootTables.FISHING_JUNK, LootTableRegistry::getFishingJunkLootTable, 200.0, -39.0), new FishingTableEntry(LootTables.FISHING_TREASURE, LootTableRegistry::getFishingTreasureLootTable, 100.0, 42.0));

    public FishingSkill(String type) {
        super(type);
    }

    @Override
    public void loadConfiguration() {
        ValhallaMMO.getInstance().save("skills/fishing_progression.yml");
        ValhallaMMO.getInstance().save("skills/fishing.yml");
        YamlConfiguration skillConfig = ConfigManager.getConfig("skills/fishing.yml").get();
        YamlConfiguration progressionConfig = ConfigManager.getConfig("skills/fishing_progression.yml").get();
        this.loadCommonConfig(skillConfig, progressionConfig);
        this.forgivingDropMultipliers = skillConfig.getBoolean("forgiving_multipliers");
        this.baitMaterials.addAll(skillConfig.getStringList("fishing_bait_materials"));
        this.isChunkNerfed = progressionConfig.getBoolean("experience.is_chunk_nerfed", true);
        ConfigurationSection blockBreakSection = progressionConfig.getConfigurationSection("experience.fishing_catch");
        if (blockBreakSection != null) {
            for (String key : blockBreakSection.getKeys(false)) {
                double reward = progressionConfig.getDouble("experience.fishing_catch." + key);
                this.dropsExpValues.put(key, reward);
            }
        }
        ValhallaMMO.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)ValhallaMMO.getInstance());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void baitChecker(PlayerFishEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getState() != PlayerFishEvent.State.CAUGHT_FISH || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-fishing")) {
            return;
        }
        for (int i = 0; i < e.getPlayer().getInventory().getContents().length; ++i) {
            double baitPower;
            ItemStack at = e.getPlayer().getInventory().getItem(i);
            if (ItemUtils.isEmpty(at) || !at.hasItemMeta() || !this.baitMaterials.contains(at.getType().toString()) || !((baitPower = FishingSkill.getBaitPower(ItemUtils.getItemMeta(at))) > 0.0)) continue;
            LootListener.addPreparedLuck(e.getPlayer(), baitPower);
            this.preparedBaitInfo.put(e.getPlayer().getUniqueId(), i);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCatch(PlayerFishEvent e) {
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getState() != PlayerFishEvent.State.FISHING && e.getState() != PlayerFishEvent.State.CAUGHT_FISH || WorldGuardHook.inDisabledRegion(e.getPlayer().getLocation(), e.getPlayer(), "vmmo-skill-fishing")) {
            return;
        }
        FishingProfile profile = ProfileCache.getOrCache(e.getPlayer(), FishingProfile.class);
        if (e.getState() == PlayerFishEvent.State.FISHING) {
            double multiplier = 1.0 / (1.0 + Math.max(-0.999, (double)profile.getFishingSpeedBonus()));
            e.getHook().setMinWaitTime(Math.max(1, Utils.randomAverage((double)e.getHook().getMinWaitTime() * multiplier)));
            e.getHook().setMaxWaitTime(Math.max(1, Utils.randomAverage((double)e.getHook().getMaxWaitTime() * multiplier)));
        } else if (e.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            double chunkNerf;
            Item item;
            Entity at;
            int extraCatches = Utils.randomAverage(profile.getFishingDrops());
            if (!this.forgivingDropMultipliers && extraCatches < 0) {
                e.setCancelled(true);
                return;
            }
            for (int i = 0; i < extraCatches; ++i) {
                FishingSkill.simulateFishingEvent(e.getPlayer());
            }
            if (this.preparedBaitInfo.containsKey(e.getPlayer().getUniqueId()) && !Utils.proc((LivingEntity)e.getPlayer(), (double)profile.getBaitSaveChance(), false)) {
                int index = this.preparedBaitInfo.get(e.getPlayer().getUniqueId());
                at = e.getPlayer().getInventory().getItem(index);
                if (!ItemUtils.isEmpty((ItemStack)at)) {
                    if (at.getAmount() <= 1) {
                        e.getPlayer().getInventory().setItem(index, null);
                    } else {
                        at.setAmount(at.getAmount() - 1);
                    }
                }
            }
            e.setExpToDrop(Utils.randomAverage((float)(e.getExpToDrop() * (1 + extraCatches)) * (1.0f + profile.getFishingEssenceMultiplier())));
            at = e.getCaught();
            if (!(at instanceof Item) || ItemUtils.isEmpty((item = (Item)at).getItemStack())) {
                return;
            }
            double exp = this.dropsExpValues.getOrDefault(ItemUtils.getItemType(item.getItemStack()), 0.0) * (double)item.getItemStack().getAmount();
            for (ItemStack i : LootListener.getPreparedExtraDrops(e.getPlayer())) {
                if (ItemUtils.isEmpty(i)) {
                    return;
                }
                exp += this.dropsExpValues.getOrDefault(ItemUtils.getItemType(i), 0.0) * (double)i.getAmount();
            }
            double d = chunkNerf = this.isChunkNerfed ? ChunkEXPNerf.getChunkEXPNerf(e.getHook().getLocation().getChunk(), e.getPlayer(), "fishing") : 1.0;
            if (exp > 0.0) {
                this.addEXP(e.getPlayer(), exp * chunkNerf, false, PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION);
                if (this.isChunkNerfed) {
                    ChunkEXPNerf.increment(e.getHook().getLocation().getChunk(), e.getPlayer(), "fishing");
                }
            }
        }
    }

    @Override
    public boolean isLevelableSkill() {
        return true;
    }

    @Override
    public Class<? extends Profile> getProfileType() {
        return FishingProfile.class;
    }

    @Override
    public int getSkillTreeMenuOrderPriority() {
        return 50;
    }

    @Override
    public void addEXP(Player p, double amount, boolean silent, PlayerSkillExperienceGainEvent.ExperienceGainReason reason) {
        if (WorldGuardHook.inDisabledRegion(p.getLocation(), p, "vmmo-skill-fishing")) {
            return;
        }
        if (reason == PlayerSkillExperienceGainEvent.ExperienceGainReason.SKILL_ACTION) {
            amount *= 1.0 + AccumulativeStatManager.getCachedStats("FISHING_EXP_GAIN", (Entity)p, 10000L, true);
        }
        super.addEXP(p, amount, silent, reason);
    }

    public Map<String, Double> getDropsExpValues() {
        return this.dropsExpValues;
    }

    public static void setBaitPower(ItemMeta meta, Double baitPower) {
        if (baitPower == null) {
            meta.getPersistentDataContainer().remove(BAIT_POWER_KEY);
        } else {
            meta.getPersistentDataContainer().set(BAIT_POWER_KEY, PersistentDataType.DOUBLE, (Object)baitPower);
        }
    }

    public static double getBaitPower(ItemMeta meta) {
        if (meta == null) {
            return 0.0;
        }
        return (Double)meta.getPersistentDataContainer().getOrDefault(BAIT_POWER_KEY, PersistentDataType.DOUBLE, (Object)0.0);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFish(PlayerFishEvent e) {
        FishingTableEntry pickedEntry;
        Entity entity;
        if (ValhallaMMO.isWorldBlacklisted(e.getPlayer().getWorld().getName()) || e.getState() != PlayerFishEvent.State.CAUGHT_FISH || !((entity = e.getCaught()) instanceof Item)) {
            return;
        }
        Item i = (Item)entity;
        Player p = e.getPlayer();
        AttributeInstance luckAttribute = p.getAttribute(Attribute.GENERIC_LUCK);
        double luck = AccumulativeStatManager.getCachedStats("FISHING_LUCK", (Entity)p, 10000L, true) + LootListener.getPreparedLuck(p);
        if (luckAttribute != null) {
            luck += luckAttribute.getValue();
        }
        if ((pickedEntry = (FishingTableEntry)Utils.weightedSelection(fishingTables, 1, luck, 0.0).stream().findFirst().orElse(null)) == null) {
            return;
        }
        if (pickedEntry.valhallaTable.get() != null && pickedEntry.valhallaTable.get().getPools().isEmpty()) {
            return;
        }
        LootContext context = new LootContext.Builder(p.getLocation()).luck((float)luck).lootingModifier(0).killer((HumanEntity)p).lootedEntity((Entity)p).build();
        ArrayList<ItemStack> vanillaLoot = new ArrayList<ItemStack>(pickedEntry.vanillaTable.getLootTable().populateLoot(Utils.getRandom(), context));
        if (!vanillaLoot.isEmpty()) {
            i.setItemStack((ItemStack)vanillaLoot.get(0));
            vanillaLoot.remove(0);
        }
        if (pickedEntry.valhallaTable.get() != null) {
            LootTable table = pickedEntry.valhallaTable.get();
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.FISH);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean clearVanilla;
                switch (loottableEvent.getPreservationType()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLEAR: {
                        boolean bl = true;
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        boolean bl;
                        if (!loottableEvent.getDrops().isEmpty()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case KEEP: {
                        boolean bl = clearVanilla = false;
                    }
                }
                if (clearVanilla) {
                    if (loottableEvent.getDrops().isEmpty()) {
                        e.setCancelled(true);
                        return;
                    }
                    i.setItemStack(loottableEvent.getDrops().get(0));
                    loottableEvent.getDrops().remove(0);
                } else {
                    LootListener.prepareFishingDrops(p.getUniqueId(), vanillaLoot);
                }
                LootListener.prepareFishingDrops(p.getUniqueId(), loottableEvent.getDrops());
            }
        }
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(pickedEntry.vanillaTable);
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            ItemStack globalReplacement;
            ItemStack item = i.getItemStack();
            if (ItemUtils.isEmpty(item)) {
                return;
            }
            ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.FISH, item);
            if (!ItemUtils.isEmpty(replacement)) {
                item = replacement;
            }
            if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.FISH, item))) {
                item = globalReplacement;
            }
            if (!ItemUtils.isEmpty(item)) {
                i.setItemStack(item);
            }
        }
    }

    public static void simulateFishingEvent(Player p) {
        FishingTableEntry pickedEntry;
        AttributeInstance luckAttribute = p.getAttribute(Attribute.GENERIC_LUCK);
        double luck = AccumulativeStatManager.getCachedStats("FISHING_LUCK", (Entity)p, 10000L, true) + LootListener.getPreparedLuck(p);
        if (luckAttribute != null) {
            luck += luckAttribute.getValue();
        }
        if ((pickedEntry = (FishingTableEntry)Utils.weightedSelection(fishingTables, 1, luck, 0.0).stream().findFirst().orElse(null)) == null) {
            return;
        }
        LootContext context = new LootContext.Builder(p.getLocation()).luck((float)luck).lootingModifier(0).killer((HumanEntity)p).lootedEntity((Entity)p).build();
        ArrayList<ItemStack> vanillaLoot = new ArrayList<ItemStack>(pickedEntry.vanillaTable.getLootTable().populateLoot(Utils.getRandom(), context));
        if (pickedEntry.valhallaTable.get() != null) {
            LootTable table = pickedEntry.valhallaTable.get();
            List<ItemStack> loot = LootTableRegistry.getLoot(table, context, LootTable.LootType.FISH);
            ValhallaLootPopulateEvent loottableEvent = new ValhallaLootPopulateEvent(table, context, loot);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)loottableEvent);
            if (!loottableEvent.isCancelled()) {
                boolean clearVanilla;
                LootListener.prepareFishingDrops(p.getUniqueId(), loottableEvent.getDrops());
                switch (loottableEvent.getPreservationType()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CLEAR: {
                        boolean bl = true;
                        break;
                    }
                    case CLEAR_UNLESS_EMPTY: {
                        boolean bl;
                        if (!loottableEvent.getDrops().isEmpty()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case KEEP: {
                        boolean bl = clearVanilla = false;
                    }
                }
                if (!clearVanilla) {
                    FishingSkill.prepareReplacedVanillaLoot(p, vanillaLoot, pickedEntry, context);
                }
                LootListener.prepareFishingDrops(p.getUniqueId(), loottableEvent.getDrops());
            }
        } else {
            FishingSkill.prepareReplacedVanillaLoot(p, vanillaLoot, pickedEntry, context);
        }
    }

    private static void prepareReplacedVanillaLoot(Player fisherman, List<ItemStack> vanillaLoot, FishingTableEntry entry, LootContext context) {
        ReplacementTable replacementTable = LootTableRegistry.getReplacementTable(entry.vanillaTable);
        ReplacementTable globalTable = LootTableRegistry.getGlobalReplacementTable();
        ValhallaLootReplacementEvent event = new ValhallaLootReplacementEvent(replacementTable, context);
        if (replacementTable != null) {
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
        }
        if (replacementTable == null || !event.isCancelled()) {
            for (int i = 0; i < vanillaLoot.size(); ++i) {
                ItemStack globalReplacement;
                ItemStack item = vanillaLoot.get(i);
                if (ItemUtils.isEmpty(item)) continue;
                ItemStack replacement = LootTableRegistry.getReplacement(replacementTable, context, LootTable.LootType.FISH, item);
                if (!ItemUtils.isEmpty(replacement)) {
                    item = replacement;
                }
                if (!ItemUtils.isEmpty(globalReplacement = LootTableRegistry.getReplacement(globalTable, context, LootTable.LootType.FISH, item))) {
                    item = globalReplacement;
                }
                if (ItemUtils.isEmpty(item)) continue;
                vanillaLoot.set(i, item);
            }
        }
        LootListener.prepareFishingDrops(fisherman.getUniqueId(), vanillaLoot);
    }

    private record FishingTableEntry(LootTables vanillaTable, Fetcher<LootTable> valhallaTable, double baseWeight, double bonusWeightPerLuck) implements Weighted
    {
        @Override
        public double getWeight() {
            return this.baseWeight;
        }

        @Override
        public double getWeight(double luck, double fortune) {
            return Math.max(0.0, this.baseWeight + luck * this.bonusWeightPerLuck);
        }
    }
}

