/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.CombatType;
import me.athlaeos.valhallammo.event.EntityBleedEvent;
import me.athlaeos.valhallammo.hooks.WorldGuardHook;
import me.athlaeos.valhallammo.playerstats.AccumulativeStatManager;
import me.athlaeos.valhallammo.utility.EntityUtils;
import me.athlaeos.valhallammo.utility.Utils;
import org.bukkit.EntityEffect;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Bleeder {
    private static final Map<UUID, BleedingInstance> bleedingEntities = new HashMap<UUID, BleedingInstance>();
    private static int delay = ValhallaMMO.getPluginConfig().getInt("bleed_delay", 40);
    private static final int stackedDelayReduction = ValhallaMMO.getPluginConfig().getInt("bleed_stacked_delay", -5);
    private static final int maxStacks = ValhallaMMO.getPluginConfig().getInt("bleed_max_stacks", 5);

    public static void reload() {
        delay = ConfigManager.getConfig("config.yml").reload().get().getInt("bleed_delay", 40);
    }

    public static void inflictBleed(LivingEntity bleeder, Entity causedBy, CombatType combatType) {
        double bleedDamage = AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_DAMAGE", (Entity)bleeder, causedBy, 10000L, true);
        if (bleedDamage <= 0.0) {
            return;
        }
        int bleedDuration = (int)AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_DURATION", (Entity)bleeder, causedBy, 10000L, true);
        BleedingInstance instance = bleedingEntities.get(bleeder.getUniqueId());
        if (instance != null) {
            Bleeder.inflictBleed(bleeder, causedBy, bleedDuration, bleedDamage, Math.min(maxStacks, instance.stacks + 1), combatType);
        } else {
            Bleeder.inflictBleed(bleeder, causedBy, bleedDuration, bleedDamage, 1, combatType);
        }
    }

    public static void inflictBleed(LivingEntity bleeder, Entity causedBy, int duration, double damage, CombatType combatType) {
        if (damage <= 0.0) {
            return;
        }
        BleedingInstance instance = bleedingEntities.get(bleeder.getUniqueId());
        if (instance != null) {
            Bleeder.inflictBleed(bleeder, causedBy, duration, damage, Math.min(maxStacks, instance.stacks + 1), combatType);
        } else {
            Bleeder.inflictBleed(bleeder, causedBy, duration, damage, 1, combatType);
        }
    }

    public static void inflictBleed(LivingEntity bleeder, Entity causedBy, int duration, double damage, int stacks, CombatType combatType) {
        Player p;
        if (damage <= 0.0) {
            return;
        }
        if (bleeder instanceof Player && ((p = (Player)bleeder).getGameMode() == GameMode.CREATIVE || p.getGameMode() == GameMode.SPECTATOR)) {
            return;
        }
        if (bleeder instanceof Player && WorldGuardHook.inDisabledRegion((p = (Player)bleeder).getLocation(), p, "vmmo-combat-bleed")) {
            return;
        }
        if (WorldGuardHook.inDisabledRegion(bleeder.getLocation(), "vmmo-combat-bleed")) {
            return;
        }
        ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> {
            BleedingInstance instance = bleedingEntities.get(bleeder.getUniqueId());
            double resistance = AccumulativeStatManager.getCachedRelationalStats("BLEED_RESISTANCE", (Entity)bleeder, causedBy, 10000L, true);
            EntityBleedEvent event = new EntityBleedEvent(bleeder, causedBy, combatType, damage, resistance, duration, stacks);
            ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (event.getBleedResistance() >= 1.0) {
                    return;
                }
                if (instance == null) {
                    instance = new BleedingInstance(bleeder, causedBy, event.getDuration(), event.getBleedDamage() * (1.0 + event.getBleedResistance()));
                } else {
                    instance.setDuration(Math.max(event.getDuration(), instance.duration));
                    instance.setBleedingDamage(Math.max(event.getBleedDamage() * (1.0 + event.getBleedResistance()), instance.bleedingDamage));
                }
                instance.setStacks(event.getStack());
                bleeder.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("BLOCK_DUST", "BLOCK")), bleeder.getEyeLocation().add(0.0, -(bleeder.getHeight() / 2.0), 0.0), 25, 0.4, 0.4, 0.4, (Object)Material.REDSTONE_BLOCK.createBlockData());
                if (!bleedingEntities.containsKey(bleeder.getUniqueId())) {
                    bleedingEntities.put(bleeder.getUniqueId(), instance);
                    instance.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 1L, 1L);
                }
            }
        }, 1L);
    }

    public static void attemptBleed(LivingEntity bleeder, Entity causedBy, CombatType combatType) {
        AttributeInstance causedByLuck;
        double chance = AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_CHANCE", causedBy, (Entity)bleeder, 10000L, true);
        AttributeInstance bleederLuck = bleeder.getAttribute(Attribute.GENERIC_LUCK);
        if (causedBy instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)causedBy;
            v0 = l.getAttribute(Attribute.GENERIC_LUCK);
        } else {
            v0 = causedByLuck = null;
        }
        if (Utils.proc(chance, (causedByLuck == null ? 0.0 : causedByLuck.getValue()) - (bleederLuck == null ? 0.0 : bleederLuck.getValue()), false)) {
            double damage = AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_DAMAGE", causedBy, (Entity)bleeder, 10000L, true);
            int duration = (int)AccumulativeStatManager.getCachedAttackerRelationalStats("BLEED_DURATION", causedBy, (Entity)bleeder, 10000L, true);
            Bleeder.inflictBleed(bleeder, causedBy, duration, damage, combatType);
        }
    }

    public static void removeBleed(LivingEntity bleeder) {
        BleedingInstance instance = bleedingEntities.get(bleeder.getUniqueId());
        if (instance != null) {
            instance.cancel();
        }
        bleedingEntities.remove(bleeder.getUniqueId());
    }

    public static int getMaxStacks() {
        return maxStacks;
    }

    public static int getDelay() {
        return delay;
    }

    public static int getStackedDelayReduction() {
        return stackedDelayReduction;
    }

    public static Map<UUID, BleedingInstance> getBleedingEntities() {
        return bleedingEntities;
    }

    public static class BleedingInstance
    extends BukkitRunnable {
        private final LivingEntity bleedingEntity;
        private final Entity causedBy;
        private double bleedingDamage;
        private int duration;
        private final int offset;
        private int stacks = 1;

        public BleedingInstance(LivingEntity bleedingEntity, Entity causedBy, int duration, double damagePerTick) {
            this.bleedingEntity = bleedingEntity;
            this.causedBy = causedBy;
            this.duration = duration;
            this.bleedingDamage = damagePerTick;
            this.offset = duration % delay;
        }

        public double getBleedingDamage() {
            return this.bleedingDamage;
        }

        public LivingEntity getBleedingEntity() {
            return this.bleedingEntity;
        }

        public Entity getCausedBy() {
            return this.causedBy;
        }

        public void setStacks(int stacks) {
            this.stacks = stacks;
        }

        public int getStacks() {
            return this.stacks;
        }

        public void setBleedingDamage(double bleedingDamage) {
            this.bleedingDamage = bleedingDamage;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        public void run() {
            if (this.duration >= 0 && this.bleedingEntity.isValid()) {
                int tickDelay = delay + stackedDelayReduction * (this.stacks - 1);
                if ((this.duration + this.offset) % Math.max(1, tickDelay) == 0) {
                    Player p;
                    LivingEntity livingEntity = this.bleedingEntity;
                    if (livingEntity instanceof Player && ((p = (Player)livingEntity).getGameMode() == GameMode.CREATIVE || p.getGameMode() == GameMode.SPECTATOR)) {
                        this.cancel();
                        bleedingEntities.remove(p.getUniqueId());
                        return;
                    }
                    int immunityFramesBefore = this.bleedingEntity.getNoDamageTicks();
                    this.bleedingEntity.setNoDamageTicks(0);
                    if (!EntityUtils.hasActiveDamageProcess((Entity)this.bleedingEntity)) {
                        EntityUtils.damage(this.bleedingEntity, this.causedBy, this.bleedingDamage, "BLEED", true);
                    }
                    this.bleedingEntity.setNoDamageTicks(immunityFramesBefore);
                    int particleCount = (int)(3.0 * Math.min(10.0, this.bleedingDamage));
                    this.bleedingEntity.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("BLOCK_DUST", "BLOCK")), this.bleedingEntity.getEyeLocation().add(0.0, -(this.bleedingEntity.getHeight() / 2.0), 0.0), particleCount, 0.4, 0.4, 0.4, (Object)Material.REDSTONE_BLOCK.createBlockData());
                    this.bleedingEntity.playEffect(EntityEffect.HURT);
                }
                this.bleedingEntity.getWorld().spawnParticle(Particle.valueOf((String)Utils.oldOrNew("BLOCK_DUST", "BLOCK")), this.bleedingEntity.getEyeLocation().add(0.0, -(this.bleedingEntity.getHeight() / 2.0), 0.0), 1, 0.4, 0.1, 0.1, (Object)Material.REDSTONE_BLOCK.createBlockData());
                --this.duration;
            } else {
                this.cancel();
                bleedingEntities.remove(this.bleedingEntity.getUniqueId());
            }
        }
    }
}

