/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.shaded.com.jeff_media.customblockdata.CustomBlockData;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockStore {
    private static final NamespacedKey blockPlacedKey = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "block_placement_status");
    private static final Collection<Location> placedBlockCache = new HashSet<Location>();
    private static final Map<Location, BreakReason> breakReasonCache = new HashMap<Location, BreakReason>();

    public static boolean isPlaced(Block b) {
        if (placedBlockCache.contains(b.getLocation())) {
            return true;
        }
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return customBlockData.has(blockPlacedKey, PersistentDataType.INTEGER);
    }

    public static void setPlaced(Block b, boolean placed) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        if (placed) {
            customBlockData.set(blockPlacedKey, PersistentDataType.INTEGER, 1);
            placedBlockCache.add(b.getLocation());
        } else {
            customBlockData.remove(blockPlacedKey);
            placedBlockCache.remove(b.getLocation());
        }
    }

    public static BreakReason getBreakReason(Block b) {
        return breakReasonCache.getOrDefault(b.getLocation(), BreakReason.NOT_BROKEN);
    }

    public static void setBreakReason(Block b, BreakReason reason) {
        if (reason == null || reason == BreakReason.NOT_BROKEN) {
            breakReasonCache.remove(b.getLocation());
        } else {
            breakReasonCache.put(b.getLocation(), reason);
        }
    }

    public static enum BreakReason {
        EXPLOSION,
        MINED,
        NOT_BROKEN;

    }
}

