/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import me.athlaeos.valhallammo.dom.Action;
import me.athlaeos.valhallammo.dom.Catch;
import me.athlaeos.valhallammo.hooks.CEHook;
import me.athlaeos.valhallammo.hooks.IAHook;
import me.athlaeos.valhallammo.hooks.NexoHook;
import me.athlaeos.valhallammo.shaded.com.jeff_media.customblockdata.CustomBlockData;
import me.athlaeos.valhallammo.utility.BlockStore;
import me.athlaeos.valhallammo.utility.ItemUtils;
import me.athlaeos.valhallammo.utility.MathUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CaveVines;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BlockUtils {
    private static final Map<Material, Float> customBlockHardnesses = new HashMap<Material, Float>();
    private static final NamespacedKey BLOCK_OWNER;
    private static final NamespacedKey CUSTOM_HARDNESS;
    private static final int[][] offsets;
    private static final Map<String, Collection<UUID>> blockAlteringPlayers;
    private static final long PULSE_DELAY = 2L;
    private static final Collection<Material> ageableExceptions;
    private static final ItemStack stic;

    public static void setCustomHardness(Block b, float hardness) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        customBlockData.set(CUSTOM_HARDNESS, PersistentDataType.FLOAT, Float.valueOf(hardness));
    }

    public static void setDefaultHardness(Material m, Float hardness) {
        if (hardness == null) {
            customBlockHardnesses.remove(m);
        } else {
            customBlockHardnesses.put(m, hardness);
        }
    }

    public static float getHardness(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return ((Float)customBlockData.getOrDefault(CUSTOM_HARDNESS, PersistentDataType.FLOAT, customBlockHardnesses.getOrDefault(b.getType(), Float.valueOf(b.getType().getHardness())))).floatValue();
    }

    public static boolean hasCustomHardness(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return customBlockData.has(CUSTOM_HARDNESS, PersistentDataType.FLOAT);
    }

    public static void removeCustomHardness(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        customBlockData.remove(CUSTOM_HARDNESS);
    }

    public static void setOwner(Block b, UUID owner) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        customBlockData.set(BLOCK_OWNER, PersistentDataType.STRING, owner.toString());
    }

    public static boolean hasOwnership(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        return customBlockData.has(BLOCK_OWNER, PersistentDataType.STRING);
    }

    public static void removeOwnership(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        customBlockData.remove(BLOCK_OWNER);
    }

    public static Player getOwner(Block b) {
        CustomBlockData customBlockData = new CustomBlockData(b, (Plugin)ValhallaMMO.getInstance());
        String value = (String)customBlockData.get(BLOCK_OWNER, PersistentDataType.STRING);
        if (value != null) {
            return ValhallaMMO.getInstance().getServer().getPlayer(UUID.fromString(value));
        }
        return null;
    }

    public static Collection<Block> getBlocksTouching(Block start, int radiusX, int radiusY, int radiusZ, Predicate<Material> filter) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (double x = start.getLocation().getX() - (double)radiusX; x <= start.getLocation().getX() + (double)radiusX; x += 1.0) {
            for (double y = start.getLocation().getY() - (double)radiusY; y <= start.getLocation().getY() + (double)radiusY; y += 1.0) {
                for (double z = start.getLocation().getZ() - (double)radiusZ; z <= start.getLocation().getZ() + (double)radiusZ; z += 1.0) {
                    Location loc = new Location(start.getWorld(), x, y, z);
                    blocks.add(loc.getBlock());
                }
            }
        }
        if (filter == null) {
            return blocks;
        }
        return blocks.stream().filter(block -> {
            for (int[] offset : offsets) {
                Location l = block.getLocation().add((double)offset[0], (double)offset[1], (double)offset[2]);
                if (!filter.test(l.getBlock().getType())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static Collection<Block> getBlocksTouchingAnything(Block start, int radiusX, int radiusY, int radiusZ) {
        return BlockUtils.getBlocksTouching(start, radiusX, radiusY, radiusZ, m -> !m.isAir());
    }

    public static Collection<Block> getBlockVein(Block origin, int limit, Predicate<Block> filter, int[] ... offsets) {
        if (offsets.length == 0 || limit <= 0) {
            return new ArrayList<Block>();
        }
        HashSet<Block> vein = new HashSet<Block>(Set.of(origin));
        HashSet<Block> scanBlocks = new HashSet<Block>(Set.of(origin));
        BlockUtils.getSurroundingBlocks(scanBlocks, vein, limit, filter, offsets);
        return vein;
    }

    private static void getSurroundingBlocks(Collection<Block> scanBlocks, Collection<Block> currentVein, int limit, Predicate<Block> filter, int[] ... offsets) {
        HashSet<Block> newBlocksToScan = new HashSet<Block>();
        int prevSize = currentVein.size();
        if (currentVein.size() >= limit) {
            return;
        }
        for (Block b : scanBlocks) {
            for (int[] offset : offsets) {
                Block block = b.getLocation().add((double)offset[0], (double)offset[1], (double)offset[2]).getBlock();
                if (!filter.test(block) || currentVein.contains(block)) continue;
                currentVein.add(block);
                if (currentVein.size() >= limit) {
                    return;
                }
                newBlocksToScan.add(block);
            }
        }
        if (newBlocksToScan.isEmpty() || prevSize == currentVein.size()) {
            return;
        }
        BlockUtils.getSurroundingBlocks(newBlocksToScan, currentVein, limit, filter, offsets);
    }

    public static Map<String, Collection<UUID>> getBlockAlteringPlayers() {
        return blockAlteringPlayers;
    }

    public static void processBlocks(Player responsible, Collection<Block> blocks, Predicate<Player> validation, Action<Block> process, Action<Player> onFinish) {
        if (process == null || blocks.isEmpty()) {
            return;
        }
        Block lastBlock = null;
        for (Block b : blocks) {
            if (validation != null && !validation.test(responsible)) continue;
            process.act(b);
            lastBlock = b;
        }
        if (onFinish != null && lastBlock != null) {
            onFinish.act(responsible);
        }
    }

    public static void processBlocksPulse(Player responsible, Block origin, Collection<Block> blocks, Predicate<Player> validation, Action<Block> process, Action<Player> onFinish) {
        HashMap<Double, List> sortedByDistance = new HashMap<Double, List>();
        for (Block b : blocks) {
            double distance = b.getLocation().distanceSquared(origin.getLocation());
            List existingBlocks = sortedByDistance.getOrDefault(distance, new ArrayList());
            existingBlocks.add(b);
            sortedByDistance.put(distance, existingBlocks);
        }
        int highest = 0;
        for (Double distance : sortedByDistance.keySet()) {
            int time = (int)MathUtils.sqrt(distance);
            if (time > highest) {
                highest = time;
            }
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> BlockUtils.processBlocks(responsible, (Collection)sortedByDistance.get(distance), validation, process, null), (long)time * 2L);
        }
        if (onFinish != null) {
            ValhallaMMO.getInstance().getServer().getScheduler().runTaskLater((Plugin)ValhallaMMO.getInstance(), () -> onFinish.act(responsible), (long)highest * 2L + 1L);
        }
    }

    public static void processBlocksDelayed(final Player responsible, Collection<Block> blocks, final Predicate<Player> validation, final Action<Block> process, final Action<Player> onFinish) {
        final Iterator<Block> iterator = blocks.iterator();
        new BukkitRunnable(){

            public void run() {
                if (iterator.hasNext()) {
                    Block b = (Block)iterator.next();
                    if (!validation.test(responsible)) {
                        if (onFinish != null) {
                            onFinish.act(responsible);
                        }
                        this.cancel();
                    } else {
                        process.act(b);
                    }
                } else {
                    if (onFinish != null) {
                        onFinish.act(responsible);
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)ValhallaMMO.getInstance(), 0L, 1L);
    }

    public static boolean canReward(Block b) {
        Ageable a;
        block5: {
            block4: {
                BlockData data = b.getBlockData();
                if (data instanceof CaveVines) {
                    CaveVines c = (CaveVines)data;
                    return c.isBerries();
                }
                if (data instanceof Sapling || !(data instanceof Ageable)) break block4;
                a = (Ageable)data;
                if (!ageableExceptions.contains(b.getType())) break block5;
            }
            return !BlockStore.isPlaced(b);
        }
        return a.getAge() >= a.getMaximumAge();
    }

    public static boolean canReward(BlockState b) {
        Ageable a;
        block5: {
            block4: {
                BlockData data = b.getBlockData();
                if (data instanceof CaveVines) {
                    CaveVines c = (CaveVines)data;
                    return c.isBerries();
                }
                if (!(data instanceof Ageable)) break block4;
                a = (Ageable)data;
                if (!ageableExceptions.contains(b.getType())) break block5;
            }
            return !BlockStore.isPlaced(b.getBlock());
        }
        return a.getAge() >= a.getMaximumAge();
    }

    public static void decayBlock(Block block) {
        LeavesDecayEvent decayEvent = new LeavesDecayEvent(block);
        ValhallaMMO.getInstance().getServer().getPluginManager().callEvent((Event)decayEvent);
        if (decayEvent.isCancelled()) {
            return;
        }
        block.breakNaturally();
    }

    public static boolean hasDrops(Block b, Entity e, ItemStack item) {
        return !b.getDrops(item == null ? stic : item, e).isEmpty();
    }

    public static String getBlockType(Block b) {
        String custom;
        if (ValhallaMMO.isHookFunctional(NexoHook.class) && (custom = NexoHook.getNexoBlock(b)) != null) {
            return custom;
        }
        if (ValhallaMMO.isHookFunctional(CEHook.class) && (custom = CEHook.getCraftEngineBlock(b)) != null) {
            return custom;
        }
        if (ValhallaMMO.isHookFunctional(IAHook.class) && (custom = IAHook.getItemsAdderBlock(b)) != null) {
            return custom;
        }
        return b.getType().toString();
    }

    public static void setBlockType(Block b, String to) {
        if (ValhallaMMO.isHookFunctional(NexoHook.class) && NexoHook.setNexoBlock(b, to)) {
            return;
        }
        if (ValhallaMMO.isHookFunctional(CEHook.class) && CEHook.setCraftEngineBlock(b, to)) {
            return;
        }
        if (ValhallaMMO.isHookFunctional(IAHook.class) && IAHook.setItemsAdderBlock(b, to)) {
            return;
        }
        Material vanilla = Catch.catchOrElse(() -> Material.valueOf((String)to), null);
        if (vanilla == null) {
            return;
        }
        b.setType(vanilla);
    }

    static {
        YamlConfiguration config = ConfigManager.getConfig("default_block_hardnesses.yml").get();
        ConfigurationSection section = config.getConfigurationSection("");
        if (section != null) {
            for (String material : section.getKeys(false)) {
                Material block = Catch.catchOrElse(() -> Material.valueOf((String)material), null);
                if (block == null) {
                    ValhallaMMO.logWarning("Material in default_block_hardnesses.yml is invalid: " + material);
                    continue;
                }
                customBlockHardnesses.put(block, Float.valueOf((float)config.getDouble(material)));
            }
        }
        BLOCK_OWNER = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "block_owner");
        CUSTOM_HARDNESS = new NamespacedKey((Plugin)ValhallaMMO.getInstance(), "custom_hardness");
        offsets = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}};
        blockAlteringPlayers = new HashMap<String, Collection<UUID>>();
        ageableExceptions = ItemUtils.getMaterialSet(Arrays.asList("SUGAR_CANE", "BAMBOO", "CACTUS", "CHORUS_FLOWER", "KELP", "TWISTING_VINES", "WEEPING_VINES", "FROSTED_ICE", "MELON_STEM", "PUMPKIN_STEM"));
        stic = new ItemStack(Material.STICK);
    }
}

