/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.utility;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class MathEval {
    private Operator[] operators;
    private final SortedMap<String, Double> constants;
    private final SortedMap<String, Double> variables;
    private final SortedMap<String, FunctionHandler> pureFunctions;
    private final SortedMap<String, FunctionHandler> impureFunctions;
    private boolean relaxed;
    private String separators;
    private String expression;
    private int offset;
    private boolean isConstant;
    public static final int LEFT_SIDE = 76;
    public static final int RIGHT_SIDE = 82;
    public static final int NO_SIDE = 66;
    private static final Operator OPERAND = new Operator('\u0000', 0, 0, 66, false, null);

    public MathEval() {
        this.operators = new Operator[256];
        DefaultImpl.registerOperators(this);
        this.constants = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        this.variables = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        this.setConstant("E", Math.E);
        this.setConstant("Euler", 0.577215664901533);
        this.setConstant("LN2", 0.693147180559945);
        this.setConstant("LN10", 2.302585092994046);
        this.setConstant("LOG2E", 1.442695040888963);
        this.setConstant("LOG10E", 0.434294481903252);
        this.setConstant("PHI", 1.618033988749895);
        this.setConstant("PI", Math.PI);
        this.pureFunctions = new TreeMap<String, FunctionHandler>(String.CASE_INSENSITIVE_ORDER);
        this.impureFunctions = new TreeMap<String, FunctionHandler>(String.CASE_INSENSITIVE_ORDER);
        DefaultImpl.registerFunctions(this);
        this.relaxed = false;
        this.separators = null;
        this.offset = 0;
        this.isConstant = false;
    }

    public MathEval(MathEval oth) {
        this.operators = oth.operators;
        this.constants = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        this.constants.putAll(oth.constants);
        this.variables = new TreeMap<String, Double>(String.CASE_INSENSITIVE_ORDER);
        this.variables.putAll(oth.variables);
        this.pureFunctions = new TreeMap<String, FunctionHandler>(String.CASE_INSENSITIVE_ORDER);
        this.impureFunctions = new TreeMap<String, FunctionHandler>(String.CASE_INSENSITIVE_ORDER);
        this.pureFunctions.putAll(oth.pureFunctions);
        this.impureFunctions.putAll(oth.impureFunctions);
        this.relaxed = oth.relaxed;
        this.separators = oth.separators;
        this.offset = 0;
        this.isConstant = false;
    }

    public double getConstant(String nam) {
        Double val = (Double)this.constants.get(nam);
        return val == null ? 0.0 : val;
    }

    public Iterable<Map.Entry<String, Double>> getConstants() {
        return Collections.unmodifiableMap(this.constants).entrySet();
    }

    public MathEval setConstant(String nam, double val) {
        return this.setConstant(nam, (Double)val);
    }

    public MathEval setConstant(String nam, Double val) {
        if (this.constants.get(nam) != null) {
            throw new IllegalArgumentException("Constants may not be redefined");
        }
        this.validateName(nam);
        this.constants.put(nam, val);
        return this;
    }

    public MathEval setOperator(Operator opr) {
        if (opr.symbol >= this.operators.length) {
            Operator[] noa = new Operator[opr.symbol + opr.symbol % 255 + 1];
            System.arraycopy(this.operators, 0, noa, 0, this.operators.length);
            this.operators = noa;
        }
        this.operators[opr.symbol] = opr;
        return this;
    }

    public MathEval setFunctionHandler(String nam, FunctionHandler hdl) {
        return this.setFunctionHandler(nam, hdl, false);
    }

    public MathEval setFunctionHandler(String nam, FunctionHandler hdl, boolean impure) {
        this.validateName(nam);
        if (hdl == null) {
            this.pureFunctions.remove(nam);
            this.impureFunctions.remove(nam);
        } else if (impure) {
            this.pureFunctions.remove(nam);
            this.impureFunctions.put(nam, hdl);
        } else {
            this.pureFunctions.put(nam, hdl);
            this.impureFunctions.remove(nam);
        }
        return this;
    }

    public double getVariable(String nam) {
        Double val = (Double)this.variables.get(nam);
        return val == null ? 0.0 : val;
    }

    public Iterable<Map.Entry<String, Double>> getVariables() {
        return Collections.unmodifiableMap(this.variables).entrySet();
    }

    public MathEval setVariable(String nam, double val) {
        return this.setVariable(nam, (Double)val);
    }

    public MathEval setVariable(String nam, Double val) {
        this.validateName(nam);
        if (val == null) {
            this.variables.remove(nam);
        } else {
            this.variables.put(nam, val);
        }
        return this;
    }

    public MathEval clear() {
        this.variables.clear();
        return this;
    }

    public MathEval clear(String pfx) {
        this.variables.subMap(pfx + ".", pfx + ".\uffff").clear();
        return this;
    }

    public boolean getVariableRequired() {
        return this.relaxed;
    }

    public MathEval setVariableRequired(boolean val) {
        this.relaxed = !val;
        return this;
    }

    private void validateName(String nam) {
        if (!Character.isLetter(nam.charAt(0))) {
            throw new IllegalArgumentException("Names for constants, variables and functions must start with a letter");
        }
        if (nam.indexOf(40) != -1 || nam.indexOf(41) != -1) {
            throw new IllegalArgumentException("Names for constants, variables and functions may not contain a parenthesis");
        }
    }

    public double evaluate(String exp) throws NumberFormatException, ArithmeticException {
        this.expression = exp;
        this.isConstant = true;
        this.offset = 0;
        return this._evaluate(0, exp.length() - 1);
    }

    public boolean previousExpressionConstant() {
        return this.isConstant;
    }

    public Set<String> getVariablesWithin(String exp) {
        TreeSet<String> all = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String add = null;
        if (this.separators == null) {
            StringBuilder sep = new StringBuilder(10);
            for (char chr = '\u0000'; chr < this.operators.length; chr = (char)((char)(chr + 1))) {
                if (this.operators[chr] == null || this.operators[chr].internal) continue;
                sep.append(chr);
            }
            sep.append("()");
            this.separators = sep.toString();
        }
        StringTokenizer tkz = new StringTokenizer(exp, this.separators, true);
        while (tkz.hasMoreTokens()) {
            String tkn = tkz.nextToken().trim();
            if (tkn.length() != 0 && Character.isLetter(tkn.charAt(0))) {
                add = tkn;
                continue;
            }
            if (tkn.length() == 1 && tkn.charAt(0) == '(') {
                add = null;
                continue;
            }
            if (add == null || this.constants.containsKey(add)) continue;
            all.add(add);
        }
        if (add != null && !this.constants.containsKey(add)) {
            all.add(add);
        }
        return all;
    }

    private double _evaluate(int beg, int end) throws NumberFormatException, ArithmeticException {
        return this._evaluate(beg, end, 0.0, OPERAND, this.getOperator('='));
    }

    private double _evaluate(int beg, int end, double lft, Operator pnd, Operator cur) throws NumberFormatException, ArithmeticException {
        Operator nxt = OPERAND;
        int ofs = beg;
        while ((ofs = this.skipWhitespace(this.expression, ofs, end)) <= end) {
            block23: {
                double rgt;
                boolean alp;
                char ch0;
                block22: {
                    boolean fnc = false;
                    beg = ofs;
                    while (ofs <= end) {
                        char chr = this.expression.charAt(ofs);
                        nxt = this.getOperator(chr);
                        if (nxt != OPERAND) {
                            if (!nxt.internal) break;
                            nxt = OPERAND;
                        } else if (chr == ')' || chr == '|') break;
                        ++ofs;
                    }
                    ch0 = this.expression.charAt(beg);
                    alp = Character.isLetter(ch0);
                    if (cur.unary == 76) break block22;
                    if (ch0 == '+') break block23;
                    if (ch0 == '-') {
                        nxt = this.getOperator('\u00b1');
                    }
                }
                if (beg == ofs && (cur.unary == 76 || nxt.unary == 82)) {
                    rgt = Double.NaN;
                } else if (ch0 == '(') {
                    rgt = this._evaluate(beg + 1, end);
                    ofs = this.skipWhitespace(this.expression, this.offset + 1, end);
                    nxt = ofs <= end ? this.getOperator(this.expression.charAt(ofs)) : OPERAND;
                } else if (alp && nxt.symbol == '(') {
                    rgt = this.doFunction(beg, end);
                    ofs = this.skipWhitespace(this.expression, this.offset + 1, end);
                    nxt = ofs <= end ? this.getOperator(this.expression.charAt(ofs)) : OPERAND;
                } else if (alp) {
                    rgt = this.doNamedVal(beg, ofs - 1);
                } else {
                    try {
                        rgt = this.stringOfsEq(this.expression, beg, "0x") ? (double)Long.parseLong(this.expression.substring(beg + 2, ofs).trim(), 16) : Double.parseDouble(this.expression.substring(beg, ofs).trim());
                    }
                    catch (NumberFormatException thr) {
                        throw this.exception(beg, "Invalid numeric value \"" + this.expression.substring(beg, ofs).trim() + "\"");
                    }
                }
                if (this.opPrecedence(cur, 76) < this.opPrecedence(nxt, 82)) {
                    rgt = this._evaluate(ofs + 1, end, rgt, cur, nxt);
                    ofs = this.offset;
                    nxt = ofs <= end ? this.getOperator(this.expression.charAt(ofs)) : OPERAND;
                }
                lft = this.doOperation(beg, lft, cur, rgt);
                cur = nxt;
                if (this.opPrecedence(pnd, 76) >= this.opPrecedence(cur, 82)) break;
                if (cur.symbol == '(') {
                    --ofs;
                }
            }
            ++ofs;
        }
        if (ofs > end && cur != OPERAND) {
            if (cur.unary == 76) {
                lft = this.doOperation(beg, lft, cur, Double.NaN);
            } else {
                throw this.exception(ofs, "Expression ends with a blank operand after operator '" + nxt.symbol + "'");
            }
        }
        this.offset = ofs;
        return lft;
    }

    private Operator getOperator(char chr) {
        Operator opr;
        if (chr < this.operators.length && (opr = this.operators[chr]) != null) {
            return opr;
        }
        return OPERAND;
    }

    private int opPrecedence(Operator opr, int sid) {
        if (opr == null) {
            return Integer.MIN_VALUE;
        }
        if (opr.unary == 66 || opr.unary != sid) {
            return sid == 76 ? opr.precedenceL : opr.precedenceR;
        }
        return Integer.MAX_VALUE;
    }

    private double doOperation(int beg, double lft, Operator opr, double rgt) {
        if (opr.unary != 82 && Double.isNaN(lft)) {
            throw this.exception(beg, "Mathematical NaN detected in right-operand");
        }
        if (opr.unary != 76 && Double.isNaN(rgt)) {
            throw this.exception(beg, "Mathematical NaN detected in left-operand");
        }
        try {
            return opr.handler.evaluateOperator(lft, opr.symbol, rgt);
        }
        catch (ArithmeticException thr) {
            throw this.exception(beg, "Mathematical expression \"" + this.expression + "\" failed to evaluate", thr);
        }
        catch (UnsupportedOperationException thr) {
            int tmp;
            for (tmp = beg; tmp > 0 && this.getOperator(this.expression.charAt(tmp)) == null; --tmp) {
            }
            throw this.exception(tmp, "Operator \"" + opr.symbol + "\" not handled by math engine (Programmer error: The list of operators is inconsistent within the engine)");
        }
    }

    private double doFunction(int beg, int end) {
        int argbeg;
        for (argbeg = beg; argbeg <= end && this.expression.charAt(argbeg) != '('; ++argbeg) {
        }
        String fncnam = this.expression.substring(beg, argbeg).trim();
        ArgParser fncargs = new ArgParser(argbeg, end);
        try {
            FunctionHandler fnchdl = (FunctionHandler)this.pureFunctions.get(fncnam);
            if (fnchdl != null) {
                double d = fnchdl.evaluateFunction(fncnam, fncargs);
                return d;
            }
            fnchdl = (FunctionHandler)this.impureFunctions.get(fncnam);
            if (fnchdl != null) {
                this.isConstant = false;
                double d = fnchdl.evaluateFunction(fncnam, fncargs);
                return d;
            }
            fncargs = null;
        }
        catch (ArithmeticException thr) {
            fncargs = null;
            throw thr;
        }
        catch (NoSuchMethodError thr) {
            fncargs = null;
            throw this.exception(beg, "Function not supported in this JVM: \"" + fncnam + "\"");
        }
        catch (UnsupportedOperationException thr) {
            fncargs = null;
            throw this.exception(beg, thr.getMessage());
        }
        catch (Throwable thr) {
            fncargs = null;
            throw this.exception(beg, "Unexpected exception parsing function arguments", thr);
        }
        finally {
            if (fncargs != null) {
                if (fncargs.hasNext()) {
                    throw this.exception(fncargs.getIndex(), "Function has too many arguments");
                }
                this.offset = fncargs.getIndex();
            }
        }
        throw this.exception(beg, "Function \"" + fncnam + "\" not recognized");
    }

    private double doNamedVal(int beg, int end) {
        while (beg < end && Character.isWhitespace(this.expression.charAt(end))) {
            --end;
        }
        String nam = this.expression.substring(beg, end + 1);
        Double val = (Double)this.constants.get(nam);
        if (val != null) {
            return val;
        }
        val = (Double)this.variables.get(nam);
        if (val != null) {
            this.isConstant = false;
            return val;
        }
        if (this.relaxed) {
            this.isConstant = false;
            return 0.0;
        }
        throw this.exception(beg, "Unrecognized constant or variable \"" + nam + "\"");
    }

    private ArithmeticException exception(int ofs, String txt) {
        return new ArithmeticException(txt + " at offset " + ofs + " in expression \"" + this.expression + "\"");
    }

    private ArithmeticException exception(int ofs, String txt, Throwable thr) {
        return new ArithmeticException(txt + " at offset " + ofs + " in expression \"" + this.expression + "\" (Cause: " + (thr.getMessage() != null ? thr.getMessage() : thr.toString()) + ")");
    }

    private boolean stringOfsEq(String str, int ofs, String val) {
        return str.regionMatches(true, ofs, val, 0, val.length());
    }

    private int skipWhitespace(String exp, int ofs, int end) {
        while (ofs <= end && Character.isWhitespace(exp.charAt(ofs))) {
            ++ofs;
        }
        return ofs;
    }

    public static final class Operator {
        final char symbol;
        final int precedenceL;
        final int precedenceR;
        final int unary;
        final boolean internal;
        final OperatorHandler handler;

        public Operator(char sym, int prc, OperatorHandler hnd) {
            this(sym, prc, prc, 66, false, hnd);
        }

        public Operator(char sym, int prclft, int prcrgt, int unibnd, OperatorHandler hnd) {
            this(sym, prclft, prcrgt, unibnd, false, hnd);
            if (prclft < 0 || prclft > 99) {
                throw new IllegalArgumentException("Operator precendence must be 0 - 99");
            }
            if (prcrgt < 0 || prcrgt > 99) {
                throw new IllegalArgumentException("Operator precendence must be 0 - 99");
            }
            if (this.handler == null) {
                throw new IllegalArgumentException("Operator handler is required");
            }
        }

        Operator(char sym, int prclft, int prcrgt, int unibnd, boolean intern, OperatorHandler hnd) {
            this.symbol = sym;
            this.precedenceL = prclft;
            this.precedenceR = prcrgt;
            this.unary = unibnd;
            this.internal = intern;
            this.handler = hnd;
        }

        public String toString() {
            return "MathOperator['" + this.symbol + "']";
        }
    }

    static class DefaultImpl
    implements OperatorHandler,
    FunctionHandler {
        static final DefaultImpl INSTANCE = new DefaultImpl();
        private static final Operator OPR_EQU = new Operator('=', 99, 99, 82, true, INSTANCE);
        private static final Operator OPR_PWR = new Operator('^', 80, 81, 66, false, INSTANCE);
        private static final Operator OPR_NEG = new Operator('\u00b1', 60, 60, 82, true, INSTANCE);
        private static final Operator OPR_MLT1 = new Operator('*', 40, INSTANCE);
        private static final Operator OPR_MLT2 = new Operator('\u00d7', 40, INSTANCE);
        private static final Operator OPR_MLT3 = new Operator('\u00b7', 40, INSTANCE);
        private static final Operator OPR_BKT = new Operator('(', 40, INSTANCE);
        private static final Operator OPR_DIV1 = new Operator('/', 40, INSTANCE);
        private static final Operator OPR_DIV2 = new Operator('\u00f7', 40, INSTANCE);
        private static final Operator OPR_MOD = new Operator('%', 40, INSTANCE);
        private static final Operator OPR_ADD = new Operator('+', 20, INSTANCE);
        private static final Operator OPR_SUB = new Operator('-', 20, INSTANCE);

        private DefaultImpl() {
        }

        @Override
        public double evaluateOperator(double lft, char opr, double rgt) {
            return switch (opr) {
                case '=' -> rgt;
                case '^' -> Math.pow(lft, rgt);
                case '\u00b1' -> -rgt;
                case '*' -> lft * rgt;
                case '\u00d7' -> lft * rgt;
                case '(', '\u00b7' -> lft * rgt;
                case '/' -> lft / rgt;
                case '\u00f7' -> lft / rgt;
                case '%' -> lft % rgt;
                case '+' -> lft + rgt;
                case '-' -> lft - rgt;
                default -> throw new UnsupportedOperationException("MathEval internal operator setup is incorrect - internal operator \"" + opr + "\" not handled");
            };
        }

        @Override
        public double evaluateFunction(String fncnam, ArgParser fncargs) throws ArithmeticException {
            switch (Character.toLowerCase(fncnam.charAt(0))) {
                case 'a': {
                    if (fncnam.equalsIgnoreCase("abs")) {
                        return Math.abs(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("acos")) {
                        return Math.acos(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("asin")) {
                        return Math.asin(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("atan")) break;
                    return Math.atan(fncargs.next());
                }
                case 'c': {
                    if (fncnam.equalsIgnoreCase("cbrt")) {
                        return Math.cbrt(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("ceil")) {
                        return Math.ceil(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("cos")) {
                        return Math.cos(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("cosh")) break;
                    return Math.cosh(fncargs.next());
                }
                case 'e': {
                    if (fncnam.equalsIgnoreCase("exp")) {
                        return Math.exp(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("expm1")) break;
                    return Math.expm1(fncargs.next());
                }
                case 'f': {
                    if (!fncnam.equalsIgnoreCase("floor")) break;
                    return Math.floor(fncargs.next());
                }
                case 'g': {
                    if (!fncnam.equalsIgnoreCase("getExponent")) break;
                    return Math.getExponent(fncargs.next());
                }
                case 'l': {
                    if (fncnam.equalsIgnoreCase("log")) {
                        return Math.log(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("log10")) {
                        return Math.log10(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("log1p")) break;
                    return Math.log1p(fncargs.next());
                }
                case 'm': {
                    if (fncnam.equalsIgnoreCase("max")) {
                        return Math.max(fncargs.next(), fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("min")) break;
                    return Math.min(fncargs.next(), fncargs.next());
                }
                case 'n': {
                    break;
                }
                case 'r': {
                    if (fncnam.equalsIgnoreCase("random")) {
                        return Math.random();
                    }
                    if (fncnam.equalsIgnoreCase("round")) {
                        return Math.round(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("roundHE")) break;
                    return Math.rint(fncargs.next());
                }
                case 's': {
                    if (fncnam.equalsIgnoreCase("signum")) {
                        return Math.signum(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("sin")) {
                        return Math.sin(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("sinh")) {
                        return Math.sinh(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("sqrt")) break;
                    return Math.sqrt(fncargs.next());
                }
                case 't': {
                    if (fncnam.equalsIgnoreCase("tan")) {
                        return Math.tan(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("tanh")) {
                        return Math.tanh(fncargs.next());
                    }
                    if (fncnam.equalsIgnoreCase("toDegrees")) {
                        return Math.toDegrees(fncargs.next());
                    }
                    if (!fncnam.equalsIgnoreCase("toRadians")) break;
                    return Math.toRadians(fncargs.next());
                }
                case 'u': {
                    if (!fncnam.equalsIgnoreCase("ulp")) break;
                    return Math.ulp(fncargs.next());
                }
            }
            throw new UnsupportedOperationException("MathEval internal function setup is incorrect - internal function \"" + fncnam + "\" not handled");
        }

        static void registerOperators(MathEval tgt) {
            tgt.setOperator(OPR_EQU);
            tgt.setOperator(OPR_PWR);
            tgt.setOperator(OPR_NEG);
            tgt.setOperator(OPR_MLT1);
            tgt.setOperator(OPR_MLT2);
            tgt.setOperator(OPR_MLT3);
            tgt.setOperator(OPR_BKT);
            tgt.setOperator(OPR_DIV1);
            tgt.setOperator(OPR_DIV2);
            tgt.setOperator(OPR_MOD);
            tgt.setOperator(OPR_ADD);
            tgt.setOperator(OPR_SUB);
        }

        static void registerFunctions(MathEval tgt) {
            tgt.setFunctionHandler("abs", INSTANCE);
            tgt.setFunctionHandler("acos", INSTANCE);
            tgt.setFunctionHandler("asin", INSTANCE);
            tgt.setFunctionHandler("atan", INSTANCE);
            tgt.setFunctionHandler("cbrt", INSTANCE);
            tgt.setFunctionHandler("ceil", INSTANCE);
            tgt.setFunctionHandler("cos", INSTANCE);
            tgt.setFunctionHandler("cosh", INSTANCE);
            tgt.setFunctionHandler("exp", INSTANCE);
            tgt.setFunctionHandler("expm1", INSTANCE);
            tgt.setFunctionHandler("floor", INSTANCE);
            tgt.setFunctionHandler("getExponent", INSTANCE);
            tgt.setFunctionHandler("log", INSTANCE);
            tgt.setFunctionHandler("log10", INSTANCE);
            tgt.setFunctionHandler("log1p", INSTANCE);
            tgt.setFunctionHandler("max", INSTANCE);
            tgt.setFunctionHandler("min", INSTANCE);
            tgt.setFunctionHandler("nextUp", INSTANCE);
            tgt.setFunctionHandler("random", INSTANCE, true);
            tgt.setFunctionHandler("round", INSTANCE);
            tgt.setFunctionHandler("roundHE", INSTANCE);
            tgt.setFunctionHandler("signum", INSTANCE);
            tgt.setFunctionHandler("sin", INSTANCE);
            tgt.setFunctionHandler("sinh", INSTANCE);
            tgt.setFunctionHandler("sqrt", INSTANCE);
            tgt.setFunctionHandler("tan", INSTANCE);
            tgt.setFunctionHandler("tanh", INSTANCE);
            tgt.setFunctionHandler("toDegrees", INSTANCE);
            tgt.setFunctionHandler("toRadians", INSTANCE);
            tgt.setFunctionHandler("ulp", INSTANCE);
        }
    }

    public static interface FunctionHandler {
        public double evaluateFunction(String var1, ArgParser var2) throws ArithmeticException;
    }

    public static interface OperatorHandler {
        public double evaluateOperator(double var1, char var3, double var4) throws ArithmeticException;
    }

    public final class ArgParser {
        final int exEnd;
        int index;

        ArgParser(int excstr, int excend) {
            this.exEnd = excend;
            this.index = excstr + 1;
            this.index = MathEval.this.skipWhitespace(MathEval.this.expression, this.index, this.exEnd - 1);
        }

        public double next() {
            if (!this.hasNext()) {
                throw MathEval.this.exception(this.index, "Function has too few arguments");
            }
            return this._next();
        }

        public double next(double dft) {
            if (!this.hasNext()) {
                return dft;
            }
            return this._next();
        }

        private double _next() {
            if (MathEval.this.expression.charAt(this.index) == '|') {
                ++this.index;
            }
            double ret = MathEval.this._evaluate(this.index, this.exEnd);
            this.index = MathEval.this.offset;
            return ret;
        }

        public boolean hasNext() {
            return MathEval.this.expression.charAt(this.index) != ')';
        }

        int getIndex() {
            return this.index;
        }
    }
}

