/*
 * Decompiled with CFR 0.152.
 */
package me.athlaeos.valhallammo.version.conversion_dto;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import me.athlaeos.valhallammo.ValhallaMMO;
import me.athlaeos.valhallammo.configuration.ConfigManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DatabaseConnection {
    private static DatabaseConnection databaseConnection = null;
    private Connection conn = this.initializeConnection();
    private String database = "";

    public static DatabaseConnection getDatabaseConnection() {
        if (databaseConnection == null) {
            databaseConnection = new DatabaseConnection();
        }
        return databaseConnection;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection initializeConnection() {
        YamlConfiguration config = ConfigManager.getConfig("config.yml").get();
        String host = config.getString("db_host");
        this.database = config.getString("db_database");
        String username = config.getString("db_username");
        String password = config.getString("db_password");
        int port = config.getInt("db_port");
        int ping_delay = config.getInt("db_ping_delay");
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                return this.conn;
            }
            ValhallaMMO valhallaMMO = ValhallaMMO.getInstance();
            synchronized (valhallaMMO) {
                if (this.conn != null && !this.conn.isClosed()) {
                    return this.conn;
                }
                Class.forName("com.mysql.jdbc.Driver");
                this.conn = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + this.database, username, password);
                ValhallaMMO.logInfo("Database connection created!");
            }
        }
        catch (Exception e) {
            ValhallaMMO.logWarning("Database connection failed, using PersistentDataContainer for profile persistence");
            return null;
        }
        if (this.conn != null) {
            new BukkitRunnable(){

                public void run() {
                    try {
                        DatabaseConnection.this.conn.prepareStatement("/* ping */ SELECT 1;").execute();
                    }
                    catch (SQLException ex) {
                        ValhallaMMO.logWarning("Database ping failed");
                        this.cancel();
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)ValhallaMMO.getInstance(), (long)ping_delay, (long)ping_delay);
        }
        return this.conn;
    }

    public void addColumnIfNotExists(String tableName, String columnName, String columnType) {
        try {
            PreparedStatement procedureCreationStatement = this.conn.prepareStatement("SELECT " + columnName + " FROM " + tableName + ";");
            procedureCreationStatement.execute();
        }
        catch (SQLException e) {
            try {
                PreparedStatement procedureCreationStatement = this.conn.prepareStatement("ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " " + columnType + ";");
                procedureCreationStatement.execute();
            }
            catch (SQLException ex) {
                ValhallaMMO.logSevere("SQLException when trying to add column " + columnName + " " + columnType + " to " + tableName + ". ");
                e.printStackTrace();
            }
        }
    }
}

