/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.couplings;

import com.ryankshah.couplings.Lazy;
import com.ryankshah.couplings.Signal;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Signal<Lazy<?>> RELOAD;

    public static void onReload() {
        RELOAD.run();
    }

    public static boolean serverCouplesDoors() {
        return (Boolean)ConfigHandler.COMMON.serverCouplesDoors.get();
    }

    public static boolean serverCouplesFenceGates() {
        return (Boolean)ConfigHandler.COMMON.serverCouplesFenceGates.get();
    }

    public static boolean serverCouplesTrapdoors() {
        return (Boolean)ConfigHandler.COMMON.serverCouplesTrapdoors.get();
    }

    public static boolean ignoreSneaking() {
        return (Boolean)ConfigHandler.CLIENT.ignoreSneaking.get();
    }

    public static boolean coupleDoors() {
        return (Boolean)ConfigHandler.CLIENT.coupleDoors.get();
    }

    public static boolean coupleFenceGates() {
        return (Boolean)ConfigHandler.CLIENT.coupleFenceGates.get();
    }

    public static boolean coupleTrapdoors() {
        return (Boolean)ConfigHandler.CLIENT.coupleTrapdoors.get();
    }

    static {
        RELOAD = new Signal<Lazy>(Lazy::reset);
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue serverCouplesDoors;
        public final ModConfigSpec.BooleanValue serverCouplesFenceGates;
        public final ModConfigSpec.BooleanValue serverCouplesTrapdoors;

        public Common(ModConfigSpec.Builder builder) {
            builder.push("couplings");
            this.serverCouplesDoors = builder.comment("Server Couples Doors").define("serverCouplesDoors", true);
            this.serverCouplesFenceGates = builder.comment("Server Couples Fence Gates").define("serverCouplesFenceGates", true);
            this.serverCouplesTrapdoors = builder.comment("Server Couples Trapdoors").define("serverCouplesTrapdoors", true);
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue ignoreSneaking;
        public final ModConfigSpec.BooleanValue coupleDoors;
        public final ModConfigSpec.BooleanValue coupleFenceGates;
        public final ModConfigSpec.BooleanValue coupleTrapdoors;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("couplings");
            this.ignoreSneaking = builder.comment("Ignore Sneaking").define("ignoreSneaking", false);
            this.coupleDoors = builder.comment("Couple Doors").define("coupleDoors", true);
            this.coupleFenceGates = builder.comment("Couple Fence Gates").define("coupleFenceGates", true);
            this.coupleTrapdoors = builder.comment("Couple Trapdoors").define("coupleTrapdoors", true);
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }
}

