/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.couplings.impl;

import com.ryankshah.couplings.CouplingsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public final class DoorBlockCoupling {
    private DoorBlockCoupling() {
    }

    public static void used(BlockState state, Level level, BlockPos pos, Player player) {
        BlockPos offset;
        if (CouplingsCommon.couplesDoors(level) && (!player.isCrouching() || CouplingsCommon.ignoresSneaking(player)) && level.mayInteract(player, offset = DoorBlockCoupling.getCoupledDoorPos(state, pos))) {
            Boolean open;
            BlockState other = level.getBlockState(offset);
            if (state.getBlock() == other.getBlock() && DoorBlockCoupling.areCoupled(state, other, open = (Boolean)state.getValue((Property)DoorBlock.OPEN))) {
                level.setBlock(offset, (BlockState)other.setValue((Property)DoorBlock.OPEN, (Comparable)open), 2);
                level.gameEvent((Entity)player, (Holder)(open != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), offset);
            }
        }
    }

    public static void openStateChanged(Entity entity, BlockState state, Level level, BlockPos pos, boolean open) {
        if (CouplingsCommon.couplesDoors(level)) {
            BlockPos offset = DoorBlockCoupling.getCoupledDoorPos(state, pos);
            BlockState other = level.getBlockState(offset);
            if (state.getBlock() == other.getBlock() && DoorBlockCoupling.areCoupled(state, other, open)) {
                level.setBlock(offset, (BlockState)other.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(open)), 10);
                level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), offset);
            }
        }
    }

    public static void neighborChanged(BlockState state, Level level, BlockPos pos, boolean powered) {
        if (CouplingsCommon.couplesDoors(level) && (!powered || level.getBestNeighborSignal(pos) >= 8)) {
            BlockPos offset = DoorBlockCoupling.getCoupledDoorPos(state, pos);
            BlockState other = level.getBlockState(offset);
            if (state.getBlock() == other.getBlock() && DoorBlockCoupling.areCoupled(state, other, powered)) {
                level.setBlock(offset, (BlockState)other.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(powered)), 2);
                level.gameEvent(null, (Holder)(powered ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), offset);
            }
        }
    }

    private static boolean areCoupled(BlockState self, BlockState other, boolean open) {
        return open != (Boolean)other.getValue((Property)DoorBlock.OPEN) && self.getValue((Property)DoorBlock.FACING) == other.getValue((Property)DoorBlock.FACING) && self.getValue((Property)DoorBlock.HALF) == other.getValue((Property)DoorBlock.HALF) && self.getValue((Property)DoorBlock.HINGE) != other.getValue((Property)DoorBlock.HINGE);
    }

    private static BlockPos getCoupledDoorPos(BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)DoorBlock.FACING);
        boolean leftHinge = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.LEFT;
        return pos.relative(leftHinge ? facing.getClockWise() : facing.getCounterClockWise());
    }
}

