/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.couplings.impl;

import com.ryankshah.couplings.CouplingsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public final class FenceGateBlockCoupling {
    private FenceGateBlockCoupling() {
    }

    public static void used(BlockState state, Level level, BlockPos pos, Player player) {
        if (CouplingsCommon.couplesFenceGates(level) && (!player.isCrouching() || CouplingsCommon.ignoresSneaking(player))) {
            FenceGateBlockCoupling.tryOpenCloseEach(state, level, pos, player, (Boolean)state.getValue((Property)FenceGateBlock.OPEN));
        }
    }

    public static void neighborChanged(BlockState state, Level level, BlockPos pos, boolean powered) {
        if (CouplingsCommon.couplesFenceGates(level) && (!powered || level.getBestNeighborSignal(pos) >= 8)) {
            FenceGateBlockCoupling.tryOpenCloseEach(state, level, pos, null, powered);
        }
    }

    public static void tryOpenCloseEach(BlockState state, Level level, BlockPos pos, @Nullable Player player, boolean open) {
        Direction.Axis axis = ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis();
        int distance = 64;
        boolean continueUp = true;
        boolean continueDown = true;
        for (int offset = 1; offset <= 64 && (continueUp || continueDown); ++offset) {
            if (continueUp) {
                BlockPos above = pos.above(offset);
                boolean bl = continueUp = (player == null || level.mayInteract(player, above)) && FenceGateBlockCoupling.tryOpenClose(state, level, above, player, axis, open);
            }
            if (!continueDown) continue;
            BlockPos below = pos.below(offset);
            continueDown = (player == null || level.mayInteract(player, below)) && FenceGateBlockCoupling.tryOpenClose(state, level, below, player, axis, open);
        }
    }

    private static boolean tryOpenClose(BlockState state, Level level, BlockPos offset, @Nullable Player player, Direction.Axis axis, boolean open) {
        BlockState other = level.getBlockState(offset);
        boolean sameBlock = state.getBlock() == other.getBlock();
        boolean differentOpenState = false;
        boolean sameAxis = false;
        if (sameBlock && other.hasProperty((Property)FenceGateBlock.OPEN)) {
            boolean bl = differentOpenState = open != (Boolean)other.getValue((Property)FenceGateBlock.OPEN);
            if (other.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                boolean bl2 = sameAxis = axis == ((Direction)other.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis();
            }
        }
        if (sameBlock && differentOpenState && sameAxis) {
            BlockState newOther = (BlockState)other.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(open));
            if (player != null) {
                Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
                level.setBlock(offset, (BlockState)newOther.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing), 2);
            } else {
                level.setBlock(offset, newOther, 2);
            }
            level.gameEvent((Entity)player, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), offset);
            return true;
        }
        return false;
    }
}

