/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.couplings.impl;

import com.ryankshah.couplings.CouplingsCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class TrapdoorBlockCoupling {
    private TrapdoorBlockCoupling() {
    }

    public static void used(BlockState state, Level level, BlockPos pos, Player player) {
        if (CouplingsCommon.couplesTrapdoors(level) && (!player.isCrouching() || CouplingsCommon.ignoresSneaking(player))) {
            TrapdoorBlockCoupling.tryOpenCloseEach(state, level, pos, player, (Boolean)state.getValue((Property)TrapDoorBlock.OPEN));
        }
    }

    public static void neighborChanged(BlockState state, Level level, BlockPos pos, boolean powered) {
        if (CouplingsCommon.couplesTrapdoors(level) && (!powered || level.getBestNeighborSignal(pos) >= 8)) {
            TrapdoorBlockCoupling.tryOpenCloseEach(state, level, pos, null, powered);
        }
    }

    private static void tryOpenCloseEach(BlockState state, Level level, BlockPos pos, @Nullable Player player, boolean open) {
        Half half = (Half)state.getValue((Property)TrapDoorBlock.HALF);
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        boolean traverseZ = facing.getAxis() == Direction.Axis.X;
        int offset = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1 : -1;
        int distance = 64;
        boolean continuePos = true;
        boolean continueNeg = true;
        for (int step = 0; step <= 64 && (continuePos || continueNeg); ++step) {
            BlockPos relative;
            if (continuePos) {
                relative = pos;
                if (step != 0) {
                    relative = pos.offset(traverseZ ? 0 : step, 0, traverseZ ? step : 0);
                    boolean bl = continuePos = (player == null || level.mayInteract(player, relative)) && TrapdoorBlockCoupling.tryOpenClose(state, relative, level, player, facing, half, open);
                }
                if (continuePos) {
                    TrapdoorBlockCoupling.tryOpenCloseAt(state, level, player, open, half, facing, traverseZ, offset, relative);
                }
            }
            if (!continueNeg || step == 0) continue;
            relative = pos.offset(traverseZ ? 0 : -step, 0, traverseZ ? -step : 0);
            boolean bl = continueNeg = (player == null || level.mayInteract(player, relative)) && TrapdoorBlockCoupling.tryOpenClose(state, relative, level, player, facing, half, open);
            if (!continueNeg) continue;
            TrapdoorBlockCoupling.tryOpenCloseAt(state, level, player, open, half, facing, traverseZ, offset, relative);
        }
    }

    private static void tryOpenCloseAt(BlockState state, Level level, @Nullable Player player, boolean open, Half half, Direction facing, boolean traverseZ, int offset, BlockPos pos) {
        BlockPos relative = pos.offset(traverseZ ? offset : 0, 0, traverseZ ? 0 : offset);
        if (player == null || level.mayInteract(player, relative)) {
            TrapdoorBlockCoupling.tryOpenClose(state, relative, level, player, facing.getOpposite(), half, open);
        }
    }

    private static boolean tryOpenClose(BlockState state, BlockPos pos, Level level, @Nullable Player player, Direction facing, Half half, boolean open) {
        BlockState other = level.getBlockState(pos);
        if (state.getBlock() == other.getBlock() && facing == other.getValue((Property)HorizontalDirectionalBlock.FACING) && half == other.getValue((Property)TrapDoorBlock.HALF) && open != (Boolean)other.getValue((Property)TrapDoorBlock.OPEN)) {
            level.setBlock(pos, (BlockState)other.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(open)), 2);
            if (((Boolean)other.getValue((Property)TrapDoorBlock.WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            level.gameEvent((Entity)player, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            return true;
        }
        return false;
    }
}

