/*
 * Decompiled with CFR 0.152.
 */
package com.ryankshah.couplings.mixin;

import com.ryankshah.couplings.impl.DoorBlockCoupling;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={DoorBlock.class})
abstract class DoorBlockMixin
extends Block {
    DoorBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"useWithoutItem(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")}, require=1, allow=1)
    private void usedWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        DoorBlockCoupling.used(state, level, pos, player);
    }

    @Inject(method={"setOpen(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/level/block/DoorBlock;playSound(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Z)V")}, require=1, allow=1)
    private void openStateChanged(Entity entity, Level level, BlockState state, BlockPos pos, boolean open, CallbackInfo ci) {
        DoorBlockCoupling.openStateChanged(entity, state, level, pos, open);
    }

    @Inject(method={"neighborChanged(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")}, require=1, allow=1, locals=LocalCapture.CAPTURE_FAILHARD)
    private void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos offset, boolean moved, CallbackInfo ci, boolean powered) {
        DoorBlockCoupling.neighborChanged(state, level, pos, powered);
    }
}

