/*
 * Decompiled with CFR 0.152.
 */
package net.gsimken.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.gsimken.TicketOfEternalKeep;
import net.gsimken.config.ModConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_7923;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get(FabricLoader.getInstance().getGameDir().toFile().getPath() + "/config/ToEK.json", new String[0]);
    private ModConfig config;

    public void loadConfig() {
        try {
            this.createConfigDirectoryIfNeeded();
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                this.saveDefaultConfig();
            }
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                this.config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (this.config.getLootTableProbabilities() == null) {
                    HashMap<String, Float> defaultProbabilities = new HashMap<String, Float>();
                    defaultProbabilities.put(class_39.field_38438.method_29177().toString(), Float.valueOf(0.1f));
                    defaultProbabilities.put(class_39.field_472.method_29177().toString(), Float.valueOf(0.03f));
                    defaultProbabilities.put(class_39.field_683.method_29177().toString(), Float.valueOf(0.05f));
                    defaultProbabilities.put(class_39.field_842.method_29177().toString(), Float.valueOf(0.05f));
                    defaultProbabilities.put(class_39.field_800.method_29177().toString(), Float.valueOf(0.05f));
                    defaultProbabilities.put(class_39.field_274.method_29177().toString(), Float.valueOf(0.05f));
                    defaultProbabilities.put(class_39.field_24048.method_29177().toString(), Float.valueOf(0.15f));
                    defaultProbabilities.put(class_39.field_24049.method_29177().toString(), Float.valueOf(0.15f));
                    defaultProbabilities.put(class_39.field_24047.method_29177().toString(), Float.valueOf(0.15f));
                    defaultProbabilities.put(class_39.field_24046.method_29177().toString(), Float.valueOf(0.15f));
                    defaultProbabilities.put(class_39.field_615.method_29177().toString(), Float.valueOf(0.05f));
                    this.config.setLootTableProbabilities(defaultProbabilities);
                }
                if (this.config.getGenericChestProbability() == null) {
                    this.config.setGenericChestProbability(Float.valueOf(0.005f));
                }
                this.config.setName(this.replaceFormatSymbols(this.config.getName()));
                List<String> updatedLore = this.config.getLore().stream().map(this::replaceFormatSymbols).collect(Collectors.toList());
                this.config.setLore(updatedLore);
                try {
                    class_2960 itemId = class_2960.method_60654((String)this.config.getItem());
                    TicketOfEternalKeep.ticketItem = (class_1792)class_7923.field_41178.method_63535(itemId);
                }
                catch (Error e) {
                    TicketOfEternalKeep.ticketItem = class_1802.field_8407;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultConfig() {
        try {
            this.createConfigDirectoryIfNeeded();
            this.config = new ModConfig();
            this.config.setItem("minecraft:paper");
            this.config.setName("&6Ticket of Eternal Keeping");
            this.config.setLore(List.of("&bThis ticket allows whoever carries it", "&bin the inventory to keep their items when they die.", "", "&4&lIt is consumed at death"));
            this.config.setCustomModelDataNumber(506);
            HashMap<String, Float> defaultProbabilities = new HashMap<String, Float>();
            defaultProbabilities.put(class_39.field_38438.method_29177().toString(), Float.valueOf(0.1f));
            defaultProbabilities.put(class_39.field_472.method_29177().toString(), Float.valueOf(0.03f));
            defaultProbabilities.put(class_39.field_683.method_29177().toString(), Float.valueOf(0.05f));
            defaultProbabilities.put(class_39.field_842.method_29177().toString(), Float.valueOf(0.05f));
            defaultProbabilities.put(class_39.field_800.method_29177().toString(), Float.valueOf(0.05f));
            defaultProbabilities.put(class_39.field_274.method_29177().toString(), Float.valueOf(0.05f));
            defaultProbabilities.put(class_39.field_24048.method_29177().toString(), Float.valueOf(0.15f));
            defaultProbabilities.put(class_39.field_24049.method_29177().toString(), Float.valueOf(0.15f));
            defaultProbabilities.put(class_39.field_24047.method_29177().toString(), Float.valueOf(0.15f));
            defaultProbabilities.put(class_39.field_24046.method_29177().toString(), Float.valueOf(0.15f));
            defaultProbabilities.put(class_39.field_615.method_29177().toString(), Float.valueOf(0.05f));
            this.config.setLootTableProbabilities(defaultProbabilities);
            this.config.setGenericChestProbability(Float.valueOf(0.005f));
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)this.config, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ModConfig getConfig() {
        return this.config;
    }

    private String replaceFormatSymbols(String text) {
        return text.replace("&", "\u00a7");
    }

    private void createConfigDirectoryIfNeeded() throws IOException {
        Path configDir = CONFIG_PATH.getParent();
        if (!Files.exists(configDir, new LinkOption[0])) {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
    }
}

