/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block;

import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.block.custom.BlockBreakerBlock;
import com.benbenlaw.utility.block.custom.BlockPlacerBlock;
import com.benbenlaw.utility.block.custom.DryingTableBlock;
import com.benbenlaw.utility.block.custom.EnderOreBlock;
import com.benbenlaw.utility.block.custom.FluidCollectorBlock;
import com.benbenlaw.utility.block.custom.FluidGeneratorBlock;
import com.benbenlaw.utility.block.custom.FluidPlacerBlock;
import com.benbenlaw.utility.block.custom.ItemRepairerBlock;
import com.benbenlaw.utility.block.custom.RedstoneClockBlock;
import com.benbenlaw.utility.block.custom.ResourceGeneratorBlock;
import com.benbenlaw.utility.item.UtilityItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class UtilityBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"utility");
    public static final DeferredBlock<Block> ENDER_ORE = UtilityBlocks.registerBlock("ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE).lightLevel(UtilityBlocks.litBlockEmission()).setId(UtilityBlocks.createID("ender_ore"))));
    public static final DeferredBlock<Block> DEEPSLATE_ENDER_ORE = UtilityBlocks.registerBlock("deepslate_ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_REDSTONE_ORE).lightLevel(UtilityBlocks.litBlockEmission()).setId(UtilityBlocks.createID("deepslate_ender_ore"))));
    public static final DeferredBlock<Block> DRYING_TABLE = UtilityBlocks.registerBlock("drying_table", () -> new DryingTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().setId(UtilityBlocks.createID("drying_table"))));
    public static final DeferredBlock<Block> BLOCK_PLACER = UtilityBlocks.registerBlock("block_placer", () -> new BlockPlacerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("block_placer"))));
    public static final DeferredBlock<Block> BLOCK_BREAKER = UtilityBlocks.registerBlock("block_breaker", () -> new BlockBreakerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("block_breaker"))));
    public static final DeferredBlock<Block> RESOURCE_GENERATOR = UtilityBlocks.registerBlock("resource_generator", () -> new ResourceGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("resource_generator"))));
    public static final DeferredBlock<Block> FLUID_PLACER = UtilityBlocks.registerBlock("fluid_placer", () -> new FluidPlacerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("fluid_placer"))));
    public static final DeferredBlock<Block> FLUID_COLLECTOR = UtilityBlocks.registerBlock("fluid_collector", () -> new FluidCollectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("fluid_collector"))));
    public static final DeferredBlock<Block> ITEM_REPAIRER = UtilityBlocks.registerBlock("item_repairer", () -> new ItemRepairerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("item_repairer"))));
    public static final DeferredBlock<Block> FLUID_GENERATOR = UtilityBlocks.registerBlock("fluid_generator", () -> new FluidGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("fluid_generator"))));
    public static final DeferredBlock<Block> REDSTONE_CLOCK = UtilityBlocks.registerBlock("redstone_clock", () -> new RedstoneClockBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().setId(UtilityBlocks.createID("redstone_clock"))));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        UtilityBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        UtilityItems.ITEMS.registerItem(name, properties -> new BlockItem((Block)block.get(), properties.useBlockDescriptionPrefix()));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return lightLevel -> (Boolean)lightLevel.getValue((Property)BlockStateProperties.LIT) != false ? 9 : 0;
    }

    public static ResourceKey<Block> createID(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Utility.rl(name));
    }
}

