/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.WhitelistBlockEntity;
import com.benbenlaw.core.block.entity.handler.item.FilterItemHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.util.FakePlayerUtil;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.BlockBreakerBlock;
import com.benbenlaw.utility.screen.breaker.BlockBreakerMenu;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakerBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
WhitelistBlockEntity {
    private final ContainerData data;
    private float maxProgress = 1.0f;
    private float progress = 0.0f;
    private FakePlayer fakePlayer;
    private final InputItemHandler inputHandler = new InputItemHandler((SyncableBlockEntity)this, 1, (i, stack) -> i == 0);
    private boolean whitelist = true;
    private final FilterItemHandler filterHandler = new FilterItemHandler((SyncableBlockEntity)this, 8);
    public static final int INPUT_SLOT = 0;

    public BlockBreakerBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.BLOCK_BREAKER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> (int)(BlockBreakerBlockEntity.this.progress * 1000.0f);
                    case 1 -> (int)(BlockBreakerBlockEntity.this.maxProgress * 1000.0f);
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BlockBreakerBlockEntity.this.progress = (float)value / 1000.0f;
                        break;
                    }
                    case 1: {
                        BlockBreakerBlockEntity.this.maxProgress = (float)value / 1000.0f;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            float blockHardness;
            if (this.fakePlayer == null) {
                this.fakePlayer = FakePlayerUtil.createFakePlayer((ServerLevel)((ServerLevel)this.level), (String)"Block_Breaker");
            }
            ItemStack tool = ((ItemResource)this.inputHandler.getResource(0)).toStack();
            this.fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, tool);
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockBreakerBlock.RUNNING)).booleanValue()) {
                return;
            }
            BlockPos targetPos = this.worldPosition.relative((Direction)this.level.getBlockState(this.worldPosition).getValue((Property)BlockBreakerBlock.FACING));
            BlockState targetBlockState = this.level.getBlockState(targetPos);
            BlockEntity targetBlockEntity = this.level.getBlockEntity(targetPos);
            if (targetBlockState.isAir() || !this.filterHandler.matchesBlockState(targetBlockState, this.whitelist)) {
                this.progress = 0.0f;
                return;
            }
            boolean canHarvest = tool.isCorrectToolForDrops(targetBlockState) || !targetBlockState.requiresCorrectToolForDrops();
            float toolSpeed = tool.getDestroySpeed(targetBlockState);
            Registry registry = Objects.requireNonNull(this.level.getServer()).registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            int efficiencyLevel = tool.getEnchantmentLevel((Holder)registry.getOrThrow(Enchantments.EFFICIENCY));
            if (efficiencyLevel > 0) {
                toolSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
            if ((blockHardness = targetBlockState.getDestroySpeed((BlockGetter)this.level, targetPos)) < 0.0f) {
                return;
            }
            float progressPerTick = toolSpeed / blockHardness / 30.0f;
            this.sendBlockBreakingPacket(this.getPersistentData().getId(), targetPos, progressPerTick);
            if (canHarvest) {
                this.progress += progressPerTick;
                if (this.progress >= 1.0f) {
                    Block.dropResources((BlockState)targetBlockState, (Level)this.level, (BlockPos)targetPos, (BlockEntity)targetBlockEntity, (Entity)this.fakePlayer, (ItemStack)tool);
                    this.level.destroyBlock(targetPos, false, (Entity)this.fakePlayer);
                    if (tool.isDamageableItem()) {
                        int oldDamage = tool.getDamageValue();
                        tool.setDamageValue(oldDamage + 1);
                        this.inputHandler.set(0, (Resource)ItemResource.of((ItemStack)tool), 1);
                        if (tool.getDamageValue() >= tool.getMaxDamage()) {
                            try (Transaction tx = Transaction.open(null);){
                                this.inputHandler.extractInternal(0, (ItemResource)this.inputHandler.getResource(0), 1, (TransactionContext)tx);
                                tx.commit();
                            }
                            this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    this.clearBlockBreakingProgress(this.getPersistentData().getId(), targetPos, progressPerTick);
                    this.progress = 0.0f;
                }
            } else {
                this.clearBlockBreakingProgress(this.getPersistentData().getId(), targetPos, progressPerTick);
                this.progress = 0.0f;
            }
        }
    }

    public InputItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public FilterItemHandler getFilterHandler() {
        return this.filterHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return this.inputHandler;
    }

    public void sendBlockBreakingPacket(int breakerId, BlockPos targetPos, float progressPerTick) {
        int currentCrackStage;
        assert (this.level != null);
        int newCrackStage = Math.min(9, (int)((this.progress + progressPerTick) * 10.0f));
        if (newCrackStage != (currentCrackStage = Math.min(9, (int)(this.progress * 10.0f))) || newCrackStage == 0) {
            ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(breakerId, targetPos, newCrackStage);
            for (ServerPlayer player : ((ServerLevel)this.level).getPlayers(p -> p.distanceToSqr((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()) < 1024.0)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    public void clearBlockBreakingProgress(int breakerId, BlockPos targetPos, float progressPerTick) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockDestructionPacket packet = new ClientboundBlockDestructionPacket(breakerId, targetPos, -1);
            for (ServerPlayer player : serverLevel.getPlayers(p -> p.distanceToSqr((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()) < 1024.0)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new BlockBreakerMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.block_breaker");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        this.filterHandler.serialize(output.child("filter"));
        output.putFloat("maxProgress", this.maxProgress);
        output.putFloat("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.filterHandler.deserialize(input.childOrEmpty("filter"));
        this.maxProgress = input.getFloatOr("maxProgress", 1.0f);
        this.progress = input.getFloatOr("progress", 0.0f);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
        this.setChanged();
        this.sync();
    }
}

