/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.BlockPlacerBlock;
import com.benbenlaw.utility.screen.placer.BlockPlacerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = 20;
    private int progress = 0;
    private final InputItemHandler inputHandler = new InputItemHandler((SyncableBlockEntity)this, 1, (i, stack) -> i == 0);
    public static final int INPUT_SLOT = 0;

    public BlockPlacerBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.BLOCK_PLACER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> BlockPlacerBlockEntity.this.progress;
                    case 1 -> BlockPlacerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BlockPlacerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BlockPlacerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockPlacerBlock.RUNNING)).booleanValue()) {
                return;
            }
            Item item = ((ItemResource)this.inputHandler.getResource(0)).toStack().getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                BlockHitResult rayTrace = new BlockHitResult(this.worldPosition.getCenter(), (Direction)this.getBlockState().getValue((Property)BlockPlacerBlock.FACING), this.worldPosition, false);
                BlockPlaceContext blockPlaceContext = new BlockPlaceContext(this.level, null, InteractionHand.MAIN_HAND, ((ItemResource)this.inputHandler.getResource(0)).toStack(), rayTrace);
                if (blockPlaceContext.canPlace()) {
                    ++this.progress;
                    if (this.progress >= this.maxProgress) {
                        if (blockItem.place(blockPlaceContext).consumesAction()) {
                            try (Transaction tx = Transaction.open(null);){
                                this.inputHandler.extractInternal(0, (ItemResource)this.inputHandler.getResource(0), 1, (TransactionContext)tx);
                                tx.commit();
                            }
                        }
                        this.progress = 0;
                        this.sync();
                    }
                }
            } else {
                this.progress = 0;
                this.sync();
            }
        }
    }

    public InputItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return this.inputHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new BlockPlacerMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.block_placer");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.maxProgress = input.getIntOr("maxProgress", 20);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
    }
}

