/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.item.CombinedItemHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.block.entity.handler.item.OutputItemHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.DryingTableBlock;
import com.benbenlaw.utility.config.UtilityStartUpConfig;
import com.benbenlaw.utility.recipe.DryingTableRecipeInput;
import com.benbenlaw.utility.recipe.DryingTableRecipeType;
import com.benbenlaw.utility.recipe.UtilityRecipeTypes;
import com.benbenlaw.utility.recipe.custom.DryingTableRecipe;
import com.benbenlaw.utility.screen.drying.DryingTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingTableBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = (Integer)UtilityStartUpConfig.dryingTableMaxDuration.get();
    private int progress = 0;
    private final InputItemHandler inputHandler = new InputItemHandler((SyncableBlockEntity)this, 1, (i, stack) -> i == 0);
    private final OutputItemHandler outputHandler = new OutputItemHandler((SyncableBlockEntity)this, 1, i -> i == 0);
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 0;
    private RecipeHolder<DryingTableRecipe> cachedRecipe;

    public DryingTableBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.DRYING_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> DryingTableBlockEntity.this.progress;
                    case 1 -> DryingTableBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        DryingTableBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DryingTableBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (this.level.isClientSide()) {
            return;
        }
        boolean running = (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)DryingTableBlock.RUNNING);
        if (!running) {
            this.progress = 0;
            this.sync();
            return;
        }
        ItemStack inputStack = ((ItemResource)this.inputHandler.getResource(0)).toStack();
        if (inputStack.isEmpty()) {
            this.progress = 0;
            this.sync();
            this.cachedRecipe = null;
            return;
        }
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.cachedRecipe != null && this.canInsertOutput(((DryingTableRecipe)this.cachedRecipe.value()).output())) {
            ++this.progress;
            if (this.progress >= this.maxProgress) {
                this.craftItem();
            }
        } else {
            this.progress = 0;
            this.sync();
        }
    }

    private void craftItem() {
        if (this.cachedRecipe != null) {
            DryingTableRecipe recipe = (DryingTableRecipe)this.cachedRecipe.value();
            try (Transaction tx = Transaction.open(null);){
                this.inputHandler.extractInternal(0, (ItemResource)this.inputHandler.getResource(0), recipe.input().count(), (TransactionContext)tx);
                this.outputHandler.insertInternal(0, ItemResource.of((ItemStack)recipe.output()), recipe.output().getCount(), (TransactionContext)tx);
                tx.commit();
            }
            assert (this.level != null);
            if (recipe.recipeType() == DryingTableRecipeType.SOAKING) {
                this.level.playSound(null, this.worldPosition, SoundEvents.MUD_PLACE, SoundSource.BLOCKS, 0.4f, 1.0f);
            } else {
                this.level.playSound(null, this.worldPosition, SoundEvents.DRY_GRASS, SoundSource.BLOCKS, 0.4f, 1.0f);
            }
            this.progress = 0;
            this.sync();
        }
    }

    private boolean canInsertOutput(ItemStack output) {
        ItemStack outputSlot = ((ItemResource)this.outputHandler.getResource(0)).toStack();
        if (outputSlot.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)outputSlot, (ItemStack)output)) {
            return false;
        }
        int result = outputSlot.getCount() + output.getCount();
        return result <= output.getMaxStackSize();
    }

    private void updateCachedRecipe() {
        if (this.level != null && this.level.getServer() != null) {
            boolean isWaterlogged = (Boolean)this.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED);
            this.cachedRecipe = this.level.getServer().getRecipeManager().getRecipeFor(UtilityRecipeTypes.DRYING_TABLE_TYPE.get(), (RecipeInput)new DryingTableRecipeInput(this.inputHandler, isWaterlogged), this.level).orElse(null);
        }
    }

    public InputItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public OutputItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return new CombinedItemHandler(this.inputHandler, this.outputHandler);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new DryingTableMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        if (((Boolean)this.getBlockState().getValue((Property)DryingTableBlock.WATERLOGGED)).booleanValue()) {
            return Component.translatable((String)"block.utility.soaking_table");
        }
        return Component.translatable((String)"block.utility.drying_table");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        this.outputHandler.serialize(output.child("output"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.outputHandler.deserialize(input.childOrEmpty("output"));
        this.maxProgress = input.getIntOr("maxProgress", ((Integer)UtilityStartUpConfig.dryingTableMaxDuration.get()).intValue());
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
        this.dropInventoryContents((ItemStacksResourceHandler)this.outputHandler);
    }
}

