/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.WhitelistBlockEntity;
import com.benbenlaw.core.block.entity.handler.fluid.FilterFluidHandler;
import com.benbenlaw.core.block.entity.handler.fluid.OutputFluidHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.FluidCollectorBlock;
import com.benbenlaw.utility.screen.collector.FluidCollectorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidCollectorBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
WhitelistBlockEntity {
    private final ContainerData data;
    private int maxProgress = 20;
    private int progress = 0;
    private final OutputFluidHandler outputFluidHandler = new OutputFluidHandler((SyncableBlockEntity)this, 1, 16000, i -> i == 0);
    public static final int TANK_SLOT = 0;
    private boolean whitelist = true;
    private FilterFluidHandler filterFluidHandler = new FilterFluidHandler((SyncableBlockEntity)this, 1);

    public FluidCollectorBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.FLUID_COLLECTOR_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> FluidCollectorBlockEntity.this.progress;
                    case 1 -> FluidCollectorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidCollectorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FluidCollectorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)FluidCollectorBlock.RUNNING)).booleanValue()) {
                return;
            }
            BlockPos targetPos = this.worldPosition.relative((Direction)this.level.getBlockState(this.worldPosition).getValue((Property)FluidCollectorBlock.FACING));
            Fluid fluidInWorld = this.level.getFluidState(targetPos).getType();
            FluidStack fluidStack = new FluidStack(fluidInWorld, 1000);
            if (this.outputFluidHandler.getAmountAsInt(0) > this.outputFluidHandler.getCapacityAsInt(0, (Resource)FluidResource.EMPTY) - 1000) {
                return;
            }
            FluidResource current = (FluidResource)this.outputFluidHandler.getResource(0);
            if (!current.isEmpty() && !current.getFluid().isSame(fluidInWorld)) {
                return;
            }
            if (!this.level.getFluidState(targetPos).isEmpty() && this.filterFluidHandler.matchesFluid(fluidStack, this.whitelist)) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    Fluid fluid = ((FluidResource)this.outputFluidHandler.getResource(0)).getFluid();
                    SoundEvent soundEvent = fluid.getFluidType().getSound(new FluidStack(fluid, 1000), SoundActions.BUCKET_FILL);
                    if (soundEvent == null) {
                        soundEvent = SoundEvents.BUCKET_FILL;
                    }
                    this.level.playSound(null, this.worldPosition, soundEvent, SoundSource.BLOCKS, 0.4f, 1.0f);
                    try (Transaction tx = Transaction.open(null);){
                        this.outputFluidHandler.insertInternal(0, FluidResource.of((Fluid)fluidInWorld), 1000, (TransactionContext)tx);
                        tx.commit();
                    }
                    this.level.setBlockAndUpdate(targetPos, Blocks.AIR.defaultBlockState());
                    this.progress = 0;
                    this.setChanged();
                    this.sync();
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public OutputFluidHandler getFluidOutputHandler() {
        return this.outputFluidHandler;
    }

    public FilterFluidHandler getFilterFluidHandler() {
        return this.filterFluidHandler;
    }

    public ResourceHandler<FluidResource> getFluidCapability() {
        return this.outputFluidHandler;
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (BlockPos)this.worldPosition, (ResourceHandler)this.outputFluidHandler);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new FluidCollectorMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.fluid_collector");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.outputFluidHandler.serialize(output.child("outputFluid"));
        this.filterFluidHandler.serialize(output.child("fluidFilter"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.outputFluidHandler.deserialize(input.childOrEmpty("outputFluid"));
        this.filterFluidHandler.deserialize(input.childOrEmpty("fluidFilter"));
        this.maxProgress = input.getIntOr("maxProgress", 20);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelist = whitelist;
        this.setChanged();
        this.sync();
    }
}

