/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.fluid.OutputFluidHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.FluidGeneratorBlock;
import com.benbenlaw.utility.recipe.UtilityRecipeTypes;
import com.benbenlaw.utility.recipe.custom.FluidGeneratorRecipe;
import com.benbenlaw.utility.screen.generator.FluidGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = 200;
    private int progress = 0;
    private final InputItemHandler inputHandler = new InputItemHandler((SyncableBlockEntity)this, 1, (index, stack) -> true);
    private final OutputFluidHandler outputFluidHandler = new OutputFluidHandler((SyncableBlockEntity)this, 1, 16000, i -> i == 0);
    public static final int INPUT_SLOT = 0;
    public static final int TANK_SLOT = 0;
    private RecipeHolder<FluidGeneratorRecipe> cachedRecipe;

    public FluidGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.FLUID_GENERATOR_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> FluidGeneratorBlockEntity.this.progress;
                    case 1 -> FluidGeneratorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidGeneratorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FluidGeneratorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)FluidGeneratorBlock.RUNNING)).booleanValue()) {
                return;
            }
            ItemStack inputStack = ((ItemResource)this.inputHandler.getResource(0)).toStack();
            if (inputStack.isEmpty()) {
                this.progress = 0;
                this.sync();
                this.cachedRecipe = null;
                return;
            }
            if (this.cachedRecipe == null) {
                this.updateCachedRecipe();
            }
            if (!this.hasEnoughSpace(((FluidGeneratorRecipe)this.cachedRecipe.value()).output())) {
                return;
            }
            if (this.cachedRecipe != null && this.canInsertOutput(((FluidGeneratorRecipe)this.cachedRecipe.value()).output())) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.craftItem();
                }
            } else {
                this.progress = 0;
            }
        }
    }

    private boolean hasEnoughSpace(FluidStack stack) {
        FluidResource current = (FluidResource)this.outputFluidHandler.getResource(0);
        return current.isEmpty() || current.getFluid().isSame(stack.getFluid()) && this.outputFluidHandler.getAmountAsInt(0) <= this.outputFluidHandler.getCapacityAsInt(0, (Resource)FluidResource.EMPTY) - stack.getAmount();
    }

    private void craftItem() {
        if (this.cachedRecipe != null) {
            FluidGeneratorRecipe recipe = (FluidGeneratorRecipe)this.cachedRecipe.value();
            try (Transaction tx = Transaction.open(null);){
                this.outputFluidHandler.insertInternal(0, FluidResource.of((FluidStack)recipe.output()), recipe.output().getAmount(), (TransactionContext)tx);
                tx.commit();
            }
            this.progress = 0;
            this.sync();
        }
    }

    private boolean canInsertOutput(FluidStack output) {
        FluidStack outputTankFluid = ((FluidResource)this.outputFluidHandler.getResource(0)).toStack(0);
        if (outputTankFluid.isEmpty()) {
            return true;
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)outputTankFluid, (FluidStack)output)) {
            return false;
        }
        int result = outputTankFluid.getAmount() + output.getAmount();
        return result <= this.outputFluidHandler.getCapacityAsInt(0, (Resource)FluidResource.EMPTY);
    }

    private void updateCachedRecipe() {
        if (this.level != null && this.level.getServer() != null) {
            this.cachedRecipe = this.level.getServer().getRecipeManager().getRecipeFor(UtilityRecipeTypes.FLUID_GENERATOR_TYPE.get(), (RecipeInput)new SingleRecipeInput(((ItemResource)this.inputHandler.getResource(0)).toStack()), this.level).orElse(null);
        }
    }

    public boolean onPlayerUse(Player player, InteractionHand hand, Direction direction) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (BlockPos)this.worldPosition, (ResourceHandler)this.outputFluidHandler);
    }

    public InputItemHandler getInputItemHandler() {
        return this.inputHandler;
    }

    public OutputFluidHandler getOutputFluidHandler() {
        return this.outputFluidHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return this.inputHandler;
    }

    public ResourceHandler<FluidResource> getFluidCapability() {
        return this.outputFluidHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new FluidGeneratorMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.fluid_generator");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        this.outputFluidHandler.serialize(output.child("outputFluid"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.outputFluidHandler.deserialize(input.childOrEmpty("outputFluid"));
        this.maxProgress = input.getIntOr("maxProgress", 200);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
    }
}

