/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.fluid.InputFluidHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.FluidPlacerBlock;
import com.benbenlaw.utility.screen.placer.FluidPlacerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPlacerBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = 20;
    private int progress = 0;
    private final InputFluidHandler inputFluidHandler = new InputFluidHandler((SyncableBlockEntity)this, 1, 16000, (i, stack) -> i == 0);
    public static final int TANK_SLOT = 0;

    public FluidPlacerBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.FLUID_PLACER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> FluidPlacerBlockEntity.this.progress;
                    case 1 -> FluidPlacerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidPlacerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FluidPlacerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)FluidPlacerBlock.RUNNING)).booleanValue()) {
                return;
            }
            if (this.inputFluidHandler.getAmountAsInt(0) == 0) {
                return;
            }
            BlockPos targetPos = this.worldPosition.relative((Direction)this.level.getBlockState(this.worldPosition).getValue((Property)FluidPlacerBlock.FACING));
            if (this.inputFluidHandler.getAmountAsInt(0) >= 1000 && this.level.getFluidState(targetPos).isEmpty() && this.level.getBlockState(targetPos).isEmpty()) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    Fluid fluid = ((FluidResource)this.inputFluidHandler.getResource(0)).getFluid();
                    SoundEvent soundEvent = fluid.getFluidType().getSound(new FluidStack(fluid, 1000), SoundActions.BUCKET_EMPTY);
                    if (soundEvent == null) {
                        soundEvent = SoundEvents.BUCKET_EMPTY;
                    }
                    this.level.playSound(null, this.worldPosition, soundEvent, SoundSource.BLOCKS, 0.4f, 1.0f);
                    this.level.setBlockAndUpdate(targetPos, ((FluidResource)this.inputFluidHandler.getResource(0)).getFluid().defaultFluidState().createLegacyBlock());
                    try (Transaction tx = Transaction.open(null);){
                        this.inputFluidHandler.extractInternal(0, FluidResource.of((Fluid)((FluidResource)this.inputFluidHandler.getResource(0)).getFluid()), 1000, (TransactionContext)tx);
                        tx.commit();
                    }
                    this.progress = 0;
                    this.setChanged();
                    this.sync();
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public InputFluidHandler getInputFluidHandler() {
        return this.inputFluidHandler;
    }

    public ResourceHandler<FluidResource> getFluidCapability() {
        return this.inputFluidHandler;
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (BlockPos)this.worldPosition, (ResourceHandler)this.inputFluidHandler);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new FluidPlacerMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.fluid_placer");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputFluidHandler.serialize(output.child("inputFluid"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputFluidHandler.deserialize(input.childOrEmpty("inputFluid"));
        this.maxProgress = input.getIntOr("maxProgress", 20);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }
}

