/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.item.CombinedItemHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.block.entity.handler.item.OutputItemHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.ItemRepairerBlock;
import com.benbenlaw.utility.screen.repairer.ItemRepairerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRepairerBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = 200;
    private int progress = 0;
    private final InputItemHandler inputHandler = new InputItemHandler((SyncableBlockEntity)this, 1, (i, stack) -> i == 0);
    private final OutputItemHandler outputHandler = new OutputItemHandler((SyncableBlockEntity)this, 1, i -> i == 0);
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 0;

    public ItemRepairerBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.ITEM_REPAIRER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ItemRepairerBlockEntity.this.progress;
                    case 1 -> ItemRepairerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ItemRepairerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ItemRepairerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ItemRepairerBlock.RUNNING)).booleanValue()) {
                return;
            }
            if (!((ItemResource)this.outputHandler.getResource(0)).isEmpty()) {
                return;
            }
            if (((ItemResource)this.inputHandler.getResource(0)).toStack().isDamageableItem()) {
                ItemStack tool = ((ItemResource)this.inputHandler.getResource(0)).toStack();
                int damage = tool.getDamageValue();
                int maxDamage = tool.getMaxDamage();
                this.maxProgress = maxDamage - damage;
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    tool.setDamageValue(-maxDamage);
                    this.outputHandler.set(0, (Resource)ItemResource.of((ItemStack)tool.copy()), 1);
                    try (Transaction tx = Transaction.open(null);){
                        this.inputHandler.extractInternal(0, (ItemResource)this.inputHandler.getResource(0), 1, (TransactionContext)tx);
                        tx.commit();
                    }
                    this.level.playSound(null, this.worldPosition, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.4f, 1.0f);
                    this.progress = 0;
                    this.maxProgress = 200;
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public InputItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public OutputItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return new CombinedItemHandler(this.inputHandler, this.outputHandler);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new ItemRepairerMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.item_repairer");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        this.outputHandler.serialize(output.child("output"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.outputHandler.deserialize(input.childOrEmpty("output"));
        this.maxProgress = input.getIntOr("maxProgress", 200);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
        this.dropInventoryContents((ItemStacksResourceHandler)this.outputHandler);
    }
}

