/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.RedstoneClockBlock;
import com.benbenlaw.utility.screen.clock.RedstoneClockMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneClockBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> RedstoneClockBlockEntity.this.progress;
                case 1 -> RedstoneClockBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    RedstoneClockBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RedstoneClockBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int maxProgress = 200;
    private int onTime = 10;
    private int signalStrength = 15;
    private boolean emittingRedstoneSignal = false;
    private int progress = 0;
    int emittingProgress = 0;

    public RedstoneClockBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.REDSTONE_CLOCK_BLOCK_ENTITY.get(), pos, state);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)RedstoneClockBlock.RUNNING)).booleanValue() && !this.emittingRedstoneSignal) {
                return;
            }
            if (!this.emittingRedstoneSignal) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.emittingRedstoneSignal = true;
                    this.emittingProgress = 0;
                    this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
                    this.level.playSound(null, this.worldPosition, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.4f, 1.0f);
                }
            } else {
                ++this.emittingProgress;
                if (this.emittingProgress >= this.onTime) {
                    this.emittingRedstoneSignal = false;
                    this.progress = 0;
                    this.emittingProgress = 0;
                    this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
                    this.level.playSound(null, this.worldPosition, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 1.0f);
                }
            }
        }
    }

    public void setMaxProgress(int newMaxProgress) {
        this.maxProgress = newMaxProgress;
        this.sync();
        this.setChanged();
    }

    public void setOnTime(int newOnTime) {
        this.onTime = newOnTime;
        this.sync();
        this.setChanged();
    }

    public void setSignalStrength(int newSignalStrength) {
        this.signalStrength = newSignalStrength;
        this.sync();
        assert (this.level != null);
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        this.setChanged();
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getOnTime() {
        return this.onTime;
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public boolean isEmittingRedstoneSignal() {
        return this.emittingRedstoneSignal;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new RedstoneClockMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.redstone_clock");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("onTime", this.onTime);
        output.putInt("signalStrength", this.signalStrength);
        output.putInt("progress", this.progress);
        output.putInt("emittingProgress", this.emittingProgress);
        output.putBoolean("emittingRedstoneSignal", this.emittingRedstoneSignal);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.maxProgress = input.getIntOr("maxProgress", 200);
        this.onTime = input.getIntOr("onTime", 10);
        this.signalStrength = input.getIntOr("signalStrength", 15);
        this.progress = input.getIntOr("progress", 0);
        this.emittingProgress = input.getIntOr("emittingProgress", 0);
        this.emittingRedstoneSignal = input.getBooleanOr("emittingRedstoneSignal", false);
        super.loadAdditional(input);
    }
}

