/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.block.entity;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.fluid.InputFluidHandler;
import com.benbenlaw.core.block.entity.handler.item.CombinedItemHandler;
import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.block.entity.handler.item.OutputItemHandler;
import com.benbenlaw.utility.block.UtilityBlockEntities;
import com.benbenlaw.utility.block.custom.ResourceGeneratorBlock;
import com.benbenlaw.utility.block.entity.SingleInputItemHandler;
import com.benbenlaw.utility.recipe.ResourceGeneratorRecipeInput;
import com.benbenlaw.utility.recipe.UtilityRecipeTypes;
import com.benbenlaw.utility.recipe.custom.ResourceGeneratorRecipe;
import com.benbenlaw.utility.screen.generator.ResourceGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    private final ContainerData data;
    private int maxProgress = 200;
    private int progress = 0;
    private final InputItemHandler inputHandler = new SingleInputItemHandler(this, 1, (index, stack) -> true);
    private final OutputItemHandler outputHandler = new OutputItemHandler((SyncableBlockEntity)this, 1, i -> i == 0);
    private final InputFluidHandler inputFluidHandlerLeft = new InputFluidHandler((SyncableBlockEntity)this, 2, 16000, (i, stack) -> i == 0);
    private final InputFluidHandler inputFluidHandlerRight = new InputFluidHandler((SyncableBlockEntity)this, 2, 16000, (i, stack) -> i == 0);
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 0;
    public static final int LEFT_TANK_SLOT = 0;
    public static final int RIGHT_TANK_SLOT = 0;
    private RecipeHolder<ResourceGeneratorRecipe> cachedRecipe;

    public ResourceGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(UtilityBlockEntities.RESOURCE_GENERATOR_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ResourceGeneratorBlockEntity.this.progress;
                    case 1 -> ResourceGeneratorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ResourceGeneratorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ResourceGeneratorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            ItemStack inputStack;
            if (!((Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ResourceGeneratorBlock.RUNNING)).booleanValue()) {
                return;
            }
            if (this.cachedRecipe == null) {
                this.updateCachedRecipe();
            }
            if ((inputStack = ((ItemResource)this.inputHandler.getResource(0)).toStack()).isEmpty()) {
                this.progress = 0;
                this.sync();
                this.cachedRecipe = null;
                return;
            }
            if (this.cachedRecipe != null && this.canInsertOutput(((ResourceGeneratorRecipe)this.cachedRecipe.value()).output())) {
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.craftItem();
                }
            } else {
                this.progress = 0;
            }
        }
    }

    private void craftItem() {
        if (this.cachedRecipe != null) {
            ResourceGeneratorRecipe recipe = (ResourceGeneratorRecipe)this.cachedRecipe.value();
            ItemStack output = recipe.output().copy();
            try (Transaction tx = Transaction.open(null);){
                this.outputHandler.insertInternal(0, ItemResource.of((ItemStack)output), output.getCount(), (TransactionContext)tx);
                if (recipe.consumeLeft()) {
                    this.inputFluidHandlerLeft.extractInternal(0, FluidResource.of((FluidStack)recipe.leftFluid()), recipe.leftFluid().getAmount(), (TransactionContext)tx);
                }
                if (recipe.consumeRight()) {
                    this.inputFluidHandlerRight.extractInternal(0, FluidResource.of((FluidStack)recipe.rightFluid()), recipe.rightFluid().getAmount(), (TransactionContext)tx);
                }
                tx.commit();
            }
            this.progress = 0;
            this.sync();
        }
    }

    private boolean canInsertOutput(ItemStack output) {
        ItemStack outputSlot = ((ItemResource)this.outputHandler.getResource(0)).toStack();
        if (outputSlot.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)outputSlot, (ItemStack)output)) {
            return false;
        }
        int result = outputSlot.getCount() + output.getCount();
        return result <= output.getMaxStackSize();
    }

    private void updateCachedRecipe() {
        if (this.level != null && this.level.getServer() != null) {
            this.cachedRecipe = this.level.getServer().getRecipeManager().getRecipeFor(UtilityRecipeTypes.RESOURCE_GENERATOR_TYPE.get(), (RecipeInput)new ResourceGeneratorRecipeInput(this.inputHandler, this.inputFluidHandlerLeft, this.inputFluidHandlerRight), this.level).orElse(null);
        }
    }

    public boolean onPlayerUse(Player player, InteractionHand hand, Direction direction) {
        if (direction == Direction.UP || direction == Direction.WEST || direction == Direction.NORTH) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (BlockPos)this.worldPosition, (ResourceHandler)this.inputFluidHandlerLeft);
        }
        if (direction == Direction.DOWN || direction == Direction.EAST || direction == Direction.SOUTH) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (BlockPos)this.worldPosition, (ResourceHandler)this.inputFluidHandlerRight);
        }
        return false;
    }

    public InputItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public OutputItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ResourceHandler<ItemResource> getItemCapability() {
        return new CombinedItemHandler(this.inputHandler, this.outputHandler);
    }

    public InputFluidHandler getInputFluidHandlerLeft() {
        return this.inputFluidHandlerLeft;
    }

    public InputFluidHandler getInputFluidHandlerRight() {
        return this.inputFluidHandlerRight;
    }

    public ResourceHandler<FluidResource> getFluidCapability(Direction direction) {
        if (direction == Direction.UP || direction == Direction.WEST || direction == Direction.NORTH) {
            return this.inputFluidHandlerLeft;
        }
        if (direction == Direction.DOWN || direction == Direction.EAST || direction == Direction.SOUTH) {
            return this.inputFluidHandlerRight;
        }
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, Inventory inventory, Player player) {
        return new ResourceGeneratorMenu(container, inventory, this.worldPosition, this.data);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.utility.resource_generator");
    }

    protected void saveAdditional(@NotNull ValueOutput output) {
        this.inputHandler.serialize(output.child("input"));
        this.outputHandler.serialize(output.child("output"));
        this.inputFluidHandlerLeft.serialize(output.child("inputFluidLeft"));
        this.inputFluidHandlerRight.serialize(output.child("inputFluidRight"));
        output.putInt("maxProgress", this.maxProgress);
        output.putInt("progress", this.progress);
        super.saveAdditional(output);
    }

    protected void loadAdditional(@NotNull ValueInput input) {
        this.inputHandler.deserialize(input.childOrEmpty("input"));
        this.outputHandler.deserialize(input.childOrEmpty("output"));
        this.inputFluidHandlerLeft.deserialize(input.childOrEmpty("inputFluidLeft"));
        this.inputFluidHandlerRight.deserialize(input.childOrEmpty("inputFluidRight"));
        this.maxProgress = input.getIntOr("maxProgress", 200);
        this.progress = input.getIntOr("progress", 0);
        super.loadAdditional(input);
    }

    public void preRemoveSideEffects(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.dropInventoryContents((ItemStacksResourceHandler)this.inputHandler);
        this.dropInventoryContents((ItemStacksResourceHandler)this.outputHandler);
    }
}

