/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.data;

import com.benbenlaw.utility.data.UtilityBlockTags;
import com.benbenlaw.utility.data.UtilityDataMapsProvider;
import com.benbenlaw.utility.data.UtilityLangProvider;
import com.benbenlaw.utility.data.UtilityLootTableProvider;
import com.benbenlaw.utility.data.UtilityModelProvider;
import com.benbenlaw.utility.data.UtilityRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="utility")
public class UtilityDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new UtilityBlockTags(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new UtilityLangProvider(packOutput));
        generator.addProvider(true, (DataProvider)new UtilityDataMapsProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(UtilityLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(true, (DataProvider)new UtilityModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new UtilityRecipeProvider.Runner(packOutput, lookupProvider));
    }
}

