/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.data;

import com.benbenlaw.utility.block.UtilityBlocks;
import com.benbenlaw.utility.item.UtilityItems;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class UtilityLootTableProvider
extends VanillaBlockLoot {
    private final Set<Block> knownBlocks = new ReferenceOpenHashSet();

    public UtilityLootTableProvider(HolderLookup.Provider provider) {
        super(provider);
    }

    protected void generate() {
        this.createEnderOreDrops((Block)UtilityBlocks.ENDER_ORE.get());
        this.createEnderOreDrops((Block)UtilityBlocks.DEEPSLATE_ENDER_ORE.get());
        this.dropSelf((Block)UtilityBlocks.DRYING_TABLE.get());
        this.dropSelf((Block)UtilityBlocks.BLOCK_PLACER.get());
        this.dropSelf((Block)UtilityBlocks.BLOCK_BREAKER.get());
        this.dropSelf((Block)UtilityBlocks.RESOURCE_GENERATOR.get());
        this.dropSelf((Block)UtilityBlocks.FLUID_COLLECTOR.get());
        this.dropSelf((Block)UtilityBlocks.FLUID_PLACER.get());
    }

    protected void createEnderOreDrops(Block block) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootTable.Builder table = this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UtilityItems.ENDER_PEARL_FRAGMENT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
        this.add(block, table);
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

