/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.data;

import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.block.UtilityBlocks;
import com.benbenlaw.utility.data.custom.DryingTableRecipeBuilder;
import com.benbenlaw.utility.data.custom.ResourceGeneratorRecipeBuilder;
import com.benbenlaw.utility.item.UtilityItems;
import com.benbenlaw.utility.recipe.DryingTableRecipeType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class UtilityRecipeProvider
extends RecipeProvider {
    public static final ImmutableList<ItemLike> ENDER_SMELTABLES = ImmutableList.of((Object)((ItemLike)UtilityBlocks.ENDER_ORE.get()), (Object)((ItemLike)UtilityBlocks.DEEPSLATE_ENDER_ORE.get()));

    public UtilityRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.shaped(RecipeCategory.MISC, (ItemLike)UtilityItems.ANIMAL_NET.get()).pattern("ABA").pattern("B B").pattern("ABA").define(Character.valueOf('A'), Tags.Items.RODS_WOODEN).define(Character.valueOf('B'), (ItemLike)Items.LEATHER).group("utility").unlockedBy("has_item", this.has(Tags.Items.RODS_WOODEN)).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.COAL).requires(UtilityItems.MINI_COAL, 8).unlockedBy("has_item", this.has((ItemLike)UtilityItems.MINI_COAL)).group("utility").save(this.output, String.valueOf(Utility.rl("coal")));
        this.shapeless(RecipeCategory.MISC, (ItemLike)UtilityItems.MINI_COAL.get(), 8).requires((ItemLike)Items.COAL).unlockedBy("has_item", this.has((ItemLike)Items.COAL)).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.CHARCOAL).requires(UtilityItems.MINI_CHARCOAL, 8).unlockedBy("has_item", this.has((ItemLike)UtilityItems.MINI_CHARCOAL)).group("utility").save(this.output, String.valueOf(Utility.rl("charcoal")));
        this.shapeless(RecipeCategory.MISC, (ItemLike)UtilityItems.MINI_CHARCOAL.get(), 8).requires((ItemLike)Items.CHARCOAL).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.CHARCOAL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.CHEST).pattern("AAA").pattern("A A").pattern("AAA").define(Character.valueOf('A'), ItemTags.LOGS).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.CHEST)).save(this.output, String.valueOf(Utility.rl("chests")));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)UtilityItems.CROOK.get()).pattern(" AA").pattern(" A ").pattern(" A ").define(Character.valueOf('A'), Tags.Items.RODS_WOODEN).group("utility").unlockedBy("has_item", this.has(Tags.Items.RODS_WOODEN)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.IRON_HORSE_ARMOR).pattern("AAA").pattern("ABA").define(Character.valueOf('A'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('B'), (ItemLike)Items.LEATHER_HORSE_ARMOR).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.IRON_INGOT)).save(this.output, String.valueOf(Utility.rl("iron_horse_armor")));
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.GOLDEN_HORSE_ARMOR).pattern("AAA").pattern("ABA").define(Character.valueOf('A'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('B'), (ItemLike)Items.LEATHER_HORSE_ARMOR).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.GOLD_INGOT)).save(this.output, String.valueOf(Utility.rl("gold_horse_armor")));
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.DIAMOND_HORSE_ARMOR).pattern("AAA").pattern("ABA").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('B'), (ItemLike)Items.LEATHER_HORSE_ARMOR).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.DIAMOND)).save(this.output, String.valueOf(Utility.rl("diamond_horse_armor")));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)UtilityBlocks.DRYING_TABLE.get()).pattern("ABA").pattern("ABA").pattern("A A").define(Character.valueOf('A'), ItemTags.LOGS).define(Character.valueOf('B'), Tags.Items.STRINGS).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.CRAFTING_TABLE)).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.ENDER_PEARL).requires(UtilityItems.ENDER_PEARL_FRAGMENT, 8).unlockedBy("has_item", this.has((ItemLike)UtilityItems.ENDER_PEARL_FRAGMENT)).group("utility").save(this.output, String.valueOf(Utility.rl("ender_pearl")));
        this.shapeless(RecipeCategory.MISC, (ItemLike)UtilityItems.ENDER_PEARL_FRAGMENT.get(), 8).requires((ItemLike)Items.ENDER_PEARL).unlockedBy("has_item", this.has((ItemLike)Items.ENDER_PEARL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)UtilityItems.FLOATER.get()).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), Tags.Items.FEATHERS).define(Character.valueOf('B'), ItemTags.WOOL).group("utility").unlockedBy("has_item", this.has(Tags.Items.FEATHERS)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.GREEN_WOOL).pattern("AA").pattern("AA").define(Character.valueOf('A'), UtilityItems.LEAFY_STRING).group("utility").unlockedBy("has_item", this.has((ItemLike)UtilityItems.LEAFY_STRING)).save(this.output, String.valueOf(Utility.rl("green_wool")));
        this.shaped(RecipeCategory.MISC, (ItemLike)UtilityItems.LEAFY_STRING.get()).pattern("AAA").define(Character.valueOf('A'), ItemTags.LEAVES).group("utility").unlockedBy("has_item", this.has(ItemTags.LEAVES)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)UtilityItems.LOG_SHEET.get(), 6).pattern(" A ").pattern("A A").pattern(" A ").define(Character.valueOf('A'), ItemTags.LOGS).group("utility").unlockedBy("has_item", this.has(ItemTags.LOGS)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.NAME_TAG).pattern("  A").pattern(" B ").pattern("B  ").define(Character.valueOf('A'), Tags.Items.STRINGS).define(Character.valueOf('B'), (ItemLike)Items.PAPER).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.PAPER)).save(this.output, String.valueOf(Utility.rl("name_tag")));
        this.shaped(RecipeCategory.MISC, (ItemLike)UtilityItems.SAPLING_GROWER.get()).pattern("  A").pattern(" B ").pattern("B  ").define(Character.valueOf('A'), (ItemLike)Items.BONE_BLOCK).define(Character.valueOf('B'), Tags.Items.RODS_WOODEN).group("utility").unlockedBy("has_item", this.has((ItemLike)Items.BONE_MEAL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Items.STICK, 16).pattern("A").pattern("A").define(Character.valueOf('A'), ItemTags.LOGS).group("utility").unlockedBy("has_item", this.has((ItemLike)UtilityItems.LOG_SHEET.get())).save(this.output, String.valueOf(Utility.rl("sticks")));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)UtilityItems.WOODEN_SHEARS.get()).pattern(" A").pattern("A ").define(Character.valueOf('A'), ItemTags.PLANKS).group("utility").unlockedBy("has_item", this.has(Tags.Items.RODS_WOODEN)).save(this.output);
        this.oreSmelting((List<ItemLike>)ENDER_SMELTABLES, RecipeCategory.MISC, (ItemLike)UtilityItems.ENDER_PEARL_FRAGMENT, 0.7f, 200, "ender");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of((HolderSet)this.tag(ItemTags.SAPLINGS).getValues()), 1), new ItemStack((ItemLike)Items.DEAD_BUSH), DryingTableRecipeType.DRYING).save(this.output, "drying/dead_bush");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of((ItemLike)Items.STONE_BRICKS), 1), new ItemStack((ItemLike)Items.CRACKED_STONE_BRICKS), DryingTableRecipeType.DRYING).save(this.output, "drying/cracked_stone_bricks");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of(UtilityItems.SOAKED_PAPER), 1), new ItemStack((ItemLike)Items.PAPER), DryingTableRecipeType.DRYING).save(this.output, "drying/paper");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of((ItemLike)Items.PAPER), 1), new ItemStack((ItemLike)UtilityItems.SOAKED_PAPER.get()), DryingTableRecipeType.SOAKING).save(this.output, "soaking/soaked_paper");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of(UtilityItems.LOG_SHEET), 1), new ItemStack((ItemLike)UtilityItems.SOAKED_PAPER.get()), DryingTableRecipeType.SOAKING).save(this.output, "soaking/soaked_paper_from_log_sheet");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of((ItemLike)Items.WET_SPONGE), 1), new ItemStack((ItemLike)Items.SPONGE), DryingTableRecipeType.DRYING).save(this.output, "drying/sponge");
        DryingTableRecipeBuilder.dryingTable(new SizedIngredient(Ingredient.of((ItemLike)Items.SPONGE), 1), new ItemStack((ItemLike)Items.WET_SPONGE), DryingTableRecipeType.SOAKING).save(this.output, "soaking/wet_sponge");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.COBBLESTONE.getDefaultInstance(), Items.COBBLESTONE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "cobblestone");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.STONE.getDefaultInstance(), Items.STONE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "stone");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.ANDESITE.getDefaultInstance(), Items.ANDESITE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "andesite");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.DIORITE.getDefaultInstance(), Items.DIORITE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "diorite");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.GRANITE.getDefaultInstance(), Items.GRANITE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "granite");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.DEEPSLATE.getDefaultInstance(), Items.DEEPSLATE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "deepslate");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.COBBLED_DEEPSLATE.getDefaultInstance(), Items.COBBLED_DEEPSLATE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "cobbled_deepslate");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.TUFF.getDefaultInstance(), Items.TUFF.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, false).save(this.output, "tuff");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.OBSIDIAN.getDefaultInstance(), Items.OBSIDIAN.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 1000), new FluidStack((Fluid)Fluids.LAVA, 1000), false, true).save(this.output, "obsidian");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.BASALT.getDefaultInstance(), Items.BASALT.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 25), new FluidStack((Fluid)Fluids.LAVA, 25), true, true).save(this.output, "basalt");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.BLACKSTONE.getDefaultInstance(), Items.BLACKSTONE.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 25), new FluidStack((Fluid)Fluids.LAVA, 25), true, true).save(this.output, "blackstone");
        ResourceGeneratorRecipeBuilder.resourceGenerator(Items.NETHERRACK.getDefaultInstance(), Items.NETHERRACK.getDefaultInstance(), new FluidStack((Fluid)Fluids.WATER, 25), new FluidStack((Fluid)Fluids.LAVA, 25), true, true).save(this.output, "netherrack");
    }

    protected void oreSmelting(List<ItemLike> p_250172_, RecipeCategory p_250588_, ItemLike p_251868_, float p_250789_, int p_252144_, String p_251687_) {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, p_250172_, p_250588_, p_251868_, p_250789_, p_252144_, p_251687_, "_from_smelting");
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> p_251817_, AbstractCookingRecipe.Factory<T> p_312707_, List<ItemLike> p_249619_, RecipeCategory p_251154_, ItemLike p_250066_, float p_251871_, int p_251316_, String p_251450_, String p_249236_) {
        for (ItemLike itemlike : p_249619_) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)itemlike), (RecipeCategory)p_251154_, (ItemLike)p_250066_, (float)p_251871_, (int)p_251316_, p_251817_, p_312707_).group(p_251450_).unlockedBy(UtilityRecipeProvider.getHasName((ItemLike)itemlike), this.has(itemlike)).save(this.output, String.valueOf(Utility.rl(UtilityRecipeProvider.getItemName((ItemLike)p_250066_) + p_249236_ + "_" + UtilityRecipeProvider.getItemName((ItemLike)itemlike))));
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
            super(packOutput, provider);
        }

        @NotNull
        protected RecipeProvider createRecipeProvider(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull RecipeOutput recipeOutput) {
            return new UtilityRecipeProvider(provider, recipeOutput);
        }

        @NotNull
        public String getName() {
            return "utility Recipes";
        }
    }
}

