/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.data.custom;

import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.recipe.custom.ResourceGeneratorRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected ItemStack input;
    protected ItemStack output;
    protected FluidStack leftFluid;
    protected FluidStack rightFluid;
    protected boolean consumeLeft;
    protected boolean consumeRight;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public ResourceGeneratorRecipeBuilder(ItemStack input, ItemStack output, FluidStack leftFluid, FluidStack rightFluid, boolean consumeLeft, boolean consumeRight) {
        this.input = input;
        this.output = output;
        this.leftFluid = leftFluid;
        this.rightFluid = rightFluid;
        this.consumeLeft = consumeLeft;
        this.consumeRight = consumeRight;
    }

    public static ResourceGeneratorRecipeBuilder resourceGenerator(ItemStack input, ItemStack output, FluidStack leftFluid, FluidStack rightFluid, boolean consumeLeft, boolean consumeRight) {
        return new ResourceGeneratorRecipeBuilder(input, output, leftFluid, rightFluid, consumeLeft, consumeRight);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.output.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull String id) {
        this.save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Utility.rl("resource_generator/" + id)));
    }

    public void save(RecipeOutput recipeOutput, @NotNull ResourceKey<Recipe<?>> resourceKey) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(resourceKey)).rewards(AdvancementRewards.Builder.recipe(resourceKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        ResourceGeneratorRecipe clocheRecipe = new ResourceGeneratorRecipe(this.input, this.output, this.leftFluid, this.rightFluid, this.consumeLeft, this.consumeRight);
        recipeOutput.accept(resourceKey, (Recipe)clocheRecipe, builder.build(resourceKey.location().withPrefix("recipes/resource_generator/")));
    }
}

