/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.event;

import com.benbenlaw.utility.event.ClientRecipeCache;
import com.benbenlaw.utility.recipe.UtilityRecipeTypes;
import com.benbenlaw.utility.recipe.custom.DryingTableRecipe;
import com.benbenlaw.utility.recipe.custom.FluidGeneratorRecipe;
import com.benbenlaw.utility.recipe.custom.ResourceGeneratorRecipe;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;

@EventBusSubscriber(modid="utility")
public class RecipeEvents {
    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{UtilityRecipeTypes.DRYING_TABLE_TYPE.get()});
        event.sendRecipes(new RecipeType[]{UtilityRecipeTypes.RESOURCE_GENERATOR_TYPE.get()});
    }

    @SubscribeEvent
    public static void onRecipeReceived(RecipesReceivedEvent event) {
        RecipeMap recipeMap = event.getRecipeMap();
        Collection dryingTableRecipes = recipeMap.byType(UtilityRecipeTypes.DRYING_TABLE_TYPE.get());
        HashMap<ResourceLocation, DryingTableRecipe> dryingTableRecipeMap = new HashMap<ResourceLocation, DryingTableRecipe>();
        for (RecipeHolder holder : dryingTableRecipes) {
            dryingTableRecipeMap.put(holder.id().location(), (DryingTableRecipe)holder.value());
        }
        ClientRecipeCache.setCachedDryingTableRecipes(dryingTableRecipeMap);
        Collection resourceGeneratorRecipes = recipeMap.byType(UtilityRecipeTypes.RESOURCE_GENERATOR_TYPE.get());
        HashMap<ResourceLocation, ResourceGeneratorRecipe> resourceGeneratorRecipeMap = new HashMap<ResourceLocation, ResourceGeneratorRecipe>();
        for (RecipeHolder holder : resourceGeneratorRecipes) {
            resourceGeneratorRecipeMap.put(holder.id().location(), (ResourceGeneratorRecipe)holder.value());
        }
        ClientRecipeCache.setCachedResourceGeneratorRecipes(resourceGeneratorRecipeMap);
        Collection fluidGeneratorRecipes = recipeMap.byType(UtilityRecipeTypes.FLUID_GENERATOR_TYPE.get());
        HashMap<ResourceLocation, FluidGeneratorRecipe> fluidGeneratorRecipeMap = new HashMap<ResourceLocation, FluidGeneratorRecipe>();
        for (RecipeHolder holder : fluidGeneratorRecipes) {
            fluidGeneratorRecipeMap.put(holder.id().location(), (FluidGeneratorRecipe)holder.value());
        }
        ClientRecipeCache.setCachedFluidGeneratorRecipes(fluidGeneratorRecipeMap);
    }
}

