/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.event;

import com.benbenlaw.utility.config.UtilityStartUpConfig;
import com.benbenlaw.utility.item.UtilityDataComponents;
import com.benbenlaw.utility.item.UtilityItems;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="utility")
public class WorldEvents {
    @SubscribeEvent
    public static void removeEventAfterTesting(PlayerEvent.BreakSpeed event) {
    }

    @SubscribeEvent
    public static void addDeathStoneOnPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide()) {
            if (event.isEndConquered()) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)UtilityItems.DEATH_STONE.get());
            GlobalPos pos = player.getLastDeathLocation().orElse(new GlobalPos(Level.OVERWORLD, BlockPos.ZERO));
            stack.set((DataComponentType)UtilityDataComponents.GLOBAL_POS.get(), (Object)pos);
            if (((Boolean)UtilityStartUpConfig.shouldPlayerGetDeathStoneOnDeath.get()).booleanValue()) {
                if (((GameRules.BooleanValue)Objects.requireNonNull(level.getServer()).getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).get()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stack));
                } else {
                    player.addItem(stack);
                }
            }
        }
    }
}

