/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.integration.jei;

import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.block.UtilityBlocks;
import com.benbenlaw.utility.recipe.DryingTableRecipeType;
import com.benbenlaw.utility.recipe.custom.DryingTableRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingTableRecipeCategory
implements IRecipeCategory<DryingTableRecipe> {
    public static final ResourceLocation UID = Utility.rl("drying_table");
    public static final ResourceLocation TEXTURE = Utility.rl("textures/gui/drying_table_jei.png");
    public static final ResourceLocation WATERLOGGED = Utility.rl("textures/gui/sprites/waterlogged_progress_arrow.png");
    public static final IRecipeType<DryingTableRecipe> RECIPE_TYPE = IRecipeType.create((ResourceLocation)UID, DryingTableRecipe.class);
    private final IDrawable icon;
    private final int width = 66;
    private final int height = 20;

    public DryingTableRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)UtilityBlocks.DRYING_TABLE.get()));
    }

    public int getWidth() {
        return 66;
    }

    public int getHeight() {
        return 20;
    }

    @NotNull
    public IRecipeType<DryingTableRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.utility.drying_table");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingTableRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).add(recipe.input().ingredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 48, 2).add(recipe.output());
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, DryingTableRecipe recipe, @NotNull IFocusGroup focuses) {
        if (recipe.recipeType() == DryingTableRecipeType.DRYING) {
            builder.addAnimatedRecipeArrow(200).setPosition(22, 1);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, DryingTableRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)19, (int)1, (int)0, (int)0, (int)28, (int)18)) {
            if (recipe.recipeType() == DryingTableRecipeType.SOAKING) {
                tooltip.add((FormattedText)Component.translatable((String)"jei.utility.soaking"));
            }
            tooltip.add((FormattedText)Component.literal((String)"10s"));
        }
    }

    public void draw(DryingTableRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, 0.0f, 0.0f, 66, 20, 66, 20);
        if (recipe.recipeType() == DryingTableRecipeType.SOAKING) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, WATERLOGGED, 21, 1, 0.0f, 0.0f, 24, 16, 24, 16);
        }
    }
}

