/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.integration.jei;

import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.block.UtilityBlocks;
import com.benbenlaw.utility.event.ClientRecipeCache;
import com.benbenlaw.utility.integration.jei.DryingTableRecipeCategory;
import com.benbenlaw.utility.integration.jei.FluidGeneratorRecipeCategory;
import com.benbenlaw.utility.integration.jei.GhostFilter;
import com.benbenlaw.utility.integration.jei.ResourceGeneratorRecipeCategory;
import com.benbenlaw.utility.item.UtilityItems;
import com.benbenlaw.utility.screen.breaker.BlockBreakerScreen;
import com.benbenlaw.utility.screen.collector.FluidCollectorScreen;
import com.benbenlaw.utility.screen.drying.DryingTableScreen;
import com.benbenlaw.utility.screen.generator.ResourceGeneratorScreen;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIUtilityPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Utility.rl("jei_plugin");
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        registration.addAlias(UtilityItems.FLOATER.toStack(), "angel_block");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(DryingTableRecipeCategory.RECIPE_TYPE, new ItemStack[]{new ItemStack((ItemLike)UtilityBlocks.DRYING_TABLE.get())});
        registration.addCraftingStation(ResourceGeneratorRecipeCategory.RECIPE_TYPE, new ItemStack[]{new ItemStack((ItemLike)UtilityBlocks.RESOURCE_GENERATOR.get())});
        registration.addCraftingStation(FluidGeneratorRecipeCategory.RECIPE_TYPE, new ItemStack[]{new ItemStack((ItemLike)UtilityBlocks.FLUID_GENERATOR.get())});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DryingTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ResourceGeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidGeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(DryingTableRecipeCategory.RECIPE_TYPE, ClientRecipeCache.getCachedDryingTableRecipes().stream().toList());
        registration.addRecipes(ResourceGeneratorRecipeCategory.RECIPE_TYPE, ClientRecipeCache.getCachedResourceGeneratorRecipes().stream().toList());
        registration.addRecipes(FluidGeneratorRecipeCategory.RECIPE_TYPE, ClientRecipeCache.getCachedFluidGeneratorRecipes().stream().toList());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(DryingTableScreen.class, 76, 34, 24, 17, new IRecipeType[]{DryingTableRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ResourceGeneratorScreen.class, 76, 34, 24, 17, new IRecipeType[]{ResourceGeneratorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(FluidCollectorScreen.class, 76, 34, 24, 17, new IRecipeType[]{FluidGeneratorRecipeCategory.RECIPE_TYPE});
        registration.addGhostIngredientHandler(BlockBreakerScreen.class, (IGhostIngredientHandler)new GhostFilter());
    }
}

