/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.integration.jei;

import com.benbenlaw.core.util.MouseUtil;
import com.benbenlaw.utility.Utility;
import com.benbenlaw.utility.block.UtilityBlocks;
import com.benbenlaw.utility.recipe.custom.ResourceGeneratorRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorRecipeCategory
implements IRecipeCategory<ResourceGeneratorRecipe> {
    public static final ResourceLocation UID = Utility.rl("resource_generator");
    public static final ResourceLocation TEXTURE = Utility.rl("textures/gui/resource_generator_jei.png");
    public static final IRecipeType<ResourceGeneratorRecipe> RECIPE_TYPE = IRecipeType.create((ResourceLocation)UID, ResourceGeneratorRecipe.class);
    private final IDrawable icon;
    private final int width = 104;
    private final int height = 20;

    public ResourceGeneratorRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)UtilityBlocks.RESOURCE_GENERATOR.get()));
    }

    public int getWidth() {
        return 104;
    }

    public int getHeight() {
        return 20;
    }

    @NotNull
    public IRecipeType<ResourceGeneratorRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.utility.resource_generator");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ResourceGeneratorRecipe recipe, @NotNull IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).add(recipe.leftFluid().getFluid())).addRichTooltipCallback((ingredients, tooltip) -> {
            tooltip.add((FormattedText)Component.literal((String)(recipe.leftFluid().getAmount() + "mb")).withStyle(ChatFormatting.GOLD));
            if (recipe.consumeLeft()) {
                tooltip.add((FormattedText)Component.translatable((String)"jei.utility.consumed").withStyle(ChatFormatting.RED));
            }
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 2).add(recipe.input());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).add(recipe.rightFluid().getFluid())).addRichTooltipCallback((ingredients, tooltip) -> {
            tooltip.add((FormattedText)Component.literal((String)(recipe.leftFluid().getAmount() + "mb")).withStyle(ChatFormatting.GOLD));
            if (recipe.consumeRight()) {
                tooltip.add((FormattedText)Component.translatable((String)"jei.utility.consumed").withStyle(ChatFormatting.RED));
            }
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 2).add(recipe.output());
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, ResourceGeneratorRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(200).setPosition(60, 1);
    }

    public void getTooltip(ITooltipBuilder tooltip, ResourceGeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)57, (int)1, (int)0, (int)0, (int)28, (int)18)) {
            tooltip.add((FormattedText)Component.literal((String)"10s"));
        }
    }

    public void draw(ResourceGeneratorRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, 0.0f, 0.0f, 104, 20, 104, 20);
    }
}

