/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.item.custom;

import com.benbenlaw.utility.config.UtilityStartUpConfig;
import com.benbenlaw.utility.item.UtilityDataComponents;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AnimalNetItem
extends Item {
    public AnimalNetItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        boolean isValidTarget;
        Level level = player.level();
        boolean canCaptureHostileMobs = interactionTarget instanceof Monster && (Boolean)UtilityStartUpConfig.animalNetHostileMobs.get() != false;
        boolean canCaptureWaterMobs = interactionTarget instanceof WaterAnimal && (Boolean)UtilityStartUpConfig.animalNetWaterMobs.get() != false;
        boolean canCaptureAnimalMobs = interactionTarget instanceof Animal && (Boolean)UtilityStartUpConfig.animalNetAnimalMobs.get() != false;
        boolean canCaptureVillagerMobs = interactionTarget instanceof Villager && (Boolean)UtilityStartUpConfig.animalNetVillagerMobs.get() != false;
        boolean bl = isValidTarget = canCaptureHostileMobs || canCaptureWaterMobs || canCaptureAnimalMobs || canCaptureVillagerMobs;
        if (!level.isClientSide()) {
            if (isValidTarget) {
                TagValueOutput tagValueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
                interactionTarget.saveWithoutId((ValueOutput)tagValueOutput);
                CompoundTag nbt = tagValueOutput.buildResult();
                stack.set((DataComponentType)UtilityDataComponents.ENTITY_TYPE.get(), (Object)EntityType.getKey((EntityType)interactionTarget.getType()).toString());
                stack.set((DataComponentType)UtilityDataComponents.ENTITY_DATA.get(), (Object)nbt);
                String mobName = interactionTarget.getName().getString();
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.animal_net.mob_caught", (Object[])new Object[]{mobName}).withStyle(ChatFormatting.GREEN), false);
                level.playSound(null, interactionTarget.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                interactionTarget.remove(Entity.RemovalReason.DISCARDED);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.animal_net.mob_cannot_be_caught").withStyle(ChatFormatting.RED), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        assert (player != null);
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        if (!level.isClientSide() && stack.has((DataComponentType)UtilityDataComponents.ENTITY_TYPE.get()) && stack.has((DataComponentType)UtilityDataComponents.ENTITY_DATA.get())) {
            String entityTypeString = (String)stack.get((DataComponentType)UtilityDataComponents.ENTITY_TYPE.get());
            CompoundTag entityData = (CompoundTag)stack.get((DataComponentType)UtilityDataComponents.ENTITY_DATA.get());
            assert (entityTypeString != null);
            EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
            if (entityType != null) {
                Entity entity = entityType.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
                assert (entityData != null);
                ValueInput valueInput = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)entityData);
                assert (entity != null);
                entity.load(valueInput);
                entity.setPos(Vec3.atBottomCenterOf((Vec3i)pos.relative(direction)));
                stack.remove(UtilityDataComponents.ENTITY_TYPE);
                stack.remove(UtilityDataComponents.ENTITY_DATA);
                level.addFreshEntity(entity);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                if (((Boolean)UtilityStartUpConfig.animalNetTakesDamage.get()).booleanValue()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.animal_net.could_not_release").withStyle(ChatFormatting.RED), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> consumer, TooltipFlag flag) {
        if (Minecraft.getInstance().hasShiftDown()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.info").withStyle(ChatFormatting.BLUE));
            if (stack.get((DataComponentType)UtilityDataComponents.ENTITY_TYPE.get()) != null) {
                EntityType entity = EntityType.byString((String)Objects.requireNonNull((String)stack.get((DataComponentType)UtilityDataComponents.ENTITY_TYPE.get()))).orElse(null);
                String mobName = entity != null ? entity.getDescription().getString() : "tooltip.animal_net.unknown_mob";
                consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.contains", (Object[])new Object[]{mobName}).withStyle(ChatFormatting.GREEN));
            } else {
                boolean hostileMobs = (Boolean)UtilityStartUpConfig.animalNetHostileMobs.get();
                boolean waterMobs = (Boolean)UtilityStartUpConfig.animalNetWaterMobs.get();
                boolean animalMobs = (Boolean)UtilityStartUpConfig.animalNetAnimalMobs.get();
                boolean villagerMobs = (Boolean)UtilityStartUpConfig.animalNetVillagerMobs.get();
                consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.mob_types").withStyle(ChatFormatting.BLUE));
                if (hostileMobs) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.hostile_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (waterMobs) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.water_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (animalMobs) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.animal_mobs").withStyle(ChatFormatting.GREEN));
                }
                if (villagerMobs) {
                    consumer.accept((Component)Component.translatable((String)"tooltip.animal_net.villager_mobs").withStyle(ChatFormatting.GREEN));
                }
            }
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

