/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.utility.item.custom;

import com.benbenlaw.core.item.CoreItemUtils;
import com.benbenlaw.utility.config.UtilityStartUpConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CrookItem
extends Item {
    public CrookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        if (state.getBlock() instanceof LeavesBlock || state.is(BlockTags.LEAVES)) {
            int rolls = (Integer)UtilityStartUpConfig.crookRolls.get();
            for (int i = 0; i < rolls; ++i) {
                List blockDrops = Block.getDrops((BlockState)state.getBlock().defaultBlockState(), (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), null, (ItemStack)this.getDefaultInstance());
                for (ItemStack drop : blockDrops) {
                    CoreItemUtils.popItemStack((Level)level, (BlockPos)pos, (ItemStack)drop);
                }
            }
            if (((Boolean)UtilityStartUpConfig.crookTakesDamage.get()).booleanValue()) {
                stack.hurtAndBreak(1, entity, entity.getEquipmentSlotForItem(stack));
            }
        }
        return super.mineBlock(stack, level, state, pos, entity);
    }

    public float getDestroySpeed(@NotNull ItemStack stack, BlockState state) {
        if (state.getBlock() instanceof LeavesBlock || state.is(BlockTags.LEAVES)) {
            return 10.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> consumer, TooltipFlag flag) {
        if (Minecraft.getInstance().hasShiftDown()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.crook.info").withStyle(ChatFormatting.BLUE));
        } else {
            consumer.accept((Component)Component.translatable((String)"tooltip.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

